/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractMarkAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.string.AbstractStringListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TreeWordList;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MarkFastAction
extends AbstractMarkAction {
    private WordListExpression list;
    private AbstractStringListExpression stringList;
    private IBooleanExpression ignore;
    private INumberExpression ignoreLength;
    private IBooleanExpression ignoreWS;

    public MarkFastAction(ITypeExpression type, WordListExpression list, IBooleanExpression ignore, INumberExpression ignoreLength, IBooleanExpression ignoreWS) {
        super(type);
        this.list = list;
        this.ignore = ignore == null ? new SimpleBooleanExpression(false) : ignore;
        this.ignoreLength = ignoreLength == null ? new SimpleNumberExpression(0) : ignoreLength;
        this.ignoreWS = ignoreWS;
    }

    public MarkFastAction(ITypeExpression type, AbstractStringListExpression list, IBooleanExpression ignore, INumberExpression ignoreLength, IBooleanExpression ignoreWS) {
        super(type);
        this.stringList = list;
        this.ignore = ignore == null ? new SimpleBooleanExpression(false) : ignore;
        this.ignoreLength = ignoreLength == null ? new SimpleNumberExpression(0) : ignoreLength;
        this.ignoreWS = ignoreWS;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<AnnotationFS> matchedAnnotationsOf = match.getMatchedAnnotationsOfElement(element);
        boolean ignoreWSValue = this.ignoreWS != null ? this.ignoreWS.getBooleanValue(context, stream) : this.getDictWSParamValue(context);
        for (AnnotationFS annotationFS : matchedAnnotationsOf) {
            RutaStream windowStream = stream.getWindowStream(annotationFS, annotationFS.getType());
            RutaWordList wl = null;
            if (this.list != null) {
                wl = this.list.getList(context, stream);
            } else if (this.stringList != null) {
                wl = new TreeWordList(this.stringList.getList(context, stream), ignoreWSValue);
            }
            if (!(wl instanceof TreeWordList)) continue;
            Collection<AnnotationFS> found = wl.find(windowStream, this.ignore.getBooleanValue(context, stream), this.ignoreLength.getIntegerValue(context, stream), null, 0, ignoreWSValue);
            for (AnnotationFS annotation : found) {
                this.createAnnotation(annotation, context, windowStream);
            }
        }
    }

    public WordListExpression getList() {
        return this.list;
    }

    public AbstractStringListExpression getStringList() {
        return this.stringList;
    }

    public IBooleanExpression getIgnore() {
        return this.ignore;
    }

    public INumberExpression getIgnoreLength() {
        return this.ignoreLength;
    }

    public IBooleanExpression getIgnoreWS() {
        return this.ignoreWS;
    }
}

