/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;

public class EditDistanceCostMap {
    private Map<Character, Double> insertMap;
    private Map<Character, Double> deleteMap;
    private Map<Character, Map<Character, Double>> replaceMap;
    private Double minimalCosts;
    private double defaultCosts;

    public EditDistanceCostMap() {
        this(1.0);
    }

    public EditDistanceCostMap(double defaultCosts) {
        this(defaultCosts, new HashMap<Character, Double>(), new HashMap<Character, Double>(), new HashMap<Character, Map<Character, Double>>());
    }

    public EditDistanceCostMap(double defaultCosts, Map<Character, Double> insertMap, Map<Character, Double> deleteMap, Map<Character, Map<Character, Double>> replaceMap) {
        this.defaultCosts = defaultCosts;
        this.minimalCosts = defaultCosts;
        this.deleteMap = deleteMap;
        this.insertMap = insertMap;
        this.replaceMap = replaceMap;
    }

    public boolean export(String file) {
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter(new File(file)));
            br.write("\"defaultcosts\";\"" + this.defaultCosts + "\";\n");
            for (Character c : this.insertMap.keySet()) {
                br.write("\"insert\";\"" + c + "\";\"" + this.getInsertCosts(c.charValue()) + "\";\n");
            }
            for (Character c : this.deleteMap.keySet()) {
                br.write("\"delete\";\"" + c + "\";\"" + this.getDeleteCosts(c.charValue()) + "\";\n");
            }
            for (Character c : this.replaceMap.keySet()) {
                Map<Character, Double> replace = this.replaceMap.get(c);
                for (Character d : replace.keySet()) {
                    br.write("\"replace\";\"" + c + "\";\"" + d + "\";\"" + this.getReplaceCosts(c.charValue(), d.charValue()) + "\";\n");
                }
            }
            br.flush();
            br.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read(String file) {
        BufferedReader br = null;
        String temp = null;
        String[] line = null;
        boolean retValue = true;
        this.insertMap.clear();
        this.deleteMap.clear();
        this.replaceMap.clear();
        try {
            br = new BufferedReader(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, "File not found: " + file, (Throwable)e);
            return false;
        }
        try {
            while ((temp = br.readLine()) != null) {
                line = temp.split(";");
                try {
                    char[] cArray;
                    for (int i = 0; i < line.length; ++i) {
                        if (line[i].startsWith("\"")) {
                            line[i] = line[i].substring(1);
                        }
                        if (!line[i].endsWith("\"")) continue;
                        line[i] = line[i].substring(0, line[i].length() - 1);
                    }
                    if (line[0].equals("insert") || line[0].equals("delete")) {
                        line[2] = line[2].replaceAll(",", ".");
                        double value = Double.parseDouble(line[2]);
                        cArray = line[1].toCharArray();
                        if (cArray.length != 1) {
                            retValue = false;
                            continue;
                        }
                        if (line[0].equals("delete")) {
                            this.setDeleteCosts(cArray[0], value);
                            continue;
                        }
                        this.setInsertCosts(cArray[0], value);
                        continue;
                    }
                    if (line[0].equals("replace")) {
                        line[3] = line[3].replaceAll(",", ".");
                        double value = Double.parseDouble(line[3]);
                        cArray = line[1].toCharArray();
                        char[] dArray = line[2].toCharArray();
                        if (cArray.length != 1 || dArray.length != 1) {
                            retValue = false;
                            continue;
                        }
                        this.setReplaceCosts(cArray[0], dArray[0], value);
                        continue;
                    }
                    if (line[0].equals("defaultcosts")) {
                        double value;
                        line[1] = line[1].replaceAll(",", ".");
                        this.defaultCosts = value = Double.parseDouble(line[1]);
                        continue;
                    }
                    retValue = false;
                }
                catch (StringIndexOutOfBoundsException e) {
                    retValue = false;
                }
                catch (IndexOutOfBoundsException e) {
                    retValue = false;
                }
                catch (NumberFormatException e) {
                    retValue = false;
                }
            }
            br.close();
        }
        catch (IOException e) {
            return false;
        }
        this.registerMinimalCosts();
        return retValue;
    }

    public double getInsertCosts(char c) {
        if (this.insertMap.get(Character.valueOf(c)) == null) {
            return this.defaultCosts;
        }
        return this.insertMap.get(Character.valueOf(c));
    }

    public double getDeleteCosts(char c) {
        if (this.deleteMap.get(Character.valueOf(c)) == null) {
            return this.defaultCosts;
        }
        return this.deleteMap.get(Character.valueOf(c));
    }

    public double getReplaceCosts(char c, char d) {
        if (this.replaceMap.get(Character.valueOf(c)) == null) {
            return this.defaultCosts;
        }
        Map<Character, Double> cMap = this.replaceMap.get(Character.valueOf(c));
        if (cMap.get(Character.valueOf(d)) == null) {
            return this.defaultCosts;
        }
        return cMap.get(Character.valueOf(d));
    }

    public void setInsertCosts(char c, double value) {
        this.insertMap.put(Character.valueOf(c), value);
        this.registerMinimalCosts();
    }

    public void setDeleteCosts(char c, double value) {
        this.deleteMap.put(Character.valueOf(c), value);
        this.registerMinimalCosts();
    }

    public void setReplaceCosts(char c, char d, double value) {
        if (this.replaceMap.get(Character.valueOf(c)) == null) {
            this.replaceMap.put(Character.valueOf(c), new HashMap());
        }
        this.replaceMap.get(Character.valueOf(c)).put(Character.valueOf(d), value);
        this.registerMinimalCosts();
    }

    private void registerMinimalCosts() {
        for (Double d : this.deleteMap.values()) {
            this.minimalCosts = Math.min(this.minimalCosts, d);
        }
        for (Double d : this.insertMap.values()) {
            this.minimalCosts = Math.min(this.minimalCosts, d);
        }
        for (Map map : this.replaceMap.values()) {
            for (Double d : map.values()) {
                this.minimalCosts = Math.min(this.minimalCosts, d);
            }
        }
    }

    public double getMinimalCosts() {
        return this.minimalCosts;
    }

    public double getDefaultCosts() {
        return this.defaultCosts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.defaultCosts);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.deleteMap == null ? 0 : this.deleteMap.hashCode());
        result = 31 * result + (this.insertMap == null ? 0 : this.insertMap.hashCode());
        result = 31 * result + (this.replaceMap == null ? 0 : this.replaceMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditDistanceCostMap other = (EditDistanceCostMap)obj;
        if (Double.doubleToLongBits(this.defaultCosts) != Double.doubleToLongBits(other.defaultCosts)) {
            return false;
        }
        if (this.deleteMap == null ? other.deleteMap != null : !this.deleteMap.equals(other.deleteMap)) {
            return false;
        }
        if (this.insertMap == null ? other.insertMap != null : !this.insertMap.equals(other.insertMap)) {
            return false;
        }
        return !(this.replaceMap == null ? other.replaceMap != null : !this.replaceMap.equals(other.replaceMap));
    }
}

