/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.Secret;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConfigMappingGenerator {
    static final boolean usefulDebugInfo;
    private static final Pattern ARRAY_FORMAT_REGEX;
    private static final String I_CLASS;
    private static final String I_FIELD;
    private static final String I_MAPPING_CONTEXT;
    private static final String I_OBJECT_CREATOR;
    private static final String I_NAMING_STRATEGY;
    private static final String I_STRING_BUILDER;
    private static final String I_RUNTIME_EXCEPTION;
    private static final String I_OBJECT;
    private static final String I_STRING;
    private static final String I_ITERABLE;
    private static final int V_THIS = 0;
    private static final int V_MAPPING_CONTEXT = 1;
    private static final String D_MAPPING_CONTEXT;
    private static final String D_OBJECT_CREATOR;
    private static final String D_CLASS;
    private static final String D_OBJECT;
    private static final String D_STRING;
    private static final String D_INTEGER;
    private static final String D_BOOLEAN;
    private static final String D_OPTIONAL;
    private static final String D_MAP;
    private static final String D_COLLECTION;
    private static final String D_ITERABLE;
    private static final String D_SECRET;

    static byte[] generate(ConfigMappingInterface mapping) {
        ClassWriter writer = new ClassWriter(3);
        Object visitor = usefulDebugInfo ? new Debugging.ClassVisitorImpl(writer) : writer;
        visitor.visit(52, 1, mapping.getClassInternalName(), null, I_OBJECT, new String[]{Type.getInternalName(mapping.getInterfaceType())});
        visitor.visitSource(null, null);
        MethodVisitor noArgsCtor = visitor.visitMethod(1, "<init>", "()V", null, null);
        noArgsCtor.visitVarInsn(25, 0);
        noArgsCtor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        noArgsCtor.visitInsn(177);
        noArgsCtor.visitEnd();
        noArgsCtor.visitMaxs(0, 0);
        ObjectCreatorMethodVisitor ctor = new ObjectCreatorMethodVisitor(visitor.visitMethod(1, "<init>", "(L" + I_MAPPING_CONTEXT + ";)V", null, null));
        ctor.visitParameter("context", 16);
        Label ctorStart = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        if (mapping.hasConfigMapping()) {
            ctor.visitVarInsn(25, 1);
            ctor.visitFieldInsn(178, I_NAMING_STRATEGY, mapping.getNamingStrategy().name(), "L" + I_NAMING_STRATEGY + ";");
            ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "applyNamingStrategy", "(L" + I_NAMING_STRATEGY + ";)V", false);
            ctor.visitVarInsn(25, 1);
            ctor.visitInsn(mapping.isBeanStyleGetters() ? 4 : 3);
            ctor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "applyBeanStyleGetters", "(Ljava/lang/Boolean;)V", false);
        }
        ConfigMappingGenerator.addProperties((ClassVisitor)visitor, ctor, mapping);
        ctor.visitInsn(177);
        Label ctorEnd = new Label();
        ctor.visitLabel(ctorEnd);
        ctor.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, ctorStart, ctorEnd, 1);
        ctor.visitEnd();
        ctor.visitMaxs(0, 0);
        visitor.visitEnd();
        ConfigMappingGenerator.generateStaticInit((ClassVisitor)visitor, mapping);
        ConfigMappingGenerator.generateEquals((ClassVisitor)visitor, mapping);
        ConfigMappingGenerator.generateHashCode((ClassVisitor)visitor, mapping);
        ConfigMappingGenerator.generateToString((ClassVisitor)visitor, mapping);
        return writer.toByteArray();
    }

    static byte[] generate(Class<?> classType, String interfaceName) {
        Field[] declaredFields;
        Object classInstance;
        String classInternalName = Type.getInternalName(classType);
        String interfaceInternalName = interfaceName.replace('.', '/');
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1537, interfaceInternalName, null, I_OBJECT, new String[]{Type.getInternalName(ConfigMappingClassMapper.class)});
        AnnotationVisitor av = writer.visitAnnotation("L" + Type.getInternalName(ConfigMapping.class) + ";", true);
        av.visitEnum("namingStrategy", "L" + Type.getInternalName(ConfigMapping.NamingStrategy.class) + ";", ConfigMapping.NamingStrategy.VERBATIM.toString());
        if (classType.isAnnotationPresent(ConfigProperties.class)) {
            av.visit("prefix", (Object)classType.getAnnotation(ConfigProperties.class).prefix());
        }
        av.visitEnd();
        try {
            classInstance = classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (Field declaredField : declaredFields = classType.getDeclaredFields()) {
            AnnotationVisitor av2;
            AnnotationVisitor av3;
            MethodVisitor mv = writer.visitMethod(1025, declaredField.getName(), Type.getMethodDescriptor((Type)Type.getType(declaredField.getType()), (Type[])new Type[0]), ConfigMappingGenerator.getSignature(declaredField), null);
            boolean hasDefault = false;
            if (declaredField.isAnnotationPresent(WithName.class)) {
                av3 = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                av3.visit("value", (Object)declaredField.getAnnotation(WithName.class).value());
                av3.visitEnd();
            }
            if (declaredField.isAnnotationPresent(WithDefault.class)) {
                av3 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                av3.visit("value", (Object)declaredField.getAnnotation(WithDefault.class).value());
                av3.visitEnd();
                hasDefault = true;
            }
            if (declaredField.isAnnotationPresent(WithConverter.class)) {
                av3 = mv.visitAnnotation("L" + Type.getInternalName(WithConverter.class) + ";", true);
                av3.visit("value", declaredField.getAnnotation(WithConverter.class).value());
                av3.visitEnd();
            }
            if (declaredField.isAnnotationPresent(ConfigProperty.class)) {
                ConfigProperty configProperty = declaredField.getAnnotation(ConfigProperty.class);
                if (!configProperty.name().isEmpty()) {
                    av2 = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                    av2.visit("value", (Object)configProperty.name());
                    av2.visitEnd();
                }
                if (!configProperty.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                    av2 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                    av2.visit("value", (Object)configProperty.defaultValue());
                    av2.visitEnd();
                    hasDefault = true;
                }
            }
            if (!hasDefault) {
                try {
                    declaredField.setAccessible(true);
                    Object defaultValue = declaredField.get(classInstance);
                    if (ConfigMappingGenerator.hasDefaultValue(declaredField.getType(), defaultValue)) {
                        av2 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                        av2.visit("value", (Object)defaultValue.toString());
                        av2.visitEnd();
                    }
                }
                catch (IllegalAccessException defaultValue) {
                    // empty catch block
                }
            }
            mv.visitEnd();
        }
        MethodVisitor ctor = writer.visitMethod(1, "map", "()L" + I_OBJECT + ";", null, null);
        Label ctorStart = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitTypeInsn(187, classInternalName);
        ctor.visitInsn(89);
        ctor.visitMethodInsn(183, classInternalName, "<init>", "()V", false);
        ctor.visitVarInsn(58, 1);
        for (Field declaredField : declaredFields) {
            if (Modifier.isStatic(declaredField.getModifiers()) || Modifier.isVolatile(declaredField.getModifiers()) || Modifier.isFinal(declaredField.getModifiers())) continue;
            String name = declaredField.getName();
            Class<?> type = declaredField.getType();
            if (Modifier.isPublic(declaredField.getModifiers())) {
                ctor.visitVarInsn(25, 1);
                ctor.visitVarInsn(25, 0);
                ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
                ctor.visitFieldInsn(181, classInternalName, name, Type.getDescriptor(type));
                continue;
            }
            ctor.visitLdcInsn((Object)Type.getType(classType));
            ctor.visitLdcInsn((Object)name);
            ctor.visitMethodInsn(182, I_CLASS, "getDeclaredField", Type.getMethodDescriptor((Type)Type.getType(Field.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            ctor.visitVarInsn(58, 2);
            ctor.visitVarInsn(25, 2);
            ctor.visitInsn(4);
            ctor.visitMethodInsn(182, I_FIELD, "setAccessible", "(Z)V", false);
            ctor.visitVarInsn(25, 2);
            ctor.visitVarInsn(25, 1);
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
            switch (Type.getType(type).getSort()) {
                case 1: {
                    ctor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    ctor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    ctor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    ctor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    ctor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 6: {
                    ctor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 7: {
                    ctor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 8: {
                    ctor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                }
            }
            ctor.visitMethodInsn(182, I_FIELD, "set", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), false);
        }
        ctor.visitVarInsn(25, 1);
        ctor.visitInsn(176);
        ctor.visitMaxs(2, 2);
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static void addProperties(ClassVisitor cv, ObjectCreatorMethodVisitor ctor, ConfigMappingInterface mapping) {
        String memberName;
        Method method;
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            method = property.getMethod();
            memberName = method.getName();
            String fieldType = Type.getInternalName(method.getReturnType());
            String fieldDesc = Type.getDescriptor(method.getReturnType());
            cv.visitField(2, memberName, fieldDesc, null, null);
            MethodVisitor mv = cv.visitMethod(1, memberName, "()" + fieldDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, mapping.getClassInternalName(), memberName, fieldDesc);
            mv.visitInsn(ConfigMappingGenerator.getReturnInstruction(property));
            mv.visitEnd();
            mv.visitMaxs(0, 0);
            if (property.isDefaultMethod()) continue;
            Label _try = new Label();
            Label _catch = new Label();
            Label _continue = new Label();
            ctor.visitTryCatchBlock(_try, _catch, _catch, I_RUNTIME_EXCEPTION);
            ctor.visitLabel(_try);
            ctor.visitVarInsn(25, 0);
            ConfigMappingGenerator.generateProperty(ctor, property);
            ctor.visitCast(property, fieldType);
            ctor.visitFieldInsn(181, mapping.getClassInternalName(), memberName, fieldDesc);
            ctor.visitJumpInsn(167, _continue);
            ctor.visitLabel(_catch);
            ctor.visitVarInsn(25, 1);
            ctor.visitInsn(95);
            ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "problem", "(L" + I_RUNTIME_EXCEPTION + ";)V", false);
            ctor.visitJumpInsn(167, _continue);
            ctor.visitLabel(_continue);
        }
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            method = property.getMethod();
            memberName = method.getName();
            String fieldDesc = Type.getDescriptor(method.getReturnType());
            if (!property.isDefaultMethod()) continue;
            ctor.visitVarInsn(25, 0);
            Method defaultMethod = property.asDefaultMethod().getDefaultMethod();
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(184, Type.getInternalName(defaultMethod.getDeclaringClass()), defaultMethod.getName(), "(" + Type.getType(mapping.getInterfaceType()) + ")" + fieldDesc, false);
            ctor.visitFieldInsn(181, mapping.getClassInternalName(), memberName, fieldDesc);
        }
    }

    private static void generateProperty(ObjectCreatorMethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isPrimitive()) {
            ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            if (!primitiveProperty.hasConvertWith() && primitiveProperty.getPrimitiveType() == Integer.TYPE) {
                ctor.visitMethod(PrimitiveMethodInvocation.intValue);
            } else if (!primitiveProperty.hasConvertWith() && primitiveProperty.getPrimitiveType() == Boolean.TYPE) {
                ctor.visitMethod(PrimitiveMethodInvocation.boolValue);
            } else {
                ctor.visitLdcInsn(Type.getType(primitiveProperty.getBoxType()));
                ctor.visitConverter(primitiveProperty);
                ctor.visitMethod(PrimitiveMethodInvocation.value);
            }
        } else if (property.isLeaf() && !property.isOptional()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            if (!leafProperty.hasConvertWith() && leafProperty.getValueType() == String.class) {
                ctor.visitMethod(ObjectMethodInvocation.stringValue);
            } else if (!leafProperty.hasConvertWith() && leafProperty.getValueRawType() == Integer.class) {
                ctor.visitMethod(ObjectMethodInvocation.integerValue);
            } else if (!leafProperty.hasConvertWith() && leafProperty.getValueRawType() == Boolean.class) {
                ctor.visitMethod(ObjectMethodInvocation.booleanValue);
            } else {
                ctor.visitLdcInsn(Type.getType(leafProperty.getValueRawType()));
                ctor.visitConverter(leafProperty);
                ctor.visitMethod(property.isSecret() ? ObjectMethodInvocation.secretValue : ObjectMethodInvocation.value);
            }
        } else if (property.isOptional() && property.isLeaf()) {
            ConfigMappingInterface.LeafProperty optionalProperty = property.asLeaf();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            if (!optionalProperty.hasConvertWith() && !optionalProperty.isSecret() && optionalProperty.getValueRawType() == String.class) {
                ctor.visitMethod(ObjectMethodInvocation.optionalStringValue);
            } else {
                ctor.visitLdcInsn(Type.getType(optionalProperty.getValueRawType()));
                ctor.visitConverter(optionalProperty);
                ctor.visitMethod(optionalProperty.isSecret() ? ObjectMethodInvocation.optionalSecretValue : ObjectMethodInvocation.optionalValue);
            }
        } else if (property.isMap() && property.asMap().getValueProperty().isLeaf()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            ctor.visitLdcInsn(Type.getType(mapProperty.getKeyRawType()));
            ctor.visitKeyConverter(mapProperty);
            ctor.visitInsn(valueProperty.isOptional() ? 4 : 3);
            ctor.visitLdcInsn(Type.getType(valueProperty.asLeaf().getValueRawType()));
            ctor.visitConverter(valueProperty.asLeaf());
            ctor.visitKeyProvider(mapProperty);
            ctor.visitDefault(mapProperty);
            ctor.visitMethod(valueProperty.isSecret() ? MapMethodInvocation.secretValues : MapMethodInvocation.values);
        } else if (property.isMap() && property.asMap().getValueProperty().isCollection() && property.asMap().getValueProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            ctor.visitLdcInsn(Type.getType(mapProperty.getKeyRawType()));
            ctor.visitKeyConverter(mapProperty);
            ConfigMappingInterface.LeafProperty elementProperty = valueProperty.asCollection().getElement().asLeaf();
            ctor.visitLdcInsn(Type.getType(elementProperty.getValueRawType()));
            ctor.visitConverter(elementProperty);
            ctor.visitLdcInsn(Type.getType(valueProperty.asCollection().getCollectionRawType()));
            ctor.visitKeyProvider(mapProperty);
            ctor.visitDefault(mapProperty);
            ctor.visitMethod(elementProperty.isSecret() ? MapCollectionInvocation.secretValues : MapCollectionInvocation.values);
        } else if (property.isCollection() && property.asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            ConfigMappingInterface.LeafProperty elementProperty = collectionProperty.getElement().asLeaf();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            ctor.visitLdcInsn(Type.getType(elementProperty.getValueRawType()));
            ctor.visitConverter(elementProperty);
            ctor.visitLdcInsn(Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethod(elementProperty.isSecret() ? CollectionMethodInvocation.secretValues : CollectionMethodInvocation.values);
        } else if (property.isOptional() && property.asOptional().getNestedProperty().isCollection() && property.asOptional().getNestedProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asOptional().getNestedProperty().asCollection();
            ConfigMappingInterface.LeafProperty elementProperty = collectionProperty.getElement().asLeaf();
            ctor.visitVarInsn(25, 1);
            ctor.visitPropertyName(property);
            ctor.visitLdcInsn(Type.getType(elementProperty.getValueRawType()));
            ctor.visitConverter(elementProperty);
            ctor.visitLdcInsn(Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethod(elementProperty.isSecret() ? CollectionMethodInvocation.optionalSecretValues : CollectionMethodInvocation.optionalValues);
        } else {
            ctor.visitTypeInsn(187, I_OBJECT_CREATOR);
            ctor.visitInsn(89);
            ctor.visitVarInsn(25, 1);
            ctor.visitLdcInsn(property.getPropertyName());
            ctor.visitInsn(property.hasPropertyName() ? 3 : 4);
            ctor.visitMethodInsn(183, I_OBJECT_CREATOR, "<init>", "(" + D_MAPPING_CONTEXT + D_STRING + "Z)V", false);
            ConfigMappingGenerator.generateNestedProperty(ctor, property);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateNestedProperty(ObjectCreatorMethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isGroup()) {
            ctor.visitLdcInsn(Type.getType(property.asGroup().getGroupType().getInterfaceType()));
            ctor.visitMethod(ObjectCreatorInvocation.group);
            ctor.visitMethod(ObjectCreatorInvocation.get);
            return;
        } else if (property.isMap() && property.asMap().getValueProperty().isLeaf()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitLdcInsn(Type.getType(mapProperty.getKeyRawType()));
            ctor.visitKeyConverter(mapProperty);
            ConfigMappingInterface.LeafProperty leafProperty = valueProperty.asLeaf();
            ctor.visitLdcInsn(Type.getType(leafProperty.getValueRawType()));
            ctor.visitConverter(leafProperty);
            ctor.visitKeyProvider(mapProperty);
            ctor.visitDefault(mapProperty);
            ctor.visitMethod(ObjectCreatorMapInvocation.values);
            ctor.visitMethod(ObjectCreatorInvocation.get);
            return;
        } else if (property.isMap() && property.asMap().getValueProperty().isCollection() && property.asMap().getValueProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitLdcInsn(Type.getType(mapProperty.getKeyRawType()));
            ctor.visitKeyConverter(mapProperty);
            ConfigMappingInterface.LeafProperty leafProperty = valueProperty.asCollection().getElement().asLeaf();
            ctor.visitLdcInsn(Type.getType(leafProperty.getValueRawType()));
            ctor.visitConverter(leafProperty);
            ctor.visitLdcInsn(Type.getType(valueProperty.asCollection().getCollectionRawType()));
            ctor.visitKeyProvider(mapProperty);
            ctor.visitDefault(mapProperty);
            ctor.visitMethod(ObjectCreatorInvocation.values);
            ctor.visitMethod(ObjectCreatorInvocation.get);
            return;
        } else if (property.isOptional() && property.asOptional().getNestedProperty().isCollection() && property.asOptional().getNestedProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asOptional().getNestedProperty().asCollection();
            ctor.visitLdcInsn(Type.getType(collectionProperty.getElement().asLeaf().getValueRawType()));
            ctor.visitConverter(collectionProperty.getElement().asLeaf());
            ctor.visitLdcInsn(Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethod(ObjectCreatorInvocation.optionalValues);
            ctor.visitMethod(ObjectCreatorInvocation.get);
            return;
        } else if (property.isMap()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            if (valueProperty.isGroup()) {
                ctor.visitLdcInsn(Type.getType(mapProperty.getKeyRawType()));
                ctor.visitKeyConverter(mapProperty);
                ctor.visitKeyUnnamed(mapProperty);
                ctor.visitKeyProvider(mapProperty);
                if (mapProperty.hasDefaultValue()) {
                    ctor.visitLdcInsn(Type.getType(valueProperty.asGroup().getGroupType().getInterfaceType()));
                } else {
                    ctor.visitInsn(1);
                }
                ctor.visitMethod(ObjectCreatorMapGroupInvocation.map);
                ctor.visitLdcInsn(Type.getType(valueProperty.asGroup().getGroupType().getInterfaceType()));
                ctor.visitMethod(mapProperty.hasKeyProvider() ? ObjectCreatorInvocation.group : ObjectCreatorInvocation.lazyGroup);
                ctor.visitMethod(ObjectCreatorInvocation.get);
                return;
            } else {
                ConfigMappingGenerator.unwrapNestedProperty(ctor, property);
            }
            return;
        } else if (property.isCollection()) {
            ConfigMappingGenerator.unwrapNestedProperty(ctor, property);
            return;
        } else {
            if (!property.isOptional()) throw new UnsupportedOperationException();
            ConfigMappingInterface.MayBeOptionalProperty nestedProperty = property.asOptional().getNestedProperty();
            if (nestedProperty.isGroup()) {
                ctor.visitLdcInsn(Type.getType(nestedProperty.asGroup().getGroupType().getInterfaceType()));
                ctor.visitMethod(ObjectCreatorInvocation.optionalGroup);
                ctor.visitMethod(ObjectCreatorInvocation.get);
                return;
            } else {
                if (!nestedProperty.isCollection()) throw new UnsupportedOperationException();
                ConfigMappingInterface.CollectionProperty collectionProperty = nestedProperty.asCollection();
                ctor.visitLdcInsn(Type.getType(collectionProperty.getCollectionRawType()));
                ctor.visitMethod(ObjectCreatorInvocation.optionalCollection);
                ConfigMappingGenerator.generateNestedProperty(ctor, collectionProperty.getElement());
            }
        }
    }

    private static void unwrapNestedProperty(ObjectCreatorMethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isMap()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ctor.visitLdcInsn(Type.getType(mapProperty.getKeyRawType()));
            ctor.visitKeyConverter(mapProperty);
            ctor.visitKeyUnnamed(mapProperty);
            ctor.visitKeyProvider(mapProperty);
            ctor.visitMethod(ObjectCreatorInvocation.map);
            ConfigMappingGenerator.generateNestedProperty(ctor, mapProperty.getValueProperty());
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            ctor.visitLdcInsn(Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethod(ObjectCreatorInvocation.collection);
            ConfigMappingGenerator.generateNestedProperty(ctor, collectionProperty.getElement());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static int getReturnInstruction(ConfigMappingInterface.Property property) {
        ConfigMappingInterface.PrimitiveProperty primitiveProperty;
        if (property.isPrimitive()) {
            primitiveProperty = property.asPrimitive();
        } else if (property.isDefaultMethod() && property.asDefaultMethod().getDefaultProperty().isPrimitive()) {
            primitiveProperty = property.asDefaultMethod().getDefaultProperty().asPrimitive();
        } else {
            return 176;
        }
        if (primitiveProperty.getPrimitiveType() == Float.TYPE) {
            return 174;
        }
        if (primitiveProperty.getPrimitiveType() == Double.TYPE) {
            return 175;
        }
        if (primitiveProperty.getPrimitiveType() == Long.TYPE) {
            return 173;
        }
        return 172;
    }

    private static String getSignature(Field field) {
        String typeName = field.getGenericType().getTypeName();
        if (typeName.indexOf(60) != -1 && typeName.indexOf(62) != -1) {
            String signature = "()L" + typeName.replace(".", "/");
            signature = signature.replace("<", "<L");
            signature = signature.replace(", ", ";L");
            signature = signature.replace(">", ";>");
            signature = signature + ";";
            if (typeName.contains("[]")) {
                signature = ARRAY_FORMAT_REGEX.matcher(signature).replaceAll("$1[L$2;");
            }
            return signature;
        }
        return null;
    }

    private static void generateToString(ClassVisitor visitor, ConfigMappingInterface mapping) {
        if (!mapping.getToStringMethod().generate()) {
            return;
        }
        MethodVisitor ts = visitor.visitMethod(1, "toString", "()L" + I_STRING + ";", null, null);
        ts.visitCode();
        ts.visitTypeInsn(187, I_STRING_BUILDER);
        ts.visitInsn(89);
        ts.visitMethodInsn(183, I_STRING_BUILDER, "<init>", "()V", false);
        ts.visitLdcInsn((Object)(mapping.getInterfaceType().getSimpleName() + "{"));
        ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
        ConfigMappingInterface.Property[] properties = mapping.getProperties();
        int propertiesLength = properties.length;
        for (int i = 0; i < propertiesLength; ++i) {
            ConfigMappingInterface.Property property = properties[i];
            if (ConfigMappingGenerator.isSecret(property)) continue;
            if (property.isDefaultMethod()) {
                property = property.asDefaultMethod().getDefaultProperty();
            }
            String member = property.getMethod().getName();
            ts.visitLdcInsn((Object)(member + "="));
            ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
            ts.visitVarInsn(25, 0);
            ts.visitFieldInsn(180, mapping.getClassInternalName(), member, Type.getDescriptor(property.getMethod().getReturnType()));
            if (property.isPrimitive()) {
                ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(" + Type.getDescriptor(property.asPrimitive().getPrimitiveType()) + ")L" + I_STRING_BUILDER + ";", false);
            } else {
                ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_OBJECT + ";)L" + I_STRING_BUILDER + ";", false);
            }
            if (i + 1 >= propertiesLength) continue;
            ts.visitLdcInsn((Object)", ");
            ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
        }
        ts.visitLdcInsn((Object)"}");
        ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
        ts.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ";", false);
        ts.visitInsn(176);
        ts.visitEnd();
        ts.visitMaxs(0, 0);
    }

    private static void generateEquals(ClassVisitor visitor, ConfigMappingInterface mapping) {
        MethodVisitor eq = visitor.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        eq.visitCode();
        int V_O = 1;
        int V_THAT = 2;
        eq.visitVarInsn(25, 0);
        eq.visitVarInsn(25, V_O);
        Label _ifRef = new Label();
        eq.visitJumpInsn(166, _ifRef);
        eq.visitInsn(4);
        eq.visitInsn(172);
        eq.visitLabel(_ifRef);
        eq.visitVarInsn(25, V_O);
        Label _ifNull = new Label();
        eq.visitJumpInsn(198, _ifNull);
        eq.visitVarInsn(25, 0);
        Label _ifClass = new Label();
        eq.visitMethodInsn(182, I_OBJECT, "getClass", "()L" + I_CLASS + ";", false);
        eq.visitVarInsn(25, V_O);
        eq.visitMethodInsn(182, I_OBJECT, "getClass", "()L" + I_CLASS + ";", false);
        eq.visitJumpInsn(165, _ifClass);
        eq.visitLabel(_ifNull);
        eq.visitFrame(3, 0, null, 0, null);
        eq.visitInsn(3);
        eq.visitInsn(172);
        eq.visitLabel(_ifClass);
        eq.visitVarInsn(25, V_O);
        eq.visitTypeInsn(192, mapping.getClassInternalName());
        eq.visitVarInsn(58, V_THAT);
        Label _ifTrue = new Label();
        Label _ifFalse = new Label();
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            if (property.isDefaultMethod()) {
                property = property.asDefaultMethod().getDefaultProperty();
            }
            String member = property.getMethod().getName();
            Class<?> returnType = property.getMethod().getReturnType();
            eq.visitVarInsn(25, 0);
            eq.visitMethodInsn(182, mapping.getClassInternalName(), member, "()" + Type.getDescriptor(returnType), false);
            eq.visitVarInsn(25, V_THAT);
            eq.visitMethodInsn(182, mapping.getClassInternalName(), member, "()" + Type.getDescriptor(returnType), false);
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                if (primitiveProperty.getPrimitiveType() == Float.TYPE) {
                    eq.visitInsn(149);
                    eq.visitJumpInsn(154, _ifFalse);
                    continue;
                }
                if (primitiveProperty.getPrimitiveType() == Double.TYPE) {
                    eq.visitInsn(151);
                    eq.visitJumpInsn(154, _ifFalse);
                    continue;
                }
                if (primitiveProperty.getPrimitiveType() == Long.TYPE) {
                    eq.visitInsn(148);
                    eq.visitJumpInsn(154, _ifFalse);
                    continue;
                }
                eq.visitJumpInsn(160, _ifFalse);
                continue;
            }
            eq.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            eq.visitJumpInsn(153, _ifFalse);
        }
        eq.visitInsn(4);
        eq.visitJumpInsn(167, _ifTrue);
        eq.visitLabel(_ifFalse);
        eq.visitInsn(3);
        eq.visitLabel(_ifTrue);
        eq.visitInsn(172);
        eq.visitEnd();
        eq.visitMaxs(0, 0);
    }

    private static void generateHashCode(ClassVisitor visitor, ConfigMappingInterface mapping) {
        MethodVisitor hc = visitor.visitMethod(1, "hashCode", "()I", null, null);
        hc.visitCode();
        ConfigMappingInterface.Property[] properties = mapping.getProperties();
        hc.visitIntInsn(16, properties.length);
        hc.visitTypeInsn(189, I_OBJECT);
        hc.visitInsn(89);
        for (int i = 0; i < properties.length; ++i) {
            ConfigMappingInterface.Property property = properties[i];
            if (property.isDefaultMethod()) {
                property = property.asDefaultMethod().getDefaultProperty();
            }
            String member = property.getMethod().getName();
            Class<?> returnType = property.getMethod().getReturnType();
            hc.visitIntInsn(16, i);
            hc.visitVarInsn(25, 0);
            hc.visitFieldInsn(180, mapping.getClassInternalName(), member, Type.getDescriptor(returnType));
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                hc.visitMethodInsn(184, Type.getInternalName(primitiveProperty.getBoxType()), "valueOf", "(" + Type.getDescriptor(primitiveProperty.getPrimitiveType()) + ")" + Type.getDescriptor(primitiveProperty.getBoxType()), false);
            }
            hc.visitInsn(83);
            hc.visitInsn(89);
        }
        hc.visitMethodInsn(184, "java/util/Objects", "hash", "([Ljava/lang/Object;)I", false);
        hc.visitInsn(172);
        hc.visitMaxs(0, 0);
        hc.visitEnd();
    }

    private static void generateStaticInit(ClassVisitor classVisitor, ConfigMappingInterface mapping) {
        Map<String, ConfigMappingInterface.Property> properties = ConfigMappingInterface.getProperties(mapping).get(mapping.getInterfaceType()).get("");
        classVisitor.visitField(26, "PROPERTIES", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", null).visitEnd();
        classVisitor.visitField(26, "SECRETS", "Ljava/util/Set;", "Ljava/util/Set<Ljava/lang/String;>;", null).visitEnd();
        MethodVisitor clinit = classVisitor.visitMethod(8, "<clinit>", "()V", null, null);
        clinit.visitTypeInsn(187, "java/util/HashMap");
        clinit.visitInsn(89);
        if (properties.size() < 3) {
            clinit.visitIntInsn(16, properties.size() + 1);
        } else {
            clinit.visitIntInsn(17, (int)((float)properties.size() / 0.75f + 1.0f));
        }
        clinit.visitMethodInsn(183, "java/util/HashMap", "<init>", "(I)V", false);
        clinit.visitFieldInsn(179, mapping.getClassInternalName(), "PROPERTIES", "Ljava/util/Map;");
        HashMap<String, ConfigMappingInterface.Property> secrets = new HashMap<String, ConfigMappingInterface.Property>();
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : properties.entrySet()) {
            if (!ConfigMappingGenerator.isSecret(entry.getValue())) continue;
            secrets.put(entry.getKey(), entry.getValue());
        }
        if (secrets.isEmpty()) {
            clinit.visitMethodInsn(184, "java/util/Collections", "emptySet", "()Ljava/util/Set;", false);
        } else if (secrets.size() < 3) {
            clinit.visitTypeInsn(187, "java/util/HashSet");
            clinit.visitInsn(89);
            clinit.visitIntInsn(16, secrets.size() + 1);
            clinit.visitMethodInsn(183, "java/util/HashSet", "<init>", "(I)V", false);
        } else {
            clinit.visitTypeInsn(187, "java/util/HashSet");
            clinit.visitInsn(89);
            clinit.visitIntInsn(17, (int)((float)secrets.size() / 0.75f + 1.0f));
            clinit.visitMethodInsn(183, "java/util/HashSet", "<init>", "(I)V", false);
        }
        clinit.visitFieldInsn(179, mapping.getClassInternalName(), "SECRETS", "Ljava/util/Set;");
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : properties.entrySet()) {
            clinit.visitFieldInsn(178, mapping.getClassInternalName(), "PROPERTIES", "Ljava/util/Map;");
            clinit.visitLdcInsn((Object)entry.getKey());
            if (entry.getValue().hasDefaultValue()) {
                if (entry.getKey().endsWith("[*]")) {
                    clinit.visitInsn(1);
                } else {
                    clinit.visitLdcInsn((Object)entry.getValue().getDefaultValue());
                }
            } else {
                clinit.visitInsn(1);
            }
            clinit.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            clinit.visitInsn(87);
        }
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : secrets.entrySet()) {
            clinit.visitFieldInsn(178, mapping.getClassInternalName(), "SECRETS", "Ljava/util/Set;");
            clinit.visitLdcInsn((Object)entry.getKey());
            clinit.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z", true);
            clinit.visitInsn(87);
        }
        clinit.visitInsn(177);
        clinit.visitMaxs(0, 0);
        clinit.visitEnd();
        MethodVisitor mv = classVisitor.visitMethod(9, "getProperties", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", null);
        mv.visitFieldInsn(178, mapping.getClassInternalName(), "PROPERTIES", "Ljava/util/Map;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = classVisitor.visitMethod(9, "getSecrets", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/lang/String;>;", null);
        mv.visitFieldInsn(178, mapping.getClassInternalName(), "SECRETS", "Ljava/util/Set;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static boolean hasDefaultValue(Class<?> klass, Object value) {
        if (value == null) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Number && value.equals(0)) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Boolean && value.equals(Boolean.FALSE)) {
            return false;
        }
        return !klass.isPrimitive() || !(value instanceof Character) || !value.equals(0);
    }

    private static boolean isSecret(ConfigMappingInterface.Property property) {
        if (property.isLeaf()) {
            return property.isSecret();
        }
        if (property.isOptional()) {
            return ConfigMappingGenerator.isSecret(property.asOptional().getNestedProperty());
        }
        if (property.isCollection()) {
            return ConfigMappingGenerator.isSecret(property.asCollection().getElement());
        }
        if (property.isMap()) {
            return ConfigMappingGenerator.isSecret(property.asMap().getValueProperty());
        }
        return false;
    }

    static {
        ARRAY_FORMAT_REGEX = Pattern.compile("([<;])L(.*)\\[];");
        usefulDebugInfo = Boolean.parseBoolean(AccessController.doPrivileged(() -> System.getProperty("io.smallrye.config.mapper.useful-debug-info")));
        I_CLASS = Type.getInternalName(Class.class);
        I_FIELD = Type.getInternalName(Field.class);
        I_MAPPING_CONTEXT = Type.getInternalName(ConfigMappingContext.class);
        I_OBJECT_CREATOR = Type.getInternalName(ConfigMappingContext.ObjectCreator.class);
        I_NAMING_STRATEGY = Type.getInternalName(ConfigMapping.NamingStrategy.class);
        I_STRING_BUILDER = Type.getInternalName(StringBuilder.class);
        I_RUNTIME_EXCEPTION = Type.getInternalName(RuntimeException.class);
        I_OBJECT = Type.getInternalName(Object.class);
        I_STRING = Type.getInternalName(String.class);
        I_ITERABLE = Type.getInternalName(Iterable.class);
        D_MAPPING_CONTEXT = Type.getDescriptor(ConfigMappingContext.class);
        D_OBJECT_CREATOR = Type.getDescriptor(ConfigMappingContext.ObjectCreator.class);
        D_CLASS = Type.getDescriptor(Class.class);
        D_OBJECT = Type.getDescriptor(Object.class);
        D_STRING = Type.getDescriptor(String.class);
        D_INTEGER = Type.getDescriptor(Integer.class);
        D_BOOLEAN = Type.getDescriptor(Boolean.class);
        D_OPTIONAL = Type.getDescriptor(Optional.class);
        D_MAP = Type.getDescriptor(Map.class);
        D_COLLECTION = Type.getDescriptor(Collection.class);
        D_ITERABLE = Type.getDescriptor(Iterable.class);
        D_SECRET = Type.getDescriptor(Secret.class);
    }

    static final class Debugging {
        Debugging() {
        }

        static StackTraceElement getCaller() {
            return new Throwable().getStackTrace()[2];
        }

        static final class ClassVisitorImpl
        extends ClassVisitor {
            final String sourceFile = Debugging.getCaller().getFileName();

            ClassVisitorImpl(int api) {
                super(api);
            }

            ClassVisitorImpl(ClassWriter cw) {
                super(458752, (ClassVisitor)cw);
            }

            public void visitSource(String source, String debug) {
                super.visitSource(this.sourceFile, debug);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitorImpl(this.api, super.visitMethod(access, name, descriptor, signature, exceptions));
            }
        }

        static final class MethodVisitorImpl
        extends MethodVisitor {
            MethodVisitorImpl(int api) {
                super(api);
            }

            MethodVisitorImpl(int api, MethodVisitor methodVisitor) {
                super(api, methodVisitor);
            }

            public void visitInsn(int opcode) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInsn(opcode);
            }

            public void visitIntInsn(int opcode, int operand) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIntInsn(opcode, operand);
            }

            public void visitVarInsn(int opcode, int var) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitVarInsn(opcode, var);
            }

            public void visitTypeInsn(int opcode, String type) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }

            public void visitJumpInsn(int opcode, Label label) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitJumpInsn(opcode, label);
            }

            public void visitLdcInsn(Object value) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLdcInsn(value);
            }

            public void visitIincInsn(int var, int increment) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIincInsn(var, increment);
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMultiANewArrayInsn(descriptor, numDimensions);
            }
        }
    }

    private static class ObjectCreatorMethodVisitor
    extends MethodVisitor {
        protected ObjectCreatorMethodVisitor(MethodVisitor methodVisitor) {
            super(589824, methodVisitor);
        }

        void visitCast(ConfigMappingInterface.Property property, String fieldType) {
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitive = property.asPrimitive();
                if ((property.hasConvertWith() || primitive.getPrimitiveType() != Integer.TYPE) && (property.hasConvertWith() || primitive.getPrimitiveType() != Boolean.TYPE)) {
                    this.visitTypeInsn(192, Type.getInternalName(primitive.getBoxType()));
                    this.visitMethodInsn(182, Type.getInternalName(primitive.getBoxType()), primitive.getUnboxMethodName(), primitive.getUnboxMethodDescriptor(), false);
                }
            } else {
                this.visitTypeInsn(192, fieldType);
            }
        }

        void visitPropertyName(ConfigMappingInterface.Property property) {
            this.visitInsn(property.hasPropertyName() ? 3 : 4);
            this.visitLdcInsn(property.getPropertyName());
        }

        void visitConverter(ConfigMappingInterface.PrimitiveProperty property) {
            if (property.hasConvertWith()) {
                this.visitLdcInsn(Type.getType(property.getConvertWith()));
            } else {
                this.visitInsn(1);
            }
        }

        void visitConverter(ConfigMappingInterface.LeafProperty property) {
            if (property.hasConvertWith()) {
                this.visitLdcInsn(Type.getType(property.getConvertWith()));
            } else {
                this.visitInsn(1);
            }
        }

        void visitKeyConverter(ConfigMappingInterface.MapProperty property) {
            if (property.hasKeyConvertWith()) {
                this.visitLdcInsn(Type.getType(property.getKeyConvertWith()));
            } else {
                this.visitInsn(1);
            }
        }

        void visitKeyUnnamed(ConfigMappingInterface.MapProperty property) {
            if (property.hasKeyUnnamed()) {
                this.visitLdcInsn(property.getKeyUnnamed());
            } else {
                this.visitInsn(1);
            }
        }

        void visitKeyProvider(ConfigMappingInterface.MapProperty property) {
            if (property.hasKeyProvider()) {
                String provider = Type.getInternalName(property.getKeysProvider());
                this.visitTypeInsn(187, provider);
                this.visitInsn(89);
                this.visitMethodInsn(183, provider, "<init>", "()V", false);
                this.visitMethodInsn(182, provider, "get", "()L" + I_ITERABLE + ";", false);
            } else {
                this.visitInsn(1);
            }
        }

        void visitDefault(ConfigMappingInterface.MapProperty property) {
            if (property.hasDefaultValue() && property.getDefaultValue() != null) {
                this.visitLdcInsn(property.getDefaultValue());
            } else {
                this.visitInsn(1);
            }
        }

        void visitMethod(MethodInvocation methodInvocation) {
            methodInvocation.invoke(this);
        }
    }

    private static enum PrimitiveMethodInvocation implements MethodInvocation
    {
        value(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + ")" + D_OBJECT),
        intValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + ")I"),
        boolValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + ")Z");

        private final int opcode;
        private final String desc;

        private PrimitiveMethodInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static interface MethodInvocation {
        default public void invoke(MethodVisitor mv) {
            mv.visitMethodInsn(this.opcode(), I_OBJECT_CREATOR, this.name(), this.desc(), false);
        }

        public int opcode();

        public String name();

        public String desc();
    }

    private static enum ObjectMethodInvocation implements MethodInvocation
    {
        value(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + ")" + D_OBJECT),
        secretValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + ")" + D_SECRET),
        optionalValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + ")" + D_OPTIONAL),
        optionalSecretValue(184, ObjectMethodInvocation.optionalValue.desc),
        stringValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + ")" + D_STRING),
        integerValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + ")" + D_INTEGER),
        booleanValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + ")" + D_BOOLEAN),
        optionalStringValue(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + ")" + D_OPTIONAL);

        private final int opcode;
        private final String desc;

        private ObjectMethodInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static enum MapMethodInvocation implements MethodInvocation
    {
        values(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + "Z" + D_CLASS + D_CLASS + D_ITERABLE + D_STRING + ")" + D_MAP),
        secretValues(184, MapMethodInvocation.values.desc);

        private final int opcode;
        private final String desc;

        private MapMethodInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static enum MapCollectionInvocation implements MethodInvocation
    {
        values(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + D_CLASS + D_CLASS + D_CLASS + D_ITERABLE + D_STRING + ")" + D_MAP),
        secretValues(184, MapCollectionInvocation.values.desc);

        private final int opcode;
        private final String desc;

        private MapCollectionInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static enum CollectionMethodInvocation implements MethodInvocation
    {
        values(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + D_CLASS + ")" + D_COLLECTION),
        secretValues(184, CollectionMethodInvocation.values.desc),
        optionalValues(184, "(" + D_MAPPING_CONTEXT + "Z" + D_STRING + D_CLASS + D_CLASS + D_CLASS + ")" + D_OPTIONAL),
        optionalSecretValues(184, CollectionMethodInvocation.optionalValues.desc);

        private final int opcode;
        private final String desc;

        private CollectionMethodInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static enum ObjectCreatorInvocation implements MethodInvocation
    {
        get(182, "()" + D_OBJECT),
        group(182, "(" + D_CLASS + ")" + D_OBJECT_CREATOR),
        lazyGroup(182, ObjectCreatorInvocation.group.desc),
        optionalGroup(182, ObjectCreatorInvocation.group.desc),
        collection(182, "(" + D_CLASS + ")" + D_OBJECT_CREATOR),
        optionalCollection(182, ObjectCreatorInvocation.collection.desc),
        map(182, "(" + D_CLASS + D_CLASS + D_STRING + D_ITERABLE + ")" + D_OBJECT_CREATOR),
        values(182, "(" + D_CLASS + D_CLASS + D_CLASS + D_CLASS + D_CLASS + D_ITERABLE + D_STRING + ")" + D_OBJECT_CREATOR),
        optionalValues(182, "(" + D_CLASS + D_CLASS + D_CLASS + ")" + D_OBJECT_CREATOR);

        private final int opcode;
        private final String desc;

        private ObjectCreatorInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static enum ObjectCreatorMapInvocation implements MethodInvocation
    {
        values(182, "(" + D_CLASS + D_CLASS + D_CLASS + D_CLASS + D_ITERABLE + D_STRING + ")" + D_OBJECT_CREATOR);

        private final int opcode;
        private final String desc;

        private ObjectCreatorMapInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }

    private static enum ObjectCreatorMapGroupInvocation implements MethodInvocation
    {
        map(182, "(" + D_CLASS + D_CLASS + D_STRING + D_ITERABLE + D_CLASS + ")" + D_OBJECT_CREATOR);

        private final int opcode;
        private final String desc;

        private ObjectCreatorMapGroupInvocation(int opcode, String desc) {
            this.opcode = opcode;
            this.desc = desc;
        }

        @Override
        public int opcode() {
            return this.opcode;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }
}

