/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class _ArrayMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    private Object[] _array;
    private int _size;
    private int _increment;
    private Set<Map.Entry<K, V>> _entrySet;

    public _ArrayMap() {
        this(0, 1);
    }

    public _ArrayMap(int size) {
        this(size, 1);
    }

    public _ArrayMap(int size, int increment) {
        if (increment < 1 || size < 0) {
            throw new IllegalArgumentException();
        }
        if (size > 0) {
            this._array = new Object[2 * size];
        }
        this._increment = increment;
    }

    public K getKey(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (K)this._array[index * 2];
    }

    public V getValue(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (V)this._array[index * 2 + 1];
    }

    public static Object get(Object[] array, Object key) {
        Object o = _ArrayMap.getByIdentity(array, key);
        if (o != null) {
            return o;
        }
        return _ArrayMap.getByEquality(array, key);
    }

    public static Object getByIdentity(Object[] array, Object key) {
        if (array != null) {
            int length = array.length;
            for (int i = 0; i < length; i += 2) {
                if (array[i] != key) continue;
                return array[i + 1];
            }
        }
        return null;
    }

    public static Object getByEquality(Object[] array, Object key) {
        if (array != null) {
            int length = array.length;
            for (int i = 0; i < length; i += 2) {
                Object targetKey = array[i];
                if (targetKey == null) {
                    return null;
                }
                if (!targetKey.equals(key)) continue;
                return array[i + 1];
            }
        }
        return null;
    }

    public static Object[] put(Object[] array, Object key, Object value) {
        if (array != null) {
            int length = array.length;
            for (int i = 0; i < length; i += 2) {
                Object curKey = array[i];
                if ((curKey == null || !curKey.equals(key)) && curKey != key) continue;
                array[i + 1] = value;
                return array;
            }
        }
        return _ArrayMap._addToArray(array, key, value, 1);
    }

    public static Object[] remove(Object[] array, Object key) {
        return _ArrayMap.remove(array, key, true);
    }

    public static Object[] remove(Object[] array, Object key, boolean reallocate) {
        if (array != null) {
            int length = array.length;
            for (int i = 0; i < length; i += 2) {
                Object curKey = array[i];
                if ((curKey == null || !curKey.equals(key)) && curKey != key) continue;
                Object[] newArray = array;
                if (reallocate) {
                    newArray = new Object[length - 2];
                    System.arraycopy(array, 0, newArray, 0, i);
                }
                System.arraycopy(array, i + 2, newArray, i, length - i - 2);
                if (!reallocate) {
                    array[length - 1] = null;
                    array[length - 2] = null;
                }
                return newArray;
            }
        }
        return array;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean containsValue(Object value) {
        int entryCount = this.size() * 2;
        for (int i = 0; i < entryCount; i += 2) {
            if (!_ArrayMap._equals(value, this._array[i + 1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        int entryCount = this.size() * 2;
        for (int i = 0; i < entryCount; i += 2) {
            if (!_ArrayMap._equals(key, this._array[i])) continue;
            return true;
        }
        return false;
    }

    public Iterator<K> keys() {
        int size = this._size;
        if (size == 0) {
            return null;
        }
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int i = (size - 1) * 2; i >= 0; i -= 2) {
            keyList.add(this._array[i]);
        }
        return keyList.iterator();
    }

    public static Iterator<Object> getKeys(Object[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int i = array.length - 2; i >= 0; i -= 2) {
            keyList.add(array[i]);
        }
        return keyList.iterator();
    }

    public static Iterator<Object> getValues(Object[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int i = array.length - 1; i >= 0; i -= 2) {
            valueList.add(array[i]);
        }
        return valueList.iterator();
    }

    @Override
    public Object clone() {
        try {
            _ArrayMap am = (_ArrayMap)super.clone();
            am._array = (Object[])this._array.clone();
            am._size = this._size;
            am._increment = this._increment;
            return am;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return _ArrayMap.this.size();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int _index;
                        private boolean _removed;

                        @Override
                        public boolean hasNext() {
                            return this._index < _ArrayMap.this.size();
                        }

                        @Override
                        public void remove() {
                            if (this._index == 0 || this._removed) {
                                throw new IllegalStateException();
                            }
                            this._removed = true;
                            int size = _ArrayMap.this.size();
                            Object[] array = _ArrayMap.this._array;
                            if (size > this._index) {
                                System.arraycopy(array, this._index * 2, array, (this._index - 1) * 2, (size - this._index) * 2);
                            }
                            array[size * 2 - 2] = null;
                            array[size * 2 - 1] = null;
                            _ArrayMap.this._size = size - 1;
                            --this._index;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            final int index = this._index;
                            this._removed = false;
                            this._index = index + 1;
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return _ArrayMap.this.getKey(index);
                                }

                                @Override
                                public V getValue() {
                                    return _ArrayMap.this.getValue(index);
                                }

                                @Override
                                public V setValue(V value) {
                                    Object oldValue = this.getValue();
                                    _ArrayMap.this._array[index * 2 + 1] = value;
                                    return oldValue;
                                }

                                @Override
                                public boolean equals(Object o) {
                                    if (!(o instanceof Map.Entry)) {
                                        return false;
                                    }
                                    Map.Entry e = (Map.Entry)o;
                                    return _ArrayMap._equals(this.getKey(), e.getKey()) && _ArrayMap._equals(this.getValue(), e.getValue());
                                }

                                @Override
                                public int hashCode() {
                                    Object key = this.getKey();
                                    Object value = this.getValue();
                                    return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                                }
                            };
                        }
                    };
                }
            };
        }
        return this._entrySet;
    }

    @Override
    public V get(Object key) {
        return (V)_ArrayMap.getByEquality(this._array, key);
    }

    public V getByIdentity(Object key) {
        return (V)_ArrayMap.getByIdentity(this._array, key);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return this.remove(key);
        }
        Object[] array = this._array;
        Object o = _ArrayMap.getByEquality(array, key);
        if (o == null) {
            int size = this._size * 2;
            if (array != null && size < array.length) {
                array[size] = key;
                array[size + 1] = value;
            } else {
                this._array = _ArrayMap._addToArray(array, key, value, this._increment);
            }
            ++this._size;
        } else {
            this._array = _ArrayMap.put(array, key, value);
        }
        return (V)o;
    }

    @Override
    public V remove(Object key) {
        Object[] array = this._array;
        Object o = _ArrayMap.get(array, key);
        if (o != null) {
            _ArrayMap.remove(array, key, false);
            --this._size;
        }
        return (V)o;
    }

    @Override
    public void clear() {
        int size = this._size;
        if (size > 0) {
            size *= 2;
            for (int i = 0; i < size; ++i) {
                this._array[i] = null;
            }
            this._size = 0;
        }
    }

    private static Object[] _addToArray(Object[] array, Object key, Object value, int increment) {
        Object[] newArray = null;
        if (array != null) {
            int length = array.length;
            newArray = new Object[length + 2 * increment];
            System.arraycopy(array, 0, newArray, 2, length);
        } else {
            newArray = new Object[2 * increment];
        }
        newArray[0] = key;
        newArray[1] = value;
        return newArray;
    }

    private static boolean _equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

