/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;

public final class EJBWebBeansConfigurator {
    private EJBWebBeansConfigurator() {
    }

    public static boolean isSessionBean(Class<?> clazz, WebBeansContext webBeansContext) throws WebBeansConfigurationException {
        PluginLoader loader = webBeansContext.getPluginLoader();
        OpenWebBeansEjbPlugin ejbPlugin = loader.getEjbPlugin();
        if (ejbPlugin == null) {
            return false;
        }
        return ejbPlugin.isSessionBean(clazz);
    }

    public static <T> Bean<T> defineEjbBean(Class<T> clazz, AnnotatedType<T> annotatedType, BeanAttributes<T> attributes, WebBeansContext webBeansContext) {
        PluginLoader loader = webBeansContext.getPluginLoader();
        OpenWebBeansEjbPlugin ejbPlugin = loader.getEjbPlugin();
        if (ejbPlugin == null) {
            throw new IllegalStateException("There is no provided EJB plugin. Unable to define session bean for class : " + clazz.getName());
        }
        return ejbPlugin.defineSessionBean(clazz, attributes, annotatedType);
    }
}

