/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http.openid.model;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.security.enterprise.identitystore.openid.Claims;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class TomEEJsonClaims
implements Claims {
    private final JsonObject claims;

    public TomEEJsonClaims(JsonObject claims) {
        this.claims = claims;
    }

    public Optional<String> getStringClaim(String name) {
        if (this.claims == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.claims.getString(name, null));
    }

    public Optional<Instant> getNumericDateClaim(String name) {
        OptionalLong rawValue = this.getLongClaim(name);
        if (rawValue.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochSecond(rawValue.getAsLong()));
    }

    public List<String> getArrayStringClaim(String name) {
        if (this.claims == null || !this.claims.containsKey((Object)name)) {
            return Collections.emptyList();
        }
        JsonValue claimValue = (JsonValue)this.claims.get((Object)name);
        if (claimValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)claimValue;
            return jsonArray.stream().map(JsonString.class::cast).map(JsonString::getString).toList();
        }
        if (claimValue instanceof JsonString) {
            JsonString jsonString = (JsonString)claimValue;
            return List.of(jsonString.getString());
        }
        throw new IllegalArgumentException("Claim " + name + " is of type " + String.valueOf(claimValue.getValueType()) + ", expected either " + String.valueOf(JsonValue.ValueType.STRING) + " or " + String.valueOf(JsonValue.ValueType.ARRAY));
    }

    public OptionalInt getIntClaim(String name) {
        if (this.claims == null || !this.claims.containsKey((Object)name)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.claims.getInt(name));
    }

    public OptionalLong getLongClaim(String name) {
        if (this.claims == null || !this.claims.containsKey((Object)name)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.claims.getJsonNumber(name).longValue());
    }

    public OptionalDouble getDoubleClaim(String name) {
        if (this.claims == null || !this.claims.containsKey((Object)name)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.claims.getJsonNumber(name).doubleValue());
    }

    public Optional<Claims> getNested(String name) {
        if (this.claims == null || !this.claims.containsKey((Object)name)) {
            return Optional.empty();
        }
        return Optional.of(new TomEEJsonClaims(this.claims.getJsonObject(name)));
    }
}

