/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class DOMMetadataResolver
extends AbstractBatchMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DOMMetadataResolver.class);
    @Nonnull
    private Element metadataElement;

    public DOMMetadataResolver(@Nonnull Element mdElement) {
        this.metadataElement = (Element)Constraint.isNotNull((Object)mdElement, (String)"DOM Element cannot be null");
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        try {
            Unmarshaller unmarshaller = this.getUnmarshallerFactory().ensureUnmarshaller(this.metadataElement);
            XMLObject metadataTemp = unmarshaller.unmarshall(this.metadataElement);
            AbstractBatchMetadataResolver.BatchEntityBackingStore newBackingStore = this.preProcessNewMetadata(metadataTemp);
            this.releaseMetadataDOM(metadataTemp);
            this.setBackingStore(newBackingStore);
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata element";
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), "Unable to unmarshall metadata element", e.getMessage()});
            throw new ComponentInitializationException("Unable to unmarshall metadata element", (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), "Unable to filter metadata", e.getMessage()});
            throw new ComponentInitializationException("Unable to filter metadata", (Exception)((Object)e));
        }
    }
}

