/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.ActiveMQContext;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQMessageProducerSupport;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.TypeConversionSupport;

public class ActiveMQProducer
implements JMSProducer {
    private final ActiveMQContext activemqContext;
    private final ActiveMQMessageProducer activemqMessageProducer;
    private String correlationId = null;
    private byte[] correlationIdBytes = null;
    private Integer deliveryMode = null;
    private Boolean disableMessageID = false;
    private Boolean disableMessageTimestamp = false;
    private Integer priority = null;
    private Destination replyTo = null;
    private Long timeToLive = null;
    private String type = null;
    private Map<String, Object> messageProperties = null;

    ActiveMQProducer(ActiveMQContext activemqContext, ActiveMQMessageProducer activemqMessageProducer) {
        this.activemqContext = activemqContext;
        this.activemqMessageProducer = activemqMessageProducer;
    }

    public JMSProducer send(Destination destination, Message message) {
        try {
            if (this.correlationId != null) {
                message.setJMSCorrelationID(this.correlationId);
            }
            if (this.correlationIdBytes != null) {
                message.setJMSCorrelationIDAsBytes(this.correlationIdBytes);
            }
            if (this.replyTo != null) {
                message.setJMSReplyTo(this.replyTo);
            }
            if (this.type != null) {
                message.setJMSType(this.type);
            }
            if (this.messageProperties != null && !this.messageProperties.isEmpty()) {
                for (Map.Entry<String, Object> propertyEntry : this.messageProperties.entrySet()) {
                    message.setObjectProperty(propertyEntry.getKey(), propertyEntry.getValue());
                }
            }
            this.activemqMessageProducer.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive(), this.getDisableMessageID(), this.getDisableMessageTimestamp(), null);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        TextMessage textMessage = this.activemqContext.createTextMessage(body);
        this.send(destination, (Message)textMessage);
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        MapMessage mapMessage = this.activemqContext.createMapMessage();
        if (body != null) {
            try {
                for (Map.Entry<String, Object> mapEntry : body.entrySet()) {
                    mapMessage.setObject(mapEntry.getKey(), mapEntry.getValue());
                }
            }
            catch (JMSException e) {
                throw new MessageFormatRuntimeException(e.getMessage());
            }
        }
        this.send(destination, (Message)mapMessage);
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        BytesMessage bytesMessage = this.activemqContext.createBytesMessage();
        try {
            if (body != null) {
                bytesMessage.writeBytes(body);
            }
            this.send(destination, (Message)bytesMessage);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        ObjectMessage objectMessage = this.activemqContext.createObjectMessage(body);
        this.send(destination, (Message)objectMessage);
        return this;
    }

    public JMSProducer setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
        return this;
    }

    public boolean getDisableMessageID() {
        if (this.disableMessageID != null) {
            return this.disableMessageID;
        }
        try {
            return this.activemqMessageProducer.getDisableMessageID();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        if (this.disableMessageTimestamp != null) {
            return this.disableMessageTimestamp;
        }
        try {
            return this.activemqMessageProducer.getDisableMessageTimestamp();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new IllegalStateRuntimeException("unknown delivery mode: " + deliveryMode);
        }
        this.deliveryMode = deliveryMode;
        return this;
    }

    public int getDeliveryMode() {
        if (this.deliveryMode != null) {
            return this.deliveryMode;
        }
        try {
            return this.activemqMessageProducer.getDeliveryMode();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public JMSProducer setPriority(int priority) {
        if (priority < 0 || priority > 9) {
            throw new IllegalStateRuntimeException("default priority must be a value between 0 and 9");
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        if (this.priority != null) {
            return this.priority;
        }
        try {
            return this.activemqMessageProducer.getPriority();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public long getTimeToLive() {
        if (this.timeToLive != null) {
            return this.timeToLive;
        }
        try {
            return this.activemqMessageProducer.getTimeToLive();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        throw new UnsupportedOperationException("setDeliveryDelay(long) is not supported");
    }

    public long getDeliveryDelay() {
        throw new UnsupportedOperationException("getDeliveryDelay() is not supported");
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        throw new UnsupportedOperationException("setAsync(CompletionListener) is not supported");
    }

    public CompletionListener getAsync() {
        throw new UnsupportedOperationException("getAsync() is not supported");
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.checkProperty(name, Float.valueOf(value));
        this.getCreatedMessageProperties().put(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.checkProperty(name, value);
        this.getCreatedMessageProperties().put(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        this.getCreatedMessageProperties().clear();
        return this;
    }

    public boolean propertyExists(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return this.getCreatedMessageProperties().containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a boolean");
        }
        return rc;
    }

    public byte getByteProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Byte rc = (Byte)TypeConversionSupport.convert(value, Byte.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a byte");
        }
        return rc;
    }

    public short getShortProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Short rc = (Short)TypeConversionSupport.convert(value, Short.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a short");
        }
        return rc;
    }

    public int getIntProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as an integer");
        }
        return rc;
    }

    public long getLongProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a long");
        }
        return rc;
    }

    public float getFloatProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Float rc = (Float)TypeConversionSupport.convert(value, Float.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a float");
        }
        return rc.floatValue();
    }

    public double getDoubleProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        Double rc = (Double)TypeConversionSupport.convert(value, Double.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a double");
        }
        return rc;
    }

    public String getStringProperty(String name) {
        Object value = this.getCreatedMessageProperties().get(name);
        if (value == null) {
            throw new NullPointerException("property " + name + " was null");
        }
        String rc = (String)TypeConversionSupport.convert(value, String.class);
        if (rc == null) {
            throw new MessageFormatRuntimeException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a string");
        }
        return rc;
    }

    public Object getObjectProperty(String name) {
        if (name == null) {
            throw new NullPointerException("Property name cannot be null");
        }
        return this.getCreatedMessageProperties().get(name);
    }

    public Set<String> getPropertyNames() {
        return this.getCreatedMessageProperties().keySet();
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        if (correlationID != null) {
            this.correlationIdBytes = Arrays.copyOf(correlationID, correlationID.length);
        }
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationIdBytes;
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.correlationId = correlationID;
        return this;
    }

    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    public JMSProducer setJMSType(String type) {
        this.type = type;
        return this;
    }

    public String getJMSType() {
        return this.type;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    private void checkProperty(String name, Object value) {
        ActiveMQMessageProducerSupport.validateValidPropertyName(name);
        ActiveMQMessageProducerSupport.validateValidPropertyValue(name, value);
    }

    private Map<String, Object> getCreatedMessageProperties() {
        if (this.messageProperties == null) {
            this.messageProperties = new HashMap<String, Object>();
        }
        return this.messageProperties;
    }
}

