/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.EmptyAnnotationLiteral;

public class BValAnnotatedType<A>
implements AnnotatedType<A> {
    private final AnnotatedType<A> delegate;
    private final Set<Annotation> annotations;

    public BValAnnotatedType(AnnotatedType<A> annotatedType) {
        this.delegate = annotatedType;
        this.annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
        this.annotations.add(BValBindingLiteral.INSTANCE);
    }

    public Class<A> getJavaClass() {
        return this.delegate.getJavaClass();
    }

    public Set<AnnotatedConstructor<A>> getConstructors() {
        return this.delegate.getConstructors();
    }

    public Set<AnnotatedMethod<? super A>> getMethods() {
        return this.delegate.getMethods();
    }

    public Set<AnnotatedField<? super A>> getFields() {
        return this.delegate.getFields();
    }

    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)((Annotation)this.annotations.stream().filter(ann -> ann.annotationType().equals(annotationType)).map(annotationType::cast).findFirst().orElse(null));
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.stream().anyMatch(ann -> ann.annotationType().equals(annotationType));
    }

    public static class BValBindingLiteral
    extends EmptyAnnotationLiteral<BValBinding>
    implements BValBinding {
        private static final long serialVersionUID = 1L;
        public static final Annotation INSTANCE = new BValBindingLiteral();

        @Override
        public String toString() {
            return String.format("@%s()", BValBinding.class.getName());
        }
    }
}

