/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.util.Comparators;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.LazyInt;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.Validate;

public final class Signature
implements Comparable<Signature> {
    private static final Comparator<Signature> COMPARATOR = Comparator.nullsFirst(Comparator.comparing(Signature::getName).thenComparing(Comparator.comparing(s -> Arrays.asList(s.getParameterTypes()), Comparators.comparingIterables(Comparator.comparing(Class::getName)))));
    private final String name;
    private final Class<?>[] parameterTypes;
    private final LazyInt hashCode;
    private final Lazy<String> toString;

    public static Signature of(Executable x) {
        return new Signature(x.getName(), x.getParameterTypes());
    }

    public Signature(String name, Class<?> ... parameterTypes) {
        this.name = Validate.notNull(name, "name", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(name), "name is blank", new Object[0]);
        this.parameterTypes = (Class[])Validate.notNull(parameterTypes, "parameterTypes", new Object[0]).clone();
        this.hashCode = new LazyInt(() -> Arrays.deepHashCode(new Object[]{this.name, this.parameterTypes}));
        this.toString = new Lazy<String>(() -> String.format("%s: %s(%s)", this.getClass().getSimpleName(), this.name, Stream.of(this.parameterTypes).map(Class::getName).collect(Collectors.joining(", "))));
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!Optional.ofNullable(obj).filter(Signature.class::isInstance).map(Signature.class::cast).filter(sig -> Objects.equals(this.name, sig.name) && Objects.deepEquals(this.parameterTypes, sig.parameterTypes)).isPresent()) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode.getAsInt();
    }

    public String toString() {
        return this.toString.get();
    }

    @Override
    public int compareTo(Signature sig) {
        return COMPARATOR.compare(this, sig);
    }

    public boolean isGetter() {
        return this.parameterTypes.length == 0 && Methods.isGetter(this.name);
    }
}

