/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.proxy;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.IntFunction;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.DelayedCollectionChangeTrackerImpl;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.proxy.DelayedProxy;
import org.apache.openjpa.util.proxy.ProxyCollection;
import org.apache.openjpa.util.proxy.ProxyCollections;

public class DelayedLinkedHashSetProxy
extends LinkedHashSet
implements DelayedProxy,
ProxyCollection {
    private transient OpenJPAStateManager sm;
    private transient int field;
    private transient CollectionChangeTracker changeTracker;
    private transient Class<?> elementType;
    private transient OpenJPAStateManager _ownerSm;
    private transient boolean _directAccess = false;
    private transient BrokerFactory _brokerFactory = null;
    private transient Broker _broker = null;
    private transient OpenJPAStateManager _delayedSm;
    private transient int _delayedField;
    private transient boolean _detached = false;

    public DelayedLinkedHashSetProxy(Collection<?> paramCollection) {
        super(paramCollection);
    }

    public DelayedLinkedHashSetProxy(int paramInt, float paramFloat) {
        super(paramInt, paramFloat);
    }

    public DelayedLinkedHashSetProxy(int paramInt) {
        super(paramInt);
    }

    public DelayedLinkedHashSetProxy() {
    }

    @Override
    public void setOwner(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        if (this.sm != null && this.detaching(paramOpenJPAStateManager, paramInt)) {
            this._detached = true;
            this._delayedSm = this.sm;
            this._delayedField = this.field;
        } else {
            this._detached = false;
        }
        this.sm = paramOpenJPAStateManager;
        if (this.sm != null && this.sm.getPersistenceCapable() != null) {
            this._ownerSm = (OpenJPAStateManager)this.sm.getPersistenceCapable().pcGetStateManager();
        }
        this.field = paramInt;
        if (this.sm != null && this.sm.getContext() != null) {
            this._brokerFactory = this.sm.getContext().getBroker().getBrokerFactory();
        }
    }

    private boolean detaching(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        return paramOpenJPAStateManager == null && paramInt == -1 || paramOpenJPAStateManager != null && paramOpenJPAStateManager instanceof DetachedStateManager;
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this.sm;
    }

    @Override
    public int getOwnerField() {
        return this.field;
    }

    @Override
    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    protected void setChangeTracker(CollectionChangeTracker ct) {
        this.changeTracker = ct;
    }

    @Override
    public Object copy(Object paramObject) {
        return new LinkedHashSet((Collection)paramObject);
    }

    @Override
    public Class getElementType() {
        return this.elementType;
    }

    protected void setElementType(Class<?> elemType) {
        this.elementType = elemType;
    }

    @Override
    public ProxyCollection newInstance(Class paramClass, Comparator paramComparator, boolean paramBoolean1, boolean paramBoolean2) {
        DelayedLinkedHashSetProxy localproxy = new DelayedLinkedHashSetProxy();
        localproxy.elementType = paramClass;
        if (paramBoolean1) {
            localproxy.changeTracker = new DelayedCollectionChangeTrackerImpl(localproxy, false, false, paramBoolean2);
        }
        return localproxy;
    }

    @Override
    public Object clone() {
        if (this.isDirectAccess()) {
            return super.clone();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxy localProxy = (Proxy)super.clone();
        localProxy.setOwner(null, 0);
        return localProxy;
    }

    @Override
    public boolean add(Object paramObject) {
        if (this._directAccess) {
            return super.add(paramObject);
        }
        ProxyCollections.beforeAdd(this, paramObject);
        boolean bool = super.add(paramObject);
        return ProxyCollections.afterAdd(this, paramObject, bool);
    }

    @Override
    public void clear() {
        if (!this._directAccess) {
            if (this.isDelayLoad()) {
                this.load();
            }
            ProxyCollections.beforeClear(this);
        }
        super.clear();
    }

    @Override
    public Iterator iterator() {
        if (this._directAccess) {
            return super.iterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Iterator localIterator = super.iterator();
        return ProxyCollections.afterIterator(this, localIterator);
    }

    @Override
    public boolean remove(Object paramObject) {
        if (this._directAccess) {
            return super.remove(paramObject);
        }
        ProxyCollections.beforeRemove((ProxyCollection)this, paramObject);
        this.setDirectAccess(true);
        boolean bool = super.remove(paramObject);
        this.setDirectAccess(false);
        return ProxyCollections.afterRemove((ProxyCollection)this, paramObject, bool);
    }

    @Override
    public boolean removeAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.removeAll(paramCollection);
        }
        return ProxyCollections.removeAll(this, paramCollection);
    }

    @Override
    public boolean addAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.addAll(paramCollection);
        }
        return ProxyCollections.addAll(this, paramCollection);
    }

    @Override
    public boolean retainAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.retainAll(paramCollection);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return ProxyCollections.retainAll(this, paramCollection);
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.isDelayLoad()) {
            this.load();
        }
        return Proxies.writeReplace(this, true);
    }

    @Override
    public int size() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.contains(o);
    }

    @Override
    public Object[] toArray() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(a);
    }

    public Object[] toArray(IntFunction generator) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(generator);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.containsAll(c);
    }

    @Override
    public String toString() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toString();
    }

    @Override
    public boolean equals(Object paramObject) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.equals(paramObject);
    }

    @Override
    public int hashCode() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.hashCode();
    }

    @Override
    public int getDelayedField() {
        if (this.field == -1 || this._detached) {
            return this._delayedField;
        }
        return this.field;
    }

    @Override
    public OpenJPAStateManager getDelayedOwner() {
        if (this.sm == null || this._detached) {
            return this._delayedSm;
        }
        return this.sm;
    }

    @Override
    public boolean isDirectAccess() {
        return this._directAccess;
    }

    @Override
    public void setDirectAccess(boolean direct) {
        this._directAccess = direct;
    }

    public BrokerFactory getBrokerFactory() {
        return this._brokerFactory;
    }

    @Override
    public void load() {
        ProxyCollections.loadCollection(this);
    }

    @Override
    public Broker getBroker() {
        if ((this._broker == null || this._broker.isClosed()) && this._brokerFactory != null) {
            this._broker = this._brokerFactory.newBroker();
        }
        return this._broker;
    }

    @Override
    public void closeBroker() {
        if (this._broker != null && !this._broker.isClosed()) {
            this._broker.setAutoDetach(2);
            this._broker.close();
            this._broker = null;
        }
    }

    @Override
    public OpenJPAStateManager getOwnerStateManager() {
        return this._ownerSm;
    }

    @Override
    public boolean isDetached() {
        return this._detached;
    }

    protected boolean isDelayLoad() {
        return ProxyCollections.isDelayed(this);
    }
}

