/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spi;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.PackageUtils;

public interface WrapperClassNamingConvention {
    public String getWrapperClassPackageName(Class<?> var1, boolean var2);

    public static class LegacyWrapperClassNamingConvention
    implements WrapperClassNamingConvention {
        @Override
        public String getWrapperClassPackageName(Class<?> sei, boolean anonymous) {
            return this.getPackageName(sei) + ".jaxws_asm" + (anonymous ? "_an" : "");
        }

        private String getPackageName(Class<?> sei) {
            String pkg = PackageUtils.getPackageName(sei);
            return pkg.length() == 0 ? "defaultnamespace" : pkg;
        }
    }

    public static class DefaultWrapperClassNamingConvention
    implements WrapperClassNamingConvention {
        public static final String DEFAULT_PACKAGE_NAME = "defaultnamespace";
        private static final Pattern JAVA_PACKAGE_NAME_SANITIZER_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

        @Override
        public String getWrapperClassPackageName(Class<?> sei, boolean anonymous) {
            String cl;
            String pkg;
            String className = sei.getName();
            int start = className.startsWith("[L") ? 2 : 0;
            int end = className.lastIndexOf(46);
            if (end >= 0) {
                pkg = className.substring(start, end);
                cl = className.substring(end + 1);
            } else {
                pkg = DEFAULT_PACKAGE_NAME;
                cl = className;
            }
            return pkg + (anonymous ? ".jaxws_asm_an." : ".jaxws_asm.") + JAVA_PACKAGE_NAME_SANITIZER_PATTERN.matcher(cl).replaceAll("_").toLowerCase(Locale.ROOT);
        }
    }
}

