/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.faces.component.UIComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.myfaces.core.api.shared.lang.Assert;

class _ComponentChildrenList
extends ArrayList<UIComponent>
implements Serializable {
    private static final long serialVersionUID = -6775078929331154224L;
    private UIComponent _component;

    _ComponentChildrenList(UIComponent component) {
        super(4);
        this._component = component;
    }

    @Override
    public UIComponent get(int index) {
        return (UIComponent)super.get(index);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public UIComponent set(int index, UIComponent value) {
        Assert.notNull(value, "value");
        this.removeChildrenFromParent(value);
        UIComponent child = super.set(index, value);
        if (child != value) {
            this.updateParent(value);
            if (child != null) {
                this.childRemoved(child);
            }
        }
        return child;
    }

    @Override
    public boolean add(UIComponent value) {
        Assert.notNull(value, "value");
        this.removeChildrenFromParent(value);
        boolean res = super.add(value);
        this.updateParent(value);
        return res;
    }

    @Override
    public void add(int index, UIComponent value) {
        Assert.notNull(value, "value");
        this.removeChildrenFromParent(value);
        super.add(index, value);
        this.updateParent(value);
    }

    @Override
    public UIComponent remove(int index) {
        UIComponent child = (UIComponent)super.remove(index);
        if (child != null) {
            this.childRemoved(child);
        }
        return child;
    }

    private void childRemoved(UIComponent child) {
        child.setParent(null);
    }

    private void updateParent(UIComponent child) {
        child.setParent(this._component);
    }

    private void removeChildrenFromParent(UIComponent child) {
        UIComponent oldParent = child.getParent();
        if (oldParent != null && !oldParent.getChildren().remove(child) && oldParent.getFacetCount() > 0) {
            Iterator<Map.Entry<String, UIComponent>> it = oldParent.getFacets().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, UIComponent> entry = it.next();
                if (!entry.getValue().equals(child)) continue;
                it.remove();
                break;
            }
        }
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof UIComponent)) {
            throw new ClassCastException("value is not a UIComponent");
        }
        Assert.notNull(value, "value");
        if (super.remove(value)) {
            this.childRemoved((UIComponent)value);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean addAll(Collection<? extends UIComponent> collection) {
        boolean result = false;
        Iterator<? extends UIComponent> it = collection.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean addAll(int location, Collection<? extends UIComponent> collection) {
        Iterator<? extends UIComponent> it = collection.iterator();
        while (it.hasNext()) {
            this.add(location++, it.next());
        }
        return !collection.isEmpty();
    }

    @Override
    protected void removeRange(int start, int end) {
        ListIterator it = this.listIterator(start);
        for (int i = start; i < end; ++i) {
            it.next();
            it.remove();
        }
    }
}

