/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansConfigurationHttpSessionListener
implements HttpSessionListener {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansConfigurationHttpSessionListener.class);
    protected ContainerLifecycle lifeCycle = (ContainerLifecycle)WebBeansContext.getInstance().getService(ContainerLifecycle.class);

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a session with session id : [{0}]", event.getSession().getId());
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0020", (Object[])new Object[]{event.getSession()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a session with session id : [{0}]", event.getSession().getId());
        }
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        this.lifeCycle.getContextService().endContext(ConversationScoped.class, (Object)event.getSession());
    }
}

