/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.event.Observes;

public class Observers {
    private static final Logger logger = Logger.getLogger("OpenEJB.client");
    private final List<Observer> observers = new ArrayList<Observer>();

    public boolean addObserver(Object observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        return this.observers.add(new Observer(observer));
    }

    public boolean removeObserver(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        return this.observers.remove(new Observer(listener));
    }

    public void fireEvent(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        for (Observer observer : this.observers) {
            try {
                observer.invoke(event);
            }
            catch (InvocationTargetException e) {
                Throwable t;
                Throwable throwable = t = e.getTargetException() == null ? e : e.getTargetException();
                if (e.getTargetException() == null) continue;
                logger.log(Level.WARNING, "Observer method invocation failed", t);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Observer {
        private final Map<Class, Method> methods = new HashMap<Class, Method>();
        private final Object observer;
        private final Method defaultMethod;

        public Observer(Object observer) {
            if (observer == null) {
                throw new IllegalArgumentException("observer cannot be null");
            }
            this.observer = observer;
            for (Method method : observer.getClass().getMethods()) {
                if (!this.isObserver(method)) continue;
                if (method.getParameterTypes().length > 1) {
                    throw new IllegalArgumentException("@Observes method must have only 1 parameter: " + method.toString());
                }
                if (Modifier.isAbstract(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must not be abstract: " + method.toString());
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method must be public: " + method.toString());
                }
                Class<?> type = method.getParameterTypes()[0];
                if (type.isAnnotation()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an annotation): " + method.toString());
                }
                if (Modifier.isAbstract(type.getModifiers())) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an abstract class): " + method.toString());
                }
                if (type.isInterface()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an interface): " + method.toString());
                }
                if (type.isArray()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not an array): " + method.toString());
                }
                if (type.isPrimitive()) {
                    throw new IllegalArgumentException("@Observes method parameter must be a concrete class (not a primitive): " + method.toString());
                }
                this.methods.put(type, method);
            }
            this.defaultMethod = this.methods.get(Object.class);
            if (this.methods.size() == 0) {
                throw new IllegalArgumentException("Object has no @Observes methods. For example: public void observe(@Observes RetryConditionAdded event){...}");
            }
        }

        public void invoke(Object event) throws InvocationTargetException, IllegalAccessException {
            if (event == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            for (Class<?> eventType = event.getClass(); eventType != Object.class; eventType = eventType.getSuperclass()) {
                Method method = this.methods.get(eventType);
                if (method == null) continue;
                method.invoke(this.observer, event);
                return;
            }
            if (this.defaultMethod != null) {
                this.defaultMethod.invoke(this.observer, event);
            }
        }

        private boolean isObserver(Method method) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!annotation.annotationType().equals(Observes.class)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Observer observer1 = (Observer)o;
            return this.observer.equals(observer1.observer);
        }

        public int hashCode() {
            return this.observer.hashCode();
        }
    }
}

