/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.ServerMetaData;

public class FailoverConnectionFactory
implements ConnectionFactory {
    @Override
    public Connection getConnection(URI failoverUri) throws IOException {
        String remainder = failoverUri.getRawSchemeSpecificPart();
        URI uri = URI.create(remainder);
        String strategy = uri.getScheme();
        String servers = uri.getRawSchemeSpecificPart();
        if (servers.startsWith("//")) {
            strategy = "default";
            servers = remainder;
        }
        ArrayList<URI> list = new ArrayList<URI>();
        for (String server : servers.split(",")) {
            list.add(URI.create(server));
        }
        URI[] uris = list.toArray(new URI[list.size()]);
        ClusterMetaData data = new ClusterMetaData(0L, uris);
        data.setConnectionStrategy(strategy);
        return ConnectionManager.getConnection(data, new ServerMetaData(), null);
    }

    public static void main(String[] args) throws IOException {
        FailoverConnectionFactory factory = new FailoverConnectionFactory();
        URI uri = URI.create("failover:ejbd://foo:4201,ejbd://bar:4202");
        Connection connection = factory.getConnection(uri);
    }
}

