/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.saml.saml2.core.NameID;

public final class SAML2ObjectSupport {
    private SAML2ObjectSupport() {
    }

    public static boolean areNameIDFormatsEquivalent(@Nullable String format1, @Nullable String format2) {
        return Objects.equals(format1 != null ? format1 : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", format2 != null ? format2 : "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    public static boolean areNameIDsEquivalent(@Nonnull NameID name1, @Nonnull NameID name2) {
        return SAML2ObjectSupport.areNameIDFormatsEquivalent(name1.getFormat(), name2.getFormat()) && Objects.equals(name1.getValue(), name2.getValue()) && Objects.equals(name1.getNameQualifier(), name2.getNameQualifier()) && Objects.equals(name1.getSPNameQualifier(), name2.getSPNameQualifier());
    }

    public static boolean areNameIDsEquivalent(@Nonnull NameID name1, @Nonnull NameID name2, @Nullable String assertingParty, @Nullable String relyingParty) {
        if (!SAML2ObjectSupport.areNameIDFormatsEquivalent(name1.getFormat(), name2.getFormat()) || !Objects.equals(name1.getValue(), name2.getValue())) {
            return false;
        }
        String name1qual = name1.getNameQualifier();
        String name2qual = name2.getNameQualifier();
        if (name1qual == null) {
            name1qual = assertingParty;
        }
        if (name2qual == null) {
            name2qual = assertingParty;
        }
        if (!Objects.equals(name1qual, name2qual)) {
            return false;
        }
        name1qual = name1.getSPNameQualifier();
        name2qual = name2.getSPNameQualifier();
        if (name1qual == null) {
            name1qual = relyingParty;
        }
        if (name2qual == null) {
            name2qual = relyingParty;
        }
        return Objects.equals(name1qual, name2qual);
    }
}

