/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.MicrometerRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class MicrometerProvider
implements MetricsProvider {
    @Inject
    MeterRegistry registry;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    boolean metricsEnabled;
    @Inject
    ExecutorHolder executorHolder;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @PostConstruct
    void init() {
        Timer timer = this.executorHolder.getTimer();
        this.registry.gauge("ft.timer.scheduled", Collections.singletonList(Tag.of((String)"id", (String)("" + timer.getId()))), (Object)timer, Timer::countScheduledTasks);
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.metricsEnabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new MicrometerRecorder(this.registry, operation));
        }
        return MetricsRecorder.NOOP;
    }
}

