/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.token;

import jakarta.faces.context.FacesContext;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.Hex;
import org.apache.myfaces.util.token.CsrfSessionTokenFactory;
import org.apache.myfaces.util.token.SessionIdGenerator;

public class CsrfSessionTokenFactorySecureRandom
extends CsrfSessionTokenFactory {
    public static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_CLASS_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_CLASS";
    public static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_PROVIDER_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_PROVIDER";
    public static final String RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM_PARAM = "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM";
    private final SessionIdGenerator sessionIdGenerator;
    private final int length;

    public CsrfSessionTokenFactorySecureRandom(FacesContext facesContext) {
        String secureRandomAlgorithm;
        String secureRandomProvider;
        this.length = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_LENGTH", 16);
        this.sessionIdGenerator = new SessionIdGenerator();
        this.sessionIdGenerator.setSessionIdLength(this.length);
        String secureRandomClass = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_CLASS_PARAM);
        if (secureRandomClass != null) {
            this.sessionIdGenerator.setSecureRandomClass(secureRandomClass);
        }
        if ((secureRandomProvider = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_PROVIDER_PARAM)) != null) {
            this.sessionIdGenerator.setSecureRandomProvider(secureRandomProvider);
        }
        if ((secureRandomAlgorithm = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM_PARAM)) != null) {
            this.sessionIdGenerator.setSecureRandomAlgorithm(secureRandomAlgorithm);
        }
    }

    protected byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        this.sessionIdGenerator.getRandomBytes(array);
        return array;
    }

    @Override
    public String createToken(FacesContext context) {
        byte[] key = this.generateKey(context);
        return new String(Hex.encodeHex(key));
    }
}

