/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import jakarta.inject.Provider;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.webbeans.util.ExceptionUtil;

public abstract class AbstractInvocationContext<T>
implements InvocationContext {
    protected Provider<T> target;
    private AccessibleObject member;
    protected Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;

    public AbstractInvocationContext(Provider<T> target, AccessibleObject member, Object[] parameters) {
        this.target = target;
        this.member = member;
        this.parameters = parameters;
        if (!member.isAccessible()) {
            member.setAccessible(true);
        }
    }

    public AbstractInvocationContext(Provider<T> target, Method method, Object[] parameters, Object timer) {
        this(target, method, parameters);
        this.timer = timer;
    }

    public T getTarget() {
        return (T)this.target.get();
    }

    public Method getMethod() {
        if (Method.class.isInstance(this.member)) {
            return (Method)Method.class.cast(this.member);
        }
        return null;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public Object proceed() throws Exception {
        return this.directProceed();
    }

    public Object directProceed() throws Exception {
        try {
            return this.getMethod().invoke(this.target.get(), this.parameters);
        }
        catch (InvocationTargetException ite) {
            throw ExceptionUtil.throwAsRuntimeException(ite.getCause());
        }
    }

    public Constructor getConstructor() {
        if (Constructor.class.isInstance(this.member)) {
            return (Constructor)Constructor.class.cast(this.member);
        }
        return null;
    }
}

