/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.UnaryMathVal;
import org.apache.openjpa.kernel.exps.Val;

class Sign
extends UnaryMathVal {
    private static final long serialVersionUID = 1L;

    public Sign(Val val) {
        super(val);
    }

    @Override
    protected Class getType(Class c) {
        return Integer.TYPE;
    }

    @Override
    protected Object operate(Object o, Class c) {
        c = Filters.wrap(c);
        float value = 0.0f;
        if (c == Integer.class || c == Float.class || c == Double.class || c == Long.class) {
            value = ((Number)o).floatValue();
        } else if (c == BigDecimal.class) {
            value = ((BigDecimal)o).floatValue();
        } else if (c == BigInteger.class) {
            value = ((BigInteger)o).floatValue();
        }
        return Math.round(Math.signum(value));
    }
}

