/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.xbean.recipe.ObjectRecipe;

public final class ListConfigurator {
    private ListConfigurator() {
    }

    public static <T> List<T> getList(Properties properties, String key, ClassLoader classloader, Class<T> filter) {
        String[] split;
        if (properties == null) {
            return null;
        }
        String features = properties.getProperty(key);
        if (features == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String feature : split = features.trim().split(",")) {
            if (feature == null || feature.trim().isEmpty()) continue;
            String prefix = key + "." + feature + ".";
            ObjectRecipe recipe = new ObjectRecipe(feature);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String current = entry.getKey().toString();
                if (!current.startsWith(prefix)) continue;
                String property = current.substring(prefix.length());
                recipe.setProperty(property, entry.getValue());
            }
            Object instance = recipe.create(classloader);
            if (!filter.isInstance(instance)) {
                throw new OpenEJBRuntimeException(feature + " is not an abstract feature");
            }
            list.add(filter.cast(instance));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }
}

