/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.AllMatchPredicate;
import net.shibboleth.shared.logic.AnyMatchPredicate;
import net.shibboleth.shared.logic.CaseInsensitiveStringMatchPredicate;

public final class PredicateSupport {
    private PredicateSupport() {
    }

    @Nonnull
    public static <T> Predicate<T> alwaysTrue() {
        return Predicates.alwaysTrue();
    }

    @Nonnull
    public static <T> Predicate<T> alwaysFalse() {
        return Predicates.alwaysFalse();
    }

    public static <T> boolean isAlwaysTrue(@Nonnull Predicate<T> p) {
        return p.equals(Predicates.alwaysTrue());
    }

    public static <T> boolean isAlwaysFalse(@Nonnull Predicate<T> p) {
        return p.equals(Predicates.alwaysFalse());
    }

    @Nonnull
    public static <T> Predicate<T> constant(boolean flag) {
        return flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    @Nonnull
    public static <T> Predicate<Iterable<T>> allMatch(@Nonnull Predicate<T> target) {
        return new AllMatchPredicate<T>(target);
    }

    @Nonnull
    public static <T> Predicate<Iterable<T>> anyMatch(@Nonnull Predicate<T> target) {
        return new AnyMatchPredicate<T>(target);
    }

    @Nonnull
    public static Predicate<CharSequence> caseInsensitiveMatch(@Nonnull String target) {
        return new CaseInsensitiveStringMatchPredicate(target);
    }

    @Nonnull
    public static <T> Predicate<T> fromFunction(final @Nonnull Function<T, Boolean> function, final @Nonnull Predicate<? super T> defValue) {
        return new Predicate<T>(){

            @Override
            public boolean test(@Nullable T input) {
                Boolean result = (Boolean)function.apply(input);
                return result != null ? result.booleanValue() : defValue.test(input);
            }
        };
    }

    @Nonnull
    public static <T> Predicate<T> not(@Nonnull Predicate<? super T> predicate) {
        return predicate.negate()::test;
    }

    @Nonnull
    public static <T> Predicate<T> and(@Nonnull Iterable<? extends Predicate<? super T>> components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (Predicate<T> predicate : components) {
            copy.add(predicate::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.and(copy)).test(arg_0);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (Predicate<? super T> p : components) {
            copy.add(p::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.and(copy)).test(arg_0);
    }

    @Nonnull
    public static <T> Predicate<T> and(@Nonnull Predicate<? super T> first, @Nonnull Predicate<? super T> second) {
        return t -> first.test(t) && second.test(t);
    }

    @Nonnull
    public static <T> Predicate<T> or(@Nonnull Iterable<? extends Predicate<? super T>> components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (Predicate<T> predicate : components) {
            copy.add(predicate::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.or(copy)).test(arg_0);
    }

    @SafeVarargs
    @Nonnull
    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        ArrayList<com.google.common.base.Predicate> copy = new ArrayList<com.google.common.base.Predicate>();
        for (Predicate<? super T> p : components) {
            copy.add(p::test);
        }
        return arg_0 -> ((com.google.common.base.Predicate)Predicates.or(copy)).test(arg_0);
    }

    @Nonnull
    public static <T> Predicate<T> or(@Nonnull Predicate<? super T> first, @Nonnull Predicate<? super T> second) {
        return t -> first.test(t) || second.test(t);
    }
}

