/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.bval.jsr.metadata.ValidatorMappingProvider;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public abstract class ClassLoadingValidatorMappingProvider
extends ValidatorMappingProvider {
    protected final <T> Stream<Class<? extends T>> load(Stream<String> classNames, Class<T> assignableTo, Consumer<? super ClassNotFoundException> handleException) {
        return classNames.map(className -> {
            try {
                return Reflection.toClass(className, this.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                handleException.accept(e);
                return null;
            }
        }).filter(Objects::nonNull).map(c -> c.asSubclass(assignableTo));
    }

    protected ClassLoader getClassLoader() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        return classloader == null ? this.getClass().getClassLoader() : classloader;
    }
}

