/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.enterprise.identitystore;

import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public interface IdentityStore {
    public static final Set<ValidationType> DEFAULT_VALIDATION_TYPES = EnumSet.of(ValidationType.VALIDATE, ValidationType.PROVIDE_GROUPS);

    default public CredentialValidationResult validate(Credential credential) {
        try {
            return (CredentialValidationResult)CredentialValidationResult.class.cast(MethodHandles.lookup().bind(this, "validate", MethodType.methodType(CredentialValidationResult.class, credential.getClass())).invoke(credential));
        }
        catch (NoSuchMethodException e) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    default public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        return Collections.emptySet();
    }

    default public int priority() {
        return 100;
    }

    default public Set<ValidationType> validationTypes() {
        return DEFAULT_VALIDATION_TYPES;
    }

    public static enum ValidationType {
        VALIDATE,
        PROVIDE_GROUPS;

    }
}

