/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd.part;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletRequestContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.part.CommonsFileUploadPart;

public final class CommonsFileUploadPartFactory {
    private static final File REPO;

    private CommonsFileUploadPartFactory() {
    }

    public static Collection<Part> read(HttpRequestImpl request) {
        DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setPath(REPO.toPath())).get();
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        upload.setFileItemFactory((FileItemFactory)factory);
        ArrayList<Part> parts = new ArrayList<Part>();
        try {
            List items = upload.parseRequest((RequestContext)new JakartaServletRequestContext((HttpServletRequest)request));
            String enc = request.getCharacterEncoding();
            for (FileItem item : items) {
                CommonsFileUploadPart part = new CommonsFileUploadPart(item, null);
                parts.add(part);
                if (part.getSubmittedFileName() != null) continue;
                String name = part.getName();
                String value = null;
                try {
                    String encoding = request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = enc == null ? "UTF-8" : enc;
                    }
                    value = part.getString(encoding);
                }
                catch (IOException uee) {
                    try {
                        value = part.getString(String.valueOf(StandardCharsets.UTF_8));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                request.addInternalParameter(name, value);
            }
            return parts;
        }
        catch (FileUploadException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        String repo = SystemInstance.get().getProperty("tomee.embedded.http.file.repository");
        if (repo == null) {
            for (String potential : Arrays.asList("work", "temp", "target", "build")) {
                try {
                    File directory = SystemInstance.get().getBase().getDirectory(potential);
                    if (!directory.isDirectory()) continue;
                    repo = directory.getAbsolutePath();
                    break;
                }
                catch (IOException iOException) {
                }
            }
        }
        REPO = new File(repo == null ? "." : repo);
    }
}

