/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicAlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;

public class BasicEncryptionConfiguration
extends BasicAlgorithmPolicyConfiguration
implements EncryptionConfiguration {
    @Nonnull
    private List<Credential> dataEncryptionCredentials = CollectionSupport.emptyList();
    @Nonnull
    private List<String> dataEncryptionAlgorithms = CollectionSupport.emptyList();
    @Nonnull
    private List<Credential> keyTransportEncryptionCredentials = CollectionSupport.emptyList();
    @Nonnull
    private List<String> keyTransportEncryptionAlgorithms = CollectionSupport.emptyList();
    @Nullable
    private NamedKeyInfoGeneratorManager dataKeyInfoGeneratorManager;
    @Nullable
    private NamedKeyInfoGeneratorManager keyTransportKeyInfoGeneratorManager;
    @Nullable
    private RSAOAEPParameters rsaOAEPParameters;
    private boolean rsaOAEPParametersMerge = true;
    @Nullable
    private KeyTransportAlgorithmPredicate keyTransportPredicate;
    @Nonnull
    private Map<String, KeyAgreementEncryptionConfiguration> keyAgreementConfigurations = CollectionSupport.emptyMap();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Credential> getDataEncryptionCredentials() {
        return this.dataEncryptionCredentials;
    }

    @Nonnull
    public BasicEncryptionConfiguration setDataEncryptionCredentials(@Nullable List<Credential> credentials) {
        this.dataEncryptionCredentials = credentials == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(credentials);
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getDataEncryptionAlgorithms() {
        return this.dataEncryptionAlgorithms;
    }

    @Nonnull
    public BasicEncryptionConfiguration setDataEncryptionAlgorithms(@Nullable List<String> algorithms) {
        this.dataEncryptionAlgorithms = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(algorithms));
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Credential> getKeyTransportEncryptionCredentials() {
        return this.keyTransportEncryptionCredentials;
    }

    @Nonnull
    public BasicEncryptionConfiguration setKeyTransportEncryptionCredentials(@Nullable List<Credential> credentials) {
        this.keyTransportEncryptionCredentials = credentials == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(credentials);
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getKeyTransportEncryptionAlgorithms() {
        return this.keyTransportEncryptionAlgorithms;
    }

    @Nonnull
    public BasicEncryptionConfiguration setKeyTransportEncryptionAlgorithms(@Nullable List<String> algorithms) {
        this.keyTransportEncryptionAlgorithms = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(algorithms));
        return this;
    }

    @Nullable
    public NamedKeyInfoGeneratorManager getDataKeyInfoGeneratorManager() {
        return this.dataKeyInfoGeneratorManager;
    }

    @Nonnull
    public BasicEncryptionConfiguration setDataKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.dataKeyInfoGeneratorManager = keyInfoManager;
        return this;
    }

    @Nullable
    public NamedKeyInfoGeneratorManager getKeyTransportKeyInfoGeneratorManager() {
        return this.keyTransportKeyInfoGeneratorManager;
    }

    @Nonnull
    public BasicEncryptionConfiguration setKeyTransportKeyInfoGeneratorManager(@Nullable NamedKeyInfoGeneratorManager keyInfoManager) {
        this.keyTransportKeyInfoGeneratorManager = keyInfoManager;
        return this;
    }

    @Nullable
    public RSAOAEPParameters getRSAOAEPParameters() {
        return this.rsaOAEPParameters;
    }

    @Nonnull
    public BasicEncryptionConfiguration setRSAOAEPParameters(@Nullable RSAOAEPParameters params) {
        this.rsaOAEPParameters = params;
        return this;
    }

    public boolean isRSAOAEPParametersMerge() {
        return this.rsaOAEPParametersMerge;
    }

    @Nonnull
    public BasicEncryptionConfiguration setRSAOAEPParametersMerge(boolean flag) {
        this.rsaOAEPParametersMerge = flag;
        return this;
    }

    @Nullable
    public KeyTransportAlgorithmPredicate getKeyTransportAlgorithmPredicate() {
        return this.keyTransportPredicate;
    }

    @Nonnull
    public BasicEncryptionConfiguration setKeyTransportAlgorithmPredicate(@Nullable KeyTransportAlgorithmPredicate predicate) {
        this.keyTransportPredicate = predicate;
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, KeyAgreementEncryptionConfiguration> getKeyAgreementConfigurations() {
        return this.keyAgreementConfigurations;
    }

    @Nonnull
    public BasicEncryptionConfiguration setKeyAgreementConfigurations(@Nullable Map<String, KeyAgreementEncryptionConfiguration> configs) {
        this.keyAgreementConfigurations = configs == null ? CollectionSupport.emptyMap() : CollectionSupport.copyToMap(configs);
        return this;
    }
}

