/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;

public interface EncryptionConfiguration
extends AlgorithmPolicyConfiguration {
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Credential> getDataEncryptionCredentials();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getDataEncryptionAlgorithms();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Credential> getKeyTransportEncryptionCredentials();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getKeyTransportEncryptionAlgorithms();

    @Nullable
    public NamedKeyInfoGeneratorManager getDataKeyInfoGeneratorManager();

    @Nullable
    public NamedKeyInfoGeneratorManager getKeyTransportKeyInfoGeneratorManager();

    @Nullable
    public RSAOAEPParameters getRSAOAEPParameters();

    public boolean isRSAOAEPParametersMerge();

    @Nullable
    public KeyTransportAlgorithmPredicate getKeyTransportAlgorithmPredicate();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, KeyAgreementEncryptionConfiguration> getKeyAgreementConfigurations();
}

