/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ApplicationResourceBundle {
    public static final String DEFAULT_KEY = "DEFAULT";
    private final String baseName;
    private final Map<String, String> displayNames;
    private final Map<String, String> descriptions;
    private volatile Map<Locale, ResourceBundle> resources;

    public ApplicationResourceBundle(String baseName, Map<String, String> displayNames, Map<String, String> descriptions) {
        if (baseName == null) {
            throw new IllegalArgumentException();
        }
        this.baseName = baseName;
        this.displayNames = displayNames;
        this.descriptions = descriptions;
        this.resources = new HashMap<Locale, ResourceBundle>(4, 1.0f);
    }

    public String getBaseName() {
        return this.baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle bundle;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = this.resources.get(locale)) == null) {
            ClassLoader loader = Util.getCurrentLoader(this);
            ApplicationResourceBundle applicationResourceBundle = this;
            synchronized (applicationResourceBundle) {
                bundle = this.resources.get(locale);
                if (bundle == null) {
                    bundle = ResourceBundle.getBundle(this.baseName, locale, loader);
                    this.resources.put(locale, bundle);
                }
            }
        }
        return bundle;
    }

    public String getDisplayName(Locale locale) {
        String displayName = null;
        if (this.displayNames != null) {
            displayName = this.queryMap(locale, this.displayNames);
        }
        return Util.coalesce(displayName, "");
    }

    public String getDescription(Locale locale) {
        String description = null;
        if (this.descriptions != null) {
            description = this.queryMap(locale, this.descriptions);
        }
        return Util.coalesce(description, "");
    }

    private String queryMap(Locale locale, Map<String, String> map) {
        if (locale == null) {
            return map.get(DEFAULT_KEY);
        }
        String description = map.get(locale.toString());
        if (description == null) {
            return map.get(DEFAULT_KEY);
        }
        return null;
    }
}

