/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import jakarta.activation.DataSource;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.LogicalMessage;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogicalMessageImpl
implements LogicalMessage {
    private static final Logger LOG = LogUtils.getL7dLogger(LogicalMessageImpl.class);
    private final LogicalMessageContextImpl msgContext;

    public LogicalMessageImpl(LogicalMessageContextImpl lmctx) {
        this.msgContext = lmctx;
    }

    public Source getPayload() {
        Source source;
        Service.Mode mode = (Service.Mode)this.msgContext.getWrappedMessage().getExchange().get(Service.Mode.class);
        if (mode != null) {
            source = this.handleDispatchProviderCase(mode);
        } else {
            Message message = this.msgContext.getWrappedMessage();
            source = (Source)message.getContent(Source.class);
            if (source == null) {
                SOAPMessage msg = (SOAPMessage)message.getContent(SOAPMessage.class);
                XMLStreamReader reader = null;
                if (msg != null) {
                    try {
                        Node node;
                        for (node = SAAJUtils.getBody((SOAPMessage)msg).getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
                        }
                        source = new DOMSource(node);
                        reader = StaxUtils.createXMLStreamReader((Source)source);
                    }
                    catch (SOAPException e) {
                        throw new Fault((Throwable)e);
                    }
                }
                if (source == null) {
                    try {
                        DocumentFragment doc = DOMUtils.getEmptyDocument().createDocumentFragment();
                        W3CDOMStreamWriter writer = new W3CDOMStreamWriter(doc);
                        reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
                        StaxUtils.toNextTag((XMLStreamReader)reader);
                        StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer, (boolean)true);
                        doc.appendChild(DOMUtils.getFirstElement((Node)writer.getCurrentFragment()));
                        source = new DOMSource(DOMUtils.getFirstElement((Node)doc));
                        reader = StaxUtils.createXMLStreamReader((Element)DOMUtils.getFirstElement((Node)doc));
                    }
                    catch (XMLStreamException e) {
                        throw new Fault((Throwable)e);
                    }
                }
                message.setContent(XMLStreamReader.class, reader);
                message.setContent(Source.class, (Object)source);
            } else if (!(source instanceof DOMSource)) {
                W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
                if (reader == null) {
                    reader = StaxUtils.createXMLStreamReader((Source)source);
                }
                try {
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
                }
                catch (XMLStreamException e) {
                    throw new Fault((Throwable)e);
                }
                source = new DOMSource(writer.getDocument().getDocumentElement());
                reader = StaxUtils.createXMLStreamReader((Document)writer.getDocument());
                message.setContent(XMLStreamReader.class, (Object)reader);
                message.setContent(Source.class, (Object)source);
            }
        }
        return source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Source handleDispatchProviderCase(Service.Mode mode) {
        Source source = null;
        Message message = this.msgContext.getWrappedMessage();
        Source obj = (Source)message.getContent(Source.class);
        if (message instanceof SoapMessage) {
            CachedOutputStream cos;
            if (obj instanceof StreamSource) {
                try {
                    cos = new CachedOutputStream();
                    try {
                        StaxUtils.copy((Source)obj, (OutputStream)cos);
                        obj = new StreamSource(cos.getInputStream());
                        message.setContent(Source.class, (Object)new StreamSource(cos.getInputStream()));
                    }
                    finally {
                        cos.close();
                    }
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
            if (mode == Service.Mode.PAYLOAD) {
                return obj;
            }
            try {
                cos = new CachedOutputStream();
                try {
                    StaxUtils.copy((Source)obj, (OutputStream)cos);
                    InputStream in = cos.getInputStream();
                    SOAPMessage msg = this.initSOAPMessage(in);
                    source = new DOMSource(SAAJUtils.getBody((SOAPMessage)msg).getFirstChild());
                    in.close();
                    return source;
                }
                finally {
                    cos.close();
                }
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
        if (!(message instanceof XMLMessage)) return source;
        if (obj != null) {
            return obj;
        }
        if (message.getContent(DataSource.class) == null) return source;
        throw new Fault(new org.apache.cxf.common.i18n.Message("GETPAYLOAD_OF_DATASOURCE_NOT_VALID_XMLHTTPBINDING", LOG, new Object[0]));
    }

    public void setPayload(Source s) {
        Message message = this.msgContext.getWrappedMessage();
        Service.Mode mode = (Service.Mode)this.msgContext.getWrappedMessage().getContextualProperty(Service.Mode.class.getName());
        SOAPMessage m = (SOAPMessage)message.getContent(SOAPMessage.class);
        if (m != null && !MessageUtils.isOutbound((Message)message)) {
            try {
                SAAJUtils.getBody((SOAPMessage)m).removeContents();
                W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Element)SAAJUtils.getBody((SOAPMessage)m));
                StaxUtils.copy((Source)s, (XMLStreamWriter)writer);
                writer.flush();
                writer.close();
                s = mode == Service.Mode.MESSAGE ? new DOMSource((Node)m.getSOAPPart()) : new DOMSource(SAAJUtils.getBody((SOAPMessage)m).getFirstChild());
                W3CDOMStreamReader r = new W3CDOMStreamReader(DOMUtils.getFirstElement((Node)SAAJUtils.getBody((SOAPMessage)m)));
                message.setContent(XMLStreamReader.class, (Object)r);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        } else if (mode != null) {
            if (message instanceof SoapMessage) {
                if (mode == Service.Mode.MESSAGE) {
                    try {
                        SOAPMessage msg = this.initSOAPMessage(null);
                        this.write(s, (Node)SAAJUtils.getBody((SOAPMessage)msg));
                        s = new DOMSource((Node)msg.getSOAPPart());
                    }
                    catch (Exception e) {
                        throw new Fault((Throwable)e);
                    }
                }
            } else if (message instanceof XMLMessage && message.getContent(DataSource.class) != null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("GETPAYLOAD_OF_DATASOURCE_NOT_VALID_XMLHTTPBINDING", LOG, new Object[0]));
            }
        } else {
            XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)s);
            this.msgContext.getWrappedMessage().setContent(XMLStreamReader.class, (Object)reader);
        }
        this.msgContext.getWrappedMessage().setContent(Source.class, (Object)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getPayload(JAXBContext arg0) {
        Object object;
        Source s = this.getPayload();
        if (!(s instanceof DOMSource)) return JAXBUtils.unmarshall((JAXBContext)arg0, (Source)this.getPayload());
        DOMSource ds = (DOMSource)s;
        ds.setNode(DOMUtils.getDomElement((Node)ds.getNode()));
        Node parent = ds.getNode().getParentNode();
        Node next = ds.getNode().getNextSibling();
        if (parent instanceof DocumentFragment) {
            parent.removeChild(ds.getNode());
        }
        try {
            object = JAXBUtils.unmarshall((JAXBContext)arg0, (Source)ds);
        }
        catch (Throwable throwable) {
            try {
                if (!(parent instanceof DocumentFragment)) throw throwable;
                parent.insertBefore(ds.getNode(), next);
                throw throwable;
            }
            catch (JAXBException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        if (!(parent instanceof DocumentFragment)) return object;
        parent.insertBefore(ds.getNode(), next);
        return object;
    }

    public void setPayload(Object arg0, JAXBContext arg1) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            arg1.createMarshaller().marshal(arg0, (XMLStreamWriter)writer);
            DOMSource source = new DOMSource(writer.getDocument().getDocumentElement());
            this.setPayload(source);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private void write(Source source, Node n) {
        try {
            if (source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
                return;
            }
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Element)n);
            StaxUtils.copy((Source)source, (XMLStreamWriter)writer);
        }
        catch (XMLStreamException e) {
            throw new Fault((Throwable)e);
        }
    }

    private SOAPMessage initSOAPMessage(InputStream is) throws SOAPException, IOException {
        SOAPMessage msg = is != null ? SAAJFactoryResolver.createMessageFactory(null).createMessage(null, is) : SAAJFactoryResolver.createMessageFactory(null).createMessage();
        msg.setProperty("jakarta.xml.soap.write-xml-declaration", (Object)"true");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return msg;
    }
}

