/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;

public class Log4j2LogStreamFactory
implements LogStreamFactory {
    public Log4j2LogStreamFactory() {
        JavaSecurityManagers.setSystemProperty("openwebbeans.logging.factory", "org.apache.openejb.cdi.logging.Log4j2LoggerFactory");
    }

    @Override
    public LogStream createLogStream(LogCategory logCategory) {
        return new Log4j2Stream(logCategory.getName());
    }

    private class Log4j2Stream
    implements LogStream {
        private final Logger delegate;

        public Log4j2Stream(String name) {
            this.delegate = LogManager.getLogger((String)name);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.delegate.isFatalEnabled();
        }

        @Override
        public void fatal(String message) {
            this.delegate.fatal(message);
        }

        @Override
        public void fatal(String message, Throwable t) {
            this.delegate.fatal(message, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.delegate.isErrorEnabled();
        }

        @Override
        public void error(String message) {
            this.delegate.error(message);
        }

        @Override
        public void error(String message, Throwable t) {
            this.delegate.error(message, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.delegate.isWarnEnabled();
        }

        @Override
        public void warn(String message) {
            this.delegate.warn(message);
        }

        @Override
        public void warn(String message, Throwable t) {
            this.delegate.warn(message, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        @Override
        public void info(String message) {
            this.delegate.info(message);
        }

        @Override
        public void info(String message, Throwable t) {
            this.delegate.info(message, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        @Override
        public void debug(String message) {
            this.delegate.debug(message);
        }

        @Override
        public void debug(String message, Throwable t) {
            this.delegate.debug(message, t);
        }
    }
}

