/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;

public class IntraVmArtifact
implements Externalizable {
    private static final Handles staticHandles = new Handles(){

        @Override
        public synchronized int add(Object obj) {
            return super.add(obj);
        }

        @Override
        public synchronized Object get(int id) {
            return super.get(id);
        }
    };
    private static final ThreadLocal<Handles> threadHandles = new ThreadLocal<Handles>(){

        @Override
        protected Handles initialValue() {
            return new Handles();
        }
    };
    private static final String NO_ARTIFACT_ERROR = "The artifact this object represents could not be found.";
    private int instanceHandle;
    private boolean staticArtifact;

    public IntraVmArtifact(Object obj) {
        this(obj, false);
    }

    public IntraVmArtifact(Object obj, boolean storeStatically) {
        this.staticArtifact = storeStatically;
        Handles handles = IntraVmArtifact.getHandles(storeStatically);
        this.instanceHandle = handles.add(obj);
    }

    private static Handles getHandles(boolean staticArtifact) {
        return staticArtifact ? staticHandles : threadHandles.get();
    }

    public IntraVmArtifact() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.staticArtifact);
        out.writeInt(this.instanceHandle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.staticArtifact = in.readBoolean();
        this.instanceHandle = in.readInt();
    }

    protected Object readResolve() throws ObjectStreamException {
        Handles handles = IntraVmArtifact.getHandles(this.staticArtifact);
        Object artifact = handles.get(this.instanceHandle);
        if (artifact == null) {
            throw new InvalidObjectException(NO_ARTIFACT_ERROR + this.instanceHandle);
        }
        return artifact;
    }

    private static class Handles {
        private final List<Object> list = new ArrayList<Object>();

        private Handles() {
        }

        public int add(Object obj) {
            int id = this.list.size();
            this.list.add(obj);
            return id;
        }

        public Object get(int id) {
            Object obj = this.list.get(id);
            if (this.list.size() == id + 1) {
                this.list.clear();
            }
            return obj;
        }
    }
}

