/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client.proxy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.proxy.InvocationHandler;
import org.apache.openejb.client.proxy.ProxyFactory;

public class ProxyManager {
    private static final ProxyFactory defaultFactory;
    private static String defaultFactoryName;

    public static ProxyFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static String getDefaultFactoryName() {
        return defaultFactoryName;
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        return defaultFactory.getInvocationHandler(proxy);
    }

    public static Object setInvocationHandler(Object proxy, InvocationHandler handler) {
        return defaultFactory.setInvocationHandler(proxy, handler);
    }

    public static Class getProxyClass(Class interfaceType) throws IllegalAccessException {
        return ProxyManager.getProxyClass(new Class[]{interfaceType});
    }

    public static Class getProxyClass(Class[] interfaces) throws IllegalAccessException {
        return defaultFactory.getProxyClass(interfaces);
    }

    public static Object newProxyInstance(Class interfaceType, InvocationHandler h) throws IllegalAccessException {
        return ProxyManager.newProxyInstance(new Class[]{interfaceType}, h);
    }

    public static Object newProxyInstance(Class[] interfaces, InvocationHandler h) throws IllegalAccessException {
        return defaultFactory.newProxyInstance(interfaces, h);
    }

    public static boolean isProxyClass(Class cl) {
        return defaultFactory.isProxyClass(cl);
    }

    public static Object newProxyInstance(Class proxyClass) throws IllegalAccessException {
        return defaultFactory.newProxyInstance(proxyClass);
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static {
        Class<?> factory;
        String version;
        try {
            version = System.getProperty("java.vm.version");
        }
        catch (Exception e) {
            throw new ClientRuntimeException("Unable to determine the version of your VM.  No ProxyFactory Can be installed");
        }
        ClassLoader cl = ProxyManager.getContextClassLoader();
        if (version.startsWith("1.1")) {
            throw new ClientRuntimeException("This VM version is not supported: " + version);
        }
        if (version.startsWith("1.2")) {
            defaultFactoryName = "JDK 1.2 ProxyFactory";
            try {
                Class.forName("org.opentools.proxies.Proxy", true, cl);
            }
            catch (Exception e) {
                throw new ClientRuntimeException("No ProxyFactory Can be installed. Unable to load the class org.opentools.proxies.Proxy.  This class is needed for generating proxies in JDK 1.2 VMs.");
            }
            try {
                factory = Class.forName("org.apache.openejb.client.proxy.Jdk12ProxyFactory", true, cl);
            }
            catch (Exception e) {
                throw new ClientRuntimeException("No ProxyFactory Can be installed. Unable to load the class org.apache.openejb.client.proxy.Jdk12ProxyFactory.");
            }
        }
        defaultFactoryName = "JDK 1.3 ProxyFactory";
        try {
            factory = Class.forName("org.apache.openejb.client.proxy.Jdk13ProxyFactory", true, cl);
        }
        catch (Exception e) {
            throw new ClientRuntimeException("No ProxyFactory Can be installed. Unable to load the class org.apache.openejb.client.proxy.Jdk13ProxyFactory.");
        }
        try {
            defaultFactory = (ProxyFactory)factory.newInstance();
            defaultFactory.init(new Properties());
        }
        catch (Exception e) {
            throw new ClientRuntimeException("No ProxyFactory Can be installed. Unable to load the class org.apache.openejb.client.proxy.Jdk13ProxyFactory.");
        }
    }
}

