/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.spi.ConverterProvider;

public class ConverterManager {
    private final Map<String, Supplier<Converter>> converters;

    public static final ConverterManager getInstance() {
        return Instance.INSTANCE;
    }

    private ConverterManager() {
        HashMap<String, Supplier<Converter>> converters = new HashMap<String, Supplier<Converter>>();
        ServiceLoader<ConverterProvider> providers = ServiceLoader.load(ConverterProvider.class);
        for (ConverterProvider provider : providers) {
            Map<String, Supplier<Converter>> providerConverters = provider.converters();
            for (String type : providerConverters.keySet()) {
                if (converters.containsKey(type)) continue;
                converters.put(type, providerConverters.get(type));
            }
        }
        this.converters = Collections.unmodifiableMap(converters);
    }

    public boolean hasConverter(String type) {
        return this.converters.containsKey(type);
    }

    public Converter createConverter(String type) {
        return this.converters.get(type).get();
    }

    private static final class Instance {
        private static final ConverterManager INSTANCE = new ConverterManager();

        private Instance() {
        }
    }
}

