/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.provider.AbstractResponseViewProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class RequestDispatcherProvider
extends AbstractResponseViewProvider {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(RequestDispatcherProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(RequestDispatcherProvider.class);
    private static final String ABSOLUTE_PATH_PARAMETER = "absolute.path";
    private static final String BASE_PATH_PARAMETER = "base.path";
    private static final String WEBAPP_BASE_PATH_PARAMETER = "webapp.base.path";
    private static final String RELATIVE_PATH_PARAMETER = "relative.path";
    private static final String REQUEST_SCOPE = "request";
    private static final String SESSION_SCOPE = "session";
    private static final String DEFAULT_RESOURCE_EXTENSION = ".jsp";
    private static final String DEFAULT_LOCATION_PREFIX = "/WEB-INF/";
    private String servletContextPath;
    private String scope = "request";
    private String dispatcherName;
    private String servletPath;
    private boolean useCurrentServlet;
    private boolean saveParametersAsAttributes;
    private boolean includeResource;

    @Override
    protected String getDefaultLocationPrefix() {
        return DEFAULT_LOCATION_PREFIX;
    }

    @Override
    protected String getDefaultResourceExtension() {
        return DEFAULT_RESOURCE_EXTENSION;
    }

    public void writeTo(Object o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        String theServletPath;
        ServletContext sc = this.getServletContext();
        HttpServletRequest servletRequest = this.getMessageContext().getHttpServletRequest();
        Object path = this.getResourcePath(clazz, o);
        String string = this.servletPath != null ? this.servletPath : (theServletPath = this.useCurrentServlet ? servletRequest.getServletPath() : "/");
        if (theServletPath.endsWith("/") && path != null && ((String)path).startsWith("/")) {
            theServletPath = theServletPath.length() == 1 ? "" : theServletPath.substring(0, theServletPath.length() - 1);
        } else if (!theServletPath.endsWith("/") && path != null && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        RequestDispatcher rd = this.getRequestDispatcher(sc, clazz, theServletPath + (String)path);
        try {
            if (!this.includeResource) {
                this.getMessageContext().put("http.request.redirected", Boolean.TRUE);
            }
            HttpServletRequestFilter requestFilter = new HttpServletRequestFilter(servletRequest, (String)path, theServletPath, this.saveParametersAsAttributes);
            String attributeName = this.getBeanName(o);
            if (REQUEST_SCOPE.equals(this.scope)) {
                requestFilter.setAttribute(attributeName, o);
            } else if (SESSION_SCOPE.equals(this.scope)) {
                requestFilter.getSession(true).setAttribute(attributeName, o);
            }
            this.setRequestParameters(requestFilter);
            this.logRedirection((String)path, attributeName, o);
            if (this.includeResource) {
                rd.include((ServletRequest)requestFilter, (ServletResponse)this.getMessageContext().getHttpServletResponse());
            } else {
                rd.forward((ServletRequest)requestFilter, (ServletResponse)this.getMessageContext().getHttpServletResponse());
            }
        }
        catch (Throwable ex) {
            this.handleViewRenderingException(theServletPath + (String)path, ex);
        }
    }

    private void logRedirection(String path, String attributeName, Object o) {
        Level level;
        Level level2 = level = this.isLogRedirects() ? Level.INFO : Level.FINE;
        if (LOG.isLoggable(level)) {
            String message = new Message("RESPONSE_REDIRECTED_TO", BUNDLE, new Object[]{o.getClass().getName(), attributeName, path}).toString();
            LOG.log(level, message);
        }
    }

    protected ServletContext getServletContext() {
        ServletContext sc = this.getMessageContext().getServletContext();
        if (this.servletContextPath != null && (sc = sc.getContext(this.servletContextPath)) == null) {
            String message = new Message("RESOURCE_DISPATCH_NOT_FOUND", BUNDLE, new Object[]{this.servletContextPath}).toString();
            LOG.severe(message);
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        return sc;
    }

    protected RequestDispatcher getRequestDispatcher(ServletContext sc, Class<?> clazz, String path) {
        RequestDispatcher rd;
        RequestDispatcher requestDispatcher = rd = this.dispatcherName != null ? sc.getNamedDispatcher(this.dispatcherName) : sc.getRequestDispatcher(path);
        if (rd == null) {
            String message = new Message("RESOURCE_PATH_NOT_FOUND", BUNDLE, new Object[]{path}).toString();
            LOG.severe(message);
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        return rd;
    }

    public void setServletContextPath(String servletContextPath) {
        this.servletContextPath = servletContextPath;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    protected void setRequestParameters(HttpServletRequestFilter request) {
        if (this.getMessageContext() != null) {
            UriInfo ui = this.getMessageContext().getUriInfo();
            MultivaluedMap params = ui.getPathParameters();
            for (Map.Entry entry : params.entrySet()) {
                String value = (String)((List)entry.getValue()).get(0);
                int ind = value.indexOf(59);
                if (ind > 0) {
                    value = value.substring(0, ind);
                }
                request.setParameter((String)entry.getKey(), value);
            }
            List segments = ui.getPathSegments();
            if (!segments.isEmpty()) {
                this.doSetRequestParameters(request, (MultivaluedMap<String, String>)((PathSegment)segments.get(segments.size() - 1)).getMatrixParameters());
            }
            this.doSetRequestParameters(request, (MultivaluedMap<String, String>)ui.getQueryParameters());
            request.setParameter(ABSOLUTE_PATH_PARAMETER, ui.getAbsolutePath().toString());
            request.setParameter(RELATIVE_PATH_PARAMETER, ui.getPath());
            request.setParameter(BASE_PATH_PARAMETER, ui.getBaseUri().toString());
            request.setParameter(WEBAPP_BASE_PATH_PARAMETER, (String)this.getMessageContext().get("http.base.path"));
        }
    }

    protected void doSetRequestParameters(HttpServletRequestFilter req, MultivaluedMap<String, String> params) {
        for (Map.Entry entry : params.entrySet()) {
            req.setParameters((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public void setDispatcherName(String name) {
        this.dispatcherName = name;
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    public void setSaveParametersAsAttributes(boolean saveParametersAsAttributes) {
        this.saveParametersAsAttributes = saveParametersAsAttributes;
    }

    public void setUseCurrentServlet(boolean useCurrentServlet) {
        this.useCurrentServlet = useCurrentServlet;
    }

    public void setIncludeResource(boolean includeResource) {
        this.includeResource = includeResource;
    }

    @Override
    protected boolean resourceAvailable(String resourceName) {
        return ResourceUtils.getClasspathResourceURL(resourceName, RequestDispatcherProvider.class, this.getBus()) != null;
    }

    protected static class HttpServletRequestFilter
    extends HttpServletRequestWrapper {
        private Map<String, String[]> params;
        private String path;
        private String servletPath;
        private boolean saveParamsAsAttributes;

        public HttpServletRequestFilter(HttpServletRequest request, String path, String servletPath, boolean saveParamsAsAttributes) {
            super(request);
            this.path = path;
            this.servletPath = servletPath;
            this.saveParamsAsAttributes = saveParamsAsAttributes;
            this.params = new HashMap<String, String[]>(request.getParameterMap());
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.path;
        }

        public void setParameter(String name, String value) {
            this.doSetParameters(name, new String[]{value});
        }

        public void setParameters(String name, List<String> values) {
            this.doSetParameters(name, values.toArray(new String[0]));
        }

        private void doSetParameters(String name, String[] values) {
            if (this.saveParamsAsAttributes) {
                super.setAttribute(name, (Object)values);
            } else {
                this.params.put(name, values);
            }
        }

        public String getParameter(String name) {
            String[] values = this.params.get(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public Map<String, String[]> getParameterMap() {
            return this.params;
        }

        public Enumeration<String> getParameterNames() {
            final Iterator<String> it = this.params.keySet().iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)it.next();
                }
            };
        }

        public String[] getParameterValues(String name) {
            return this.params.get(name);
        }
    }
}

