/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.retry;

import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.SyncDelay;
import io.smallrye.faulttolerance.core.util.Preconditions;

public class ThreadSleepDelay
implements SyncDelay {
    private final BackOff backOff;

    public ThreadSleepDelay(BackOff backOff) {
        this.backOff = Preconditions.checkNotNull(backOff, "Back-off must be set");
    }

    @Override
    public void sleep(Throwable cause) throws InterruptedException {
        long delay = this.backOff.getInMillis(cause);
        if (delay > 0L) {
            Thread.sleep(delay);
        }
    }
}

