/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey;

import io.churchkey.Key;
import io.churchkey.shade.util.IO;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Objects;

public class Keys {
    private Keys() {
    }

    public static Key decode(String contents) throws IOException {
        return Keys.decode(contents.getBytes(StandardCharsets.UTF_8));
    }

    public static Key decode(File file) throws IOException {
        return Keys.decode(IO.readBytes(file));
    }

    public static Key decode(byte[] bytes) {
        for (Key.Format format : Key.Format.values()) {
            Key key = format.decode(bytes);
            if (key == null) continue;
            return key;
        }
        throw new IllegalArgumentException("Cannot decode key: " + new String(bytes));
    }

    public static List<Key> decodeSet(String contents) throws IOException {
        return Keys.decodeSet(contents.getBytes(StandardCharsets.UTF_8));
    }

    public static List<Key> decodeSet(File file) throws IOException {
        return Keys.decodeSet(IO.readBytes(file));
    }

    public static List<Key> decodeSet(byte[] bytes) {
        for (Key.Format format : Key.Format.values()) {
            List<Key> keys = format.decodeSet(bytes);
            if (keys == null) continue;
            return keys;
        }
        throw new IllegalArgumentException("Cannot decode key: " + new String(bytes));
    }

    public static byte[] encode(Key key) {
        return Keys.encode(key, key.getFormat());
    }

    public static byte[] encode(Key key, Key.Format format) {
        return format.encode(key);
    }

    public static byte[] encodeSet(List<Key> keys, Key.Format format) {
        return format.encodeSet(keys);
    }

    public static Key of(KeyPair pair) {
        Objects.requireNonNull(pair);
        PrivateKey key = pair.getPrivate();
        if (key instanceof DSAPrivateKey) {
            return new Key((java.security.Key)pair.getPrivate(), pair.getPublic(), Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
        }
        if (key instanceof ECPrivateKey) {
            return new Key((java.security.Key)pair.getPrivate(), pair.getPublic(), Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new Key((java.security.Key)pair.getPrivate(), pair.getPublic(), Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
        }
        if (key instanceof RSAPrivateKey) {
            return new Key((java.security.Key)pair.getPrivate(), pair.getPublic(), Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
        }
        throw new UnsupportedOperationException("Unsupported key type: " + key.getClass().getName());
    }

    public static Key of(java.security.Key key) {
        Objects.requireNonNull(key);
        if (key instanceof RSAPrivateCrtKey) {
            return Keys.of((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return Keys.of((RSAPrivateKey)key);
        }
        if (key instanceof RSAPublicKey) {
            return Keys.of((RSAPublicKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return Keys.of((DSAPrivateKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return Keys.of((DSAPublicKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return Keys.of((ECPrivateKey)key);
        }
        if (key instanceof ECPublicKey) {
            return Keys.of((ECPublicKey)key);
        }
        throw new UnsupportedOperationException("Unsupported key type: " + key.getClass().getName());
    }

    private static Key of(DSAPrivateKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
    }

    private static Key of(DSAPublicKey key) {
        return new Key(key, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.PEM);
    }

    private static Key of(ECPrivateKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
    }

    private static Key of(ECPublicKey key) {
        return new Key(key, Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.PEM);
    }

    private static Key of(RSAPrivateCrtKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
    }

    private static Key of(RSAPrivateKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
    }

    private static Key of(RSAPublicKey key) {
        return new Key(key, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.PEM);
    }
}

