/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DropAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface Aggregator<T extends PointData, U extends ExemplarData> {
    public static Aggregator<?, DoubleExemplarData> drop() {
        return DropAggregator.INSTANCE;
    }

    public AggregatorHandle<T, U> createHandle();

    default public T diff(T previousCumulative, T currentCumulative) {
        throw new UnsupportedOperationException("This aggregator does not support diff.");
    }

    default public void diffInPlace(T previousCumulativeReusable, T currentCumulative) {
        throw new UnsupportedOperationException("This aggregator does not support diffInPlace.");
    }

    default public T toPoint(Measurement measurement) {
        throw new UnsupportedOperationException("This aggregator does not support toPoint.");
    }

    default public void toPoint(Measurement measurement, T reusablePoint) {
        throw new UnsupportedOperationException("This aggregator does not support toPoint.");
    }

    default public T createReusablePoint() {
        throw new UnsupportedOperationException("This aggregator does not support createReusablePoint.");
    }

    default public void copyPoint(T point, T toReusablePoint) {
        throw new UnsupportedOperationException("This aggregator does not support toPoint.");
    }

    public MetricData toMetricData(Resource var1, InstrumentationScopeInfo var2, MetricDescriptor var3, Collection<T> var4, AggregationTemporality var5);
}

