/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.OpenAPIDefinitionIO;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.IgnoreResolver;
import io.smallrye.openapi.runtime.scanner.dataobject.PropertyNamingStrategyFactory;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.util.Annotations;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AnnotationScannerContext {
    private final FilteredIndexView index;
    private final AugmentedIndexView augmentedIndex;
    private final IgnoreResolver ignoreResolver;
    private final List<AnnotationScannerExtension> extensions;
    private final OpenApiConfig config;
    private final UnaryOperator<String> propertyNameTranslator;
    private final ClassLoader classLoader;
    private final OpenAPI openApi;
    private final Deque<Type> scanStack = new ArrayDeque<Type>();
    private Deque<TypeResolver> resolverStack = new ArrayDeque<TypeResolver>();
    private final Optional<BeanValidationScanner> beanValidationScanner;
    private final Set<Type> jsonViews = new LinkedHashSet<Type>();
    private String[] currentConsumes;
    private String[] currentProduces;
    private String[] defaultConsumes;
    private String[] defaultProduces;
    private Optional<AnnotationScanner> currentScanner = Optional.empty();
    private final SchemaRegistry schemaRegistry;
    private final JavaSecurityProcessor javaSecurityProcessor;
    private final Annotations annotations;
    private final IOContext<?, ?, ?, ?, ?> ioContext;
    private final OpenAPIDefinitionIO<?, ?, ?, ?, ?> modelIO;
    private final Map<String, MethodInfo> operationIdMap = new HashMap<String, MethodInfo>();

    public AnnotationScannerContext(FilteredIndexView index, ClassLoader classLoader, List<AnnotationScannerExtension> extensions, boolean addDefaultExtension, OpenApiConfig config, OpenAPIDefinitionIO<?, ?, ?, ?, ?> modelIO, OpenAPI openApi) {
        this.index = index;
        this.augmentedIndex = AugmentedIndexView.augment(index);
        this.ignoreResolver = new IgnoreResolver(this);
        this.classLoader = classLoader;
        this.config = config;
        this.openApi = openApi;
        this.propertyNameTranslator = PropertyNamingStrategyFactory.getStrategy(config.propertyNamingStrategy(), classLoader);
        this.beanValidationScanner = config.scanBeanValidation() ? Optional.of(new BeanValidationScanner(this)) : Optional.empty();
        this.javaSecurityProcessor = new JavaSecurityProcessor(this);
        this.annotations = new Annotations(this);
        this.ioContext = IOContext.forScanning(this);
        OpenAPIDefinitionIO openAPIDefinitionIO = this.modelIO = modelIO != null ? modelIO : new OpenAPIDefinitionIO(this.ioContext);
        if (extensions.isEmpty()) {
            this.extensions = AnnotationScannerExtension.defaultExtension(this);
        } else {
            ArrayList<AnnotationScannerExtension> ext = new ArrayList<AnnotationScannerExtension>(extensions);
            if (addDefaultExtension) {
                ext.addAll(AnnotationScannerExtension.defaultExtension(this));
            }
            this.extensions = ext;
        }
        this.schemaRegistry = new SchemaRegistry(this);
    }

    public AnnotationScannerContext(FilteredIndexView index, ClassLoader classLoader, List<AnnotationScannerExtension> extensions, OpenApiConfig config, OpenAPI openApi) {
        this(index, classLoader, extensions, true, config, null, openApi);
    }

    public AnnotationScannerContext(IndexView index, ClassLoader classLoader, OpenApiConfig config) {
        this(new FilteredIndexView(index, config), classLoader, Collections.emptyList(), true, config, null, new OpenAPIImpl());
    }

    public FilteredIndexView getIndex() {
        return this.index;
    }

    public AugmentedIndexView getAugmentedIndex() {
        return this.augmentedIndex;
    }

    public IgnoreResolver getIgnoreResolver() {
        return this.ignoreResolver;
    }

    public List<AnnotationScannerExtension> getExtensions() {
        return this.extensions;
    }

    public OpenApiConfig getConfig() {
        return this.config;
    }

    public UnaryOperator<String> getPropertyNameTranslator() {
        return this.propertyNameTranslator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public OpenAPI getOpenApi() {
        return this.openApi;
    }

    public Deque<Type> getScanStack() {
        return this.scanStack;
    }

    public Deque<TypeResolver> getResolverStack() {
        return this.resolverStack;
    }

    public TypeResolver getResourceTypeResolver() {
        return this.resolverStack.peek();
    }

    public Optional<BeanValidationScanner> getBeanValidationScanner() {
        return this.beanValidationScanner;
    }

    public Set<Type> getJsonViews() {
        return this.jsonViews;
    }

    public Map<String, MethodInfo> getOperationIdMap() {
        return this.operationIdMap;
    }

    public String[] getCurrentConsumes() {
        return this.currentConsumes;
    }

    public void setCurrentConsumes(String[] currentConsumes) {
        this.currentConsumes = currentConsumes;
    }

    public String[] getCurrentProduces() {
        return this.currentProduces;
    }

    public void setCurrentProduces(String[] currentProduces) {
        this.currentProduces = currentProduces;
    }

    public String[] getDefaultConsumes() {
        return this.defaultConsumes;
    }

    public void setDefaultConsumes(String[] defaultConsumes) {
        this.defaultConsumes = defaultConsumes;
    }

    public String[] getDefaultProduces() {
        return this.defaultProduces;
    }

    public void setDefaultProduces(String[] defaultProduces) {
        this.defaultProduces = defaultProduces;
    }

    public Optional<AnnotationScanner> getCurrentScanner() {
        return this.currentScanner;
    }

    public void setCurrentScanner(AnnotationScanner currentScanner) {
        this.currentScanner = Optional.ofNullable(currentScanner);
    }

    public SchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    public JavaSecurityProcessor getJavaSecurityProcessor() {
        return this.javaSecurityProcessor;
    }

    public Annotations annotations() {
        return this.annotations;
    }

    public <V, A extends V, O extends V, AB, OB> IOContext<V, A, O, AB, OB> getIoContext() {
        return this.ioContext;
    }

    public <V, A extends V, O extends V, AB, OB> OpenAPIDefinitionIO<V, A, O, AB, OB> io() {
        return this.modelIO;
    }
}

