/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.openejb.client.ClientRuntimeException;

public class SSLContextBuilder {
    private Map<String, String> params;

    public SSLContextBuilder(Map<String, String> params) {
        this.params = params;
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        KeyManager[] keyManagers = this.initKeyManager();
        TrustManager[] trustManagers = this.initTrustManager();
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] initTrustManager() {
        String trustStore = this.params.get("sslTrustStore");
        if (trustStore == null) {
            return null;
        }
        try {
            String sslTrustStoreType = this.params.get("sslTrustStoreType");
            KeyStore ks = KeyStore.getInstance(null == sslTrustStoreType ? KeyStore.getDefaultType() : sslTrustStoreType);
            String trustStorePwd = this.params.get("sslTrustStorePassword");
            char[] pwd = trustStorePwd != null ? trustStorePwd.toCharArray() : "changeit".toCharArray();
            try (FileInputStream fis = new FileInputStream(trustStore);){
                ks.load(fis, pwd);
            }
            String sslTrustStoreProvider = this.params.get("sslTrustStoreProvider");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(null == sslTrustStoreProvider ? TrustManagerFactory.getDefaultAlgorithm() : sslTrustStoreProvider);
            tmf.init(ks);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            throw new ClientRuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] initKeyManager() {
        String keyStore = this.params.get("sslKeyStore");
        if (keyStore == null) {
            return null;
        }
        try {
            String sslKeyStoreType = this.params.get("sslKeyStoreType");
            KeyStore ks = KeyStore.getInstance(null == sslKeyStoreType ? KeyStore.getDefaultType() : sslKeyStoreType);
            String keyStorePassword = this.params.get("sslKeyStorePassword");
            char[] pwd = keyStorePassword != null ? keyStorePassword.toCharArray() : "changeit".toCharArray();
            try (FileInputStream fis = new FileInputStream(keyStore);){
                ks.load(fis, pwd);
            }
            String sslKeyStoreProvider = this.params.get("sslKeyStoreProvider");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(null == sslKeyStoreProvider ? KeyManagerFactory.getDefaultAlgorithm() : sslKeyStoreProvider);
            kmf.init(ks, pwd);
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new ClientRuntimeException(e.getMessage(), e);
        }
    }
}

