/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.CustomDestination;
import org.apache.activemq.command.SessionId;
import org.apache.openejb.resource.activemq.jms2.TomEEProducer;

public class TomEESession
extends ActiveMQSession {
    public TomEESession(ActiveMQConnection connection, SessionId sessionId, int acknowledgeMode, boolean asyncDispatch, boolean sessionAsyncDispatch) throws JMSException {
        super(connection, sessionId, acknowledgeMode, asyncDispatch, sessionAsyncDispatch);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        if (CustomDestination.class.isInstance(destination)) {
            return ((CustomDestination)CustomDestination.class.cast(destination)).createProducer((ActiveMQSession)this);
        }
        return new TomEEProducer(this, this.getNextProducerId(), ActiveMQMessageTransformation.transformDestination((Destination)destination), this.connection.getSendTimeout());
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createConsumer((Destination)topic);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return this.createConsumer((Destination)topic, messageSelector);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, false);
    }
}

