/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;

public class CleanEnvEntries
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        appModule = this.removeUnsetEnvEntries(appModule);
        appModule = this.fillInMissingType(appModule);
        return appModule;
    }

    public AppModule removeUnsetEnvEntries(AppModule appModule) throws OpenEJBException {
        ApplicationClient consumer;
        Map<String, EnvEntry> appEnvEntryMap = CleanEnvEntries.getAppEnvEntryMap(appModule);
        for (ClientModule clientModule : appModule.getClientModules()) {
            consumer = clientModule.getApplicationClient();
            if (consumer == null) continue;
            this.removeUnsetEnvEntries(appEnvEntryMap, (JndiConsumer)consumer);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            this.removeUnsetEnvEntries(appEnvEntryMap, (JndiConsumer)consumer);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            if (ejbJar == null) continue;
            for (EnterpriseBean consumer2 : ejbJar.getEnterpriseBeans()) {
                if (CompManagedBean.class.isInstance(consumer2)) continue;
                this.removeUnsetEnvEntries(appEnvEntryMap, (JndiConsumer)consumer2);
            }
        }
        return appModule;
    }

    private static Map<String, EnvEntry> getAppEnvEntryMap(AppModule appModule) {
        if (appModule.getApplication() != null && appModule.getApplication().getEnvEntry() != null) {
            return appModule.getApplication().getEnvEntryMap();
        }
        return Collections.emptyMap();
    }

    private void removeUnsetEnvEntries(Map<String, EnvEntry> appEntries, JndiConsumer consumer) {
        Iterator entries = consumer.getEnvEntry().iterator();
        while (entries.hasNext()) {
            EnvEntry entry = (EnvEntry)entries.next();
            if (entry.getEnvEntryValue() != null || entry.getLookupName() != null) continue;
            EnvEntry appEntry = appEntries.get(entry.getName());
            if (appEntry != null && appEntry.getEnvEntryValue() != null) {
                entry.setEnvEntryValue(appEntry.getEnvEntryValue());
                continue;
            }
            entries.remove();
        }
    }

    public AppModule fillInMissingType(AppModule appModule) throws OpenEJBException {
        ApplicationClient consumer;
        for (ClientModule clientModule : appModule.getClientModules()) {
            consumer = clientModule.getApplicationClient();
            if (consumer == null) continue;
            this.fillInMissingType((JndiConsumer)consumer, clientModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            this.fillInMissingType((JndiConsumer)consumer, webModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            if (ejbJar == null) continue;
            for (EnterpriseBean consumer2 : ejbJar.getEnterpriseBeans()) {
                this.fillInMissingType((JndiConsumer)consumer2, ejbModule);
            }
        }
        return appModule;
    }

    private void fillInMissingType(JndiConsumer consumer, DeploymentModule module) {
        ClassLoader loader = module.getClassLoader();
        for (EnvEntry entry : consumer.getEnvEntry()) {
            this.fillInMissingType(loader, entry);
        }
    }

    private void fillInMissingType(ClassLoader loader, EnvEntry entry) {
        if (entry.getType() != null) {
            return;
        }
        if (entry.getLookupName() != null) {
            return;
        }
        if (entry.getInjectionTarget().size() == 0) {
            return;
        }
        HashSet<Class> types = new HashSet<Class>();
        for (InjectionTarget target : entry.getInjectionTarget()) {
            if (target.getInjectionTargetClass() == null || target.getInjectionTargetName() == null) continue;
            types.add(this.getType(loader, target));
        }
        this.normalize(types);
        Class type = types.size() == 1 ? (Class)types.iterator().next() : String.class;
        entry.setType(type.getName());
    }

    private void normalize(Set<Class> types) {
        types.remove(Object.class);
        if (types.contains(Integer.TYPE)) {
            types.remove(Integer.TYPE);
            types.add(Integer.class);
        }
        if (types.contains(Character.TYPE)) {
            types.remove(Character.TYPE);
            types.add(Character.class);
        }
        if (types.contains(Short.TYPE)) {
            types.remove(Short.TYPE);
            types.add(Short.class);
        }
        if (types.contains(Long.TYPE)) {
            types.remove(Long.TYPE);
            types.add(Long.class);
        }
        if (types.contains(Float.TYPE)) {
            types.remove(Float.TYPE);
            types.add(Float.class);
        }
        if (types.contains(Double.TYPE)) {
            types.remove(Double.TYPE);
            types.add(Double.class);
        }
        if (types.contains(Boolean.TYPE)) {
            types.remove(Boolean.TYPE);
            types.add(Boolean.class);
        }
        if (types.contains(Byte.TYPE)) {
            types.remove(Byte.TYPE);
            types.add(Byte.class);
        }
    }

    private Class<?> getType(ClassLoader loader, InjectionTarget target) {
        try {
            Class<?> clazz = loader.loadClass(target.getInjectionTargetClass());
            try {
                Field field = clazz.getDeclaredField(target.getInjectionTargetName());
                return field.getType();
            }
            catch (NoSuchFieldException field) {
                String bestName = "set" + StringUtils.capitalize((String)target.getInjectionTargetName());
                String name = "set" + target.getInjectionTargetName().toLowerCase(Locale.ENGLISH);
                Class<?> found = null;
                for (Method method : clazz.getDeclaredMethods()) {
                    if (method.getParameterTypes().length != 1) continue;
                    if (method.getName().equals(bestName)) {
                        return method.getParameterTypes()[0];
                    }
                    if (!method.getName().toLowerCase(Locale.ENGLISH).equals(name)) continue;
                    found = method.getParameterTypes()[0];
                }
                if (found != null) {
                    return found;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Object.class;
    }
}

