/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.internet;

import jakarta.mail.internet.ParseException;

public class HeaderTokenizer {
    private static final char NUL = '\u0000';
    private static final Token EOF = new Token(-4, null);
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    private static final String WHITE = " \t\n\r";
    private final String _delimiters;
    private final String _header;
    private final int _headerLength;
    private final boolean _skip;
    private int pos;

    public HeaderTokenizer(String header) {
        this(header, RFC822);
    }

    public HeaderTokenizer(String header, String delimiters) {
        this(header, delimiters, true);
    }

    public HeaderTokenizer(String header, String delimiters, boolean skipComments) {
        this._skip = skipComments;
        this._header = header;
        this._delimiters = delimiters;
        this._headerLength = header.length();
    }

    public String getRemainder() {
        if (this.pos > this._headerLength) {
            return null;
        }
        return this._header.substring(this.pos);
    }

    public Token next() throws ParseException {
        return this.readToken('\u0000', false);
    }

    public Token next(char endOfAtom) throws ParseException {
        return this.next(endOfAtom, false);
    }

    public Token next(char endOfAtom, boolean keepEscapes) throws ParseException {
        return this.readToken(endOfAtom, keepEscapes);
    }

    public Token peek() throws ParseException {
        int start = this.pos;
        try {
            Token token = this.readToken('\u0000', false);
            return token;
        }
        finally {
            this.pos = start;
        }
    }

    private Token readAtomicToken() {
        int start = this.pos;
        StringBuilder sb = new StringBuilder();
        sb.append(this._header.charAt(this.pos));
        while (++this.pos < this._headerLength) {
            char ch = this._header.charAt(this.pos);
            if (this._delimiters.indexOf(this._header.charAt(this.pos)) == -1 && ch >= ' ' && ch < '\u007f') continue;
            break;
        }
        return new Token(-1, this._header.substring(start, this.pos));
    }

    private Token readToken(char endOfAtom, boolean keepEscapes) throws ParseException {
        if (this.pos >= this._headerLength) {
            return EOF;
        }
        char c = this._header.charAt(this.pos);
        if (c == '(') {
            Token comment = this.readComment(keepEscapes);
            if (this._skip) {
                return this.readToken(endOfAtom, keepEscapes);
            }
            return comment;
        }
        if (c == '\"') {
            return this.readQuotedString('\"', keepEscapes, 1);
        }
        if (WHITE.indexOf(c) != -1) {
            this.eatWhiteSpace();
            return this.readToken(endOfAtom, keepEscapes);
        }
        if (c < ' ' || c >= '\u007f' || this._delimiters.indexOf(c) != -1) {
            if (endOfAtom != '\u0000' && c != endOfAtom) {
                return this.readQuotedString(endOfAtom, keepEscapes, 0);
            }
            ++this.pos;
            return new Token(c, String.valueOf(c));
        }
        if (endOfAtom != '\u0000' && c != endOfAtom) {
            return this.readQuotedString(endOfAtom, keepEscapes, 0);
        }
        return this.readAtomicToken();
    }

    private String getEscapedValue(int start, int end, boolean keepEscapes) throws ParseException {
        StringBuffer value = new StringBuffer();
        for (int i = start; i < end; ++i) {
            char ch = this._header.charAt(i);
            if (ch == '\\') {
                if (++i == end) {
                    throw new ParseException("Invalid escape character");
                }
                if (keepEscapes) {
                    value.append("\\");
                }
                value.append(this._header.charAt(i));
                continue;
            }
            if (ch == '\r') {
                if (i >= end - 1 || this._header.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            value.append(ch);
        }
        return value.toString();
    }

    private Token readComment(boolean keepEscapes) throws ParseException {
        int start = this.pos + 1;
        int nesting = 1;
        boolean requiresEscaping = false;
        while (++this.pos < this._headerLength) {
            char ch = this._header.charAt(this.pos);
            if (ch == ')') {
                if (--nesting != 0) continue;
                break;
            }
            if (ch == '(') {
                ++nesting;
                continue;
            }
            if (ch == '\\') {
                ++this.pos;
                requiresEscaping = true;
                continue;
            }
            if (ch != '\r') continue;
            requiresEscaping = true;
        }
        if (nesting != 0) {
            throw new ParseException("Unbalanced comments");
        }
        String value = requiresEscaping ? this.getEscapedValue(start, this.pos, keepEscapes) : this._header.substring(start, this.pos++);
        return new Token(-3, value);
    }

    private Token readQuotedString(char endChar, boolean keepEscapes, int offset) throws ParseException {
        int start = this.pos + offset;
        boolean requiresEscaping = false;
        while (++this.pos < this._headerLength) {
            char ch = this._header.charAt(this.pos);
            if (ch == endChar) {
                String value = requiresEscaping ? this.getEscapedValue(start, this.pos++, keepEscapes) : this._header.substring(start, this.pos++);
                return new Token(-2, value);
            }
            if (ch == '\\') {
                ++this.pos;
                requiresEscaping = true;
                continue;
            }
            if (ch != '\r') continue;
            requiresEscaping = true;
        }
        if (endChar == '\"') {
            throw new ParseException("Missing '\"'");
        }
        String value = requiresEscaping ? this.getEscapedValue(start, this.pos, keepEscapes) : this._header.substring(start, this.pos);
        return new Token(-2, HeaderTokenizer.trimWhiteSpace(value));
    }

    private void eatWhiteSpace() {
        while (++this.pos < this._headerLength && WHITE.indexOf(this._header.charAt(this.pos)) != -1) {
        }
    }

    private static String trimWhiteSpace(String s) {
        char c;
        int i;
        for (i = s.length() - 1; i >= 0 && ((c = s.charAt(i)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --i) {
        }
        if (i <= 0) {
            return "";
        }
        return s.substring(0, i + 1);
    }

    public static class Token {
        public static final int ATOM = -1;
        public static final int COMMENT = -3;
        public static final int EOF = -4;
        public static final int QUOTEDSTRING = -2;
        private final int _type;
        private final String _value;

        public Token(int type, String value) {
            this._type = type;
            this._value = value;
        }

        public int getType() {
            return this._type;
        }

        public String getValue() {
            return this._value;
        }
    }
}

