/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.util.PBKDF2Config;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;
import org.cryptacular.generator.AbstractP12Generator;
import org.cryptacular.pbe.PBES2Algorithm;
import org.cryptacular.pbe.PBES2EncryptionScheme;
import org.cryptacular.spec.DigestSpec;

public class AESP12Generator
extends AbstractP12Generator {
    public static final Set<ASN1ObjectIdentifier> SUPPORTED_DIGEST_ALGORITHMS = Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(NISTObjectIdentifiers.id_sha256, NISTObjectIdentifiers.id_sha512, NISTObjectIdentifiers.id_sha3_256, NISTObjectIdentifiers.id_sha3_384, NISTObjectIdentifiers.id_sha3_512)));
    private static final Map<ASN1ObjectIdentifier, DigestSpec> DIGEST_ID_TO_DIGEST_SPEC_MAP = new HashMap<ASN1ObjectIdentifier, DigestSpec>();
    private static final Map<ASN1ObjectIdentifier, ASN1ObjectIdentifier> DIGEST_ID_TO_HMAC_ID_MAP = new HashMap<ASN1ObjectIdentifier, ASN1ObjectIdentifier>();
    private final ASN1ObjectIdentifier digestAlgorithm;
    private final PBKDF2Config pbkdf2Config;
    private final PBES2OutputEncryptorBuilder outputEncryptorBuilder;

    public AESP12Generator() {
        this(NISTObjectIdentifiers.id_sha256, 2048);
    }

    public AESP12Generator(int iterations) {
        this(NISTObjectIdentifiers.id_sha256, iterations);
    }

    public AESP12Generator(ASN1ObjectIdentifier digestAlgId, int iterations) {
        if (!SUPPORTED_DIGEST_ALGORITHMS.contains(digestAlgId)) {
            throw new IllegalArgumentException("Unsupported digest algorithm");
        }
        this.digestAlgorithm = digestAlgId;
        ASN1ObjectIdentifier hmacAlgId = DIGEST_ID_TO_HMAC_ID_MAP.get(digestAlgId);
        this.pbkdf2Config = new PBKDF2Config.Builder().withIterationCount(iterations).withPRF(new AlgorithmIdentifier(hmacAlgId, (ASN1Encodable)DERNull.INSTANCE)).build();
        this.outputEncryptorBuilder = new PBES2OutputEncryptorBuilder(PBES2Algorithm.AES256, this.pbkdf2Config);
    }

    @Override
    public int getIterations() {
        return this.pbkdf2Config.getIterationCount();
    }

    @Override
    protected ASN1ObjectIdentifier getDigestAlgorithmId() {
        return this.digestAlgorithm;
    }

    @Override
    protected DigestSpec getDigestSpec() {
        return DIGEST_ID_TO_DIGEST_SPEC_MAP.get(this.digestAlgorithm);
    }

    @Override
    protected OutputEncryptor keyOutputEncryptor(char[] password) {
        return this.outputEncryptorBuilder.build(password);
    }

    @Override
    protected OutputEncryptor dataOutputEncryptor(char[] password) {
        return this.outputEncryptorBuilder.build(password);
    }

    static {
        DIGEST_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_sha256, new DigestSpec("SHA256"));
        DIGEST_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_sha512, new DigestSpec("SHA512"));
        DIGEST_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_sha3_256, new DigestSpec("SHA3", 256));
        DIGEST_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_sha3_384, new DigestSpec("SHA3", 384));
        DIGEST_ID_TO_DIGEST_SPEC_MAP.put(NISTObjectIdentifiers.id_sha3_512, new DigestSpec("SHA3", 512));
        DIGEST_ID_TO_HMAC_ID_MAP.put(NISTObjectIdentifiers.id_sha256, PKCSObjectIdentifiers.id_hmacWithSHA256);
        DIGEST_ID_TO_HMAC_ID_MAP.put(NISTObjectIdentifiers.id_sha512, PKCSObjectIdentifiers.id_hmacWithSHA512);
        DIGEST_ID_TO_HMAC_ID_MAP.put(NISTObjectIdentifiers.id_sha3_256, NISTObjectIdentifiers.id_hmacWithSHA3_256);
        DIGEST_ID_TO_HMAC_ID_MAP.put(NISTObjectIdentifiers.id_sha3_384, NISTObjectIdentifiers.id_hmacWithSHA3_384);
        DIGEST_ID_TO_HMAC_ID_MAP.put(NISTObjectIdentifiers.id_sha3_512, NISTObjectIdentifiers.id_hmacWithSHA3_512);
    }

    static class PBES2OutputEncryptorBuilder {
        private final SecureRandom random = new SecureRandom();
        private final PBES2Algorithm encryptionAlg;
        private final PBKDF2Config pbkdf2Config;

        PBES2OutputEncryptorBuilder(PBES2Algorithm encAlg, PBKDF2Config config) {
            this.encryptionAlg = encAlg;
            this.pbkdf2Config = config;
        }

        OutputEncryptor build(char[] password) {
            byte[] salt = new byte[this.pbkdf2Config.getSaltLength()];
            this.random.nextBytes(salt);
            byte[] iv = new byte[this.encryptionAlg.getBlockSize() / 8];
            this.random.nextBytes(iv);
            ASN1ObjectIdentifier encryptionAlgId = new ASN1ObjectIdentifier(this.encryptionAlg.getOid());
            EncryptionScheme encryptionScheme = new EncryptionScheme(encryptionAlgId, (ASN1Encodable)new DEROctetString(iv));
            PBKDF2Params pbkdf2Params = new PBKDF2Params(salt, this.pbkdf2Config.getIterationCount(), this.pbkdf2Config.getPRF());
            final PBES2Parameters pbes2Parameters = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)pbkdf2Params), encryptionScheme);
            final PBES2EncryptionScheme scheme = new PBES2EncryptionScheme(pbes2Parameters, password);
            return new OutputEncryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)pbes2Parameters);
                }

                public OutputStream getOutputStream(OutputStream out) {
                    return scheme.wrap(true, out);
                }

                public GenericKey getKey() {
                    return null;
                }
            };
        }
    }
}

