/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class ErrorStack {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ErrorStack.class);
    private Stack<Throwable> errorStack = new Stack();

    public void pushError(Throwable e) {
        this.errorStack.addElement(e);
    }

    public void logErrors() {
        if (!this.errorStack.isEmpty()) {
            for (Throwable t : this.errorStack) {
                String message = t.getMessage();
                if (message != null && message.length() > 0) {
                    logger.log(Level.SEVERE, t.getMessage(), t);
                    continue;
                }
                logger.log(Level.SEVERE, "unknown error", t);
            }
        }
    }

    public void clear() {
        this.errorStack.clear();
    }

    public boolean hasErrors() {
        return !this.errorStack.isEmpty();
    }

    public Iterator<? extends Throwable> iterator() {
        return this.errorStack.iterator();
    }
}

