/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Specializes;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.NamedLiteral;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AbstractAnnotated;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class BeanAttributesBuilder<T, A extends Annotated> {
    protected A annotated;
    protected WebBeansContext webBeansContext;
    protected Set<Type> types = new HashSet<Type>();
    protected Set<Annotation> qualifiers = new HashSet<Annotation>();
    protected Class<? extends Annotation> scope;
    protected String name;
    protected Set<Class<? extends Annotation>> stereotypes;
    protected Boolean alternative;

    public static BeanAttributesBuilderFactory forContext(WebBeansContext webBeansContext) {
        return new BeanAttributesBuilderFactory(webBeansContext);
    }

    protected BeanAttributesBuilder(WebBeansContext webBeansContext, A annotated) {
        this.annotated = annotated;
        this.webBeansContext = webBeansContext;
    }

    public BeanAttributesBuilder<T, A> alternative(boolean alternative) {
        this.alternative = alternative;
        return this;
    }

    public BeanAttributesImpl<T> build() {
        this.stereotypes = this.defineStereotypes((Annotated)this.annotated);
        this.defineScope();
        if (this.scope == null) {
            return null;
        }
        this.defineTypes();
        this.defineName();
        this.defineQualifiers();
        this.defineAlternative();
        return new BeanAttributesImpl(this.types, this.qualifiers, this.scope, this.name, this.stereotypes, this.alternative);
    }

    protected A getAnnotated() {
        return this.annotated;
    }

    protected void defineTypes() {
        Class<?> baseType = ClassUtil.getClass(this.annotated.getBaseType());
        if (baseType.isArray()) {
            this.types.add((Type)((Object)Object.class));
            this.types.add(baseType);
        } else {
            Typed beanTypes = (Typed)this.annotated.getAnnotation(Typed.class);
            if (beanTypes != null) {
                Class[] typedTypes = beanTypes.value();
                HashSet<Type> newTypes = new HashSet<Type>();
                for (Class type : typedTypes) {
                    Type foundType = null;
                    for (Type apiType : this.annotated.getTypeClosure()) {
                        if (ClassUtil.getClazz(apiType) != type) continue;
                        foundType = apiType;
                        break;
                    }
                    if (foundType == null) {
                        throw new WebBeansConfigurationException("@Type values must be in bean api types of class: " + baseType);
                    }
                    newTypes.add(foundType);
                }
                this.types.addAll(newTypes);
                this.types.add((Type)((Object)Object.class));
            } else {
                this.types.addAll(this.annotated.getTypeClosure());
            }
            Set<String> ignored = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
            if (!ignored.isEmpty()) {
                this.types.removeIf(t -> t instanceof Class && ignored.contains(((Class)t).getName()));
            }
        }
    }

    protected void defineQualifiers() {
        HashSet<Class<? extends Annotation>> qualifiedTypes = new HashSet<Class<? extends Annotation>>();
        if (this.annotated.isAnnotationPresent(Specializes.class)) {
            this.defineQualifiers(this.getSuperAnnotated(), qualifiedTypes);
        }
        this.defineQualifiers((Annotated)this.annotated, (Set<Class<? extends Annotation>>)qualifiedTypes);
    }

    private void defineQualifiers(Annotated annotated, Set<Class<? extends Annotation>> qualifiedTypes) {
        Annotation[] annotations = AnnotationUtil.asArray(annotated.getAnnotations());
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!annotationManager.isQualifierAnnotation(type)) continue;
            annotationManager.checkQualifierConditions(annotation);
            if (qualifiedTypes.contains(annotation.annotationType()) && !this.isRepetable(annotated, annotation)) continue;
            qualifiedTypes.add(annotation.annotationType());
            if (annotation.annotationType().equals(Named.class) && this.name != null) {
                this.qualifiers.add((Annotation)((Object)new NamedLiteral(this.name)));
                continue;
            }
            this.qualifiers.add(annotation);
        }
        if (this.qualifiers.isEmpty()) {
            this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
        } else if (this.qualifiers.size() == 1) {
            Annotation annot = this.qualifiers.iterator().next();
            if (annot.annotationType().equals(Named.class) || annot.annotationType().equals(Any.class)) {
                this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
            }
        } else if (this.qualifiers.size() == 2) {
            Iterator<Annotation> qualiIt = this.qualifiers.iterator();
            Class<? extends Annotation> q1 = qualiIt.next().annotationType();
            Class<? extends Annotation> q2 = qualiIt.next().annotationType();
            if (q1.equals(Named.class) && q2.equals(Any.class) || q2.equals(Named.class) && q1.equals(Any.class)) {
                this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
            }
        }
        if (!this.hasAnyQualifier()) {
            this.qualifiers.add((Annotation)((Object)AnyLiteral.INSTANCE));
        }
    }

    private boolean isRepetable(Annotated annotated, Annotation annotation) {
        return AbstractAnnotated.class.isInstance(annotated) ? ((AbstractAnnotated)AbstractAnnotated.class.cast(annotated)).getRepeatables().contains(annotation.annotationType()) : this.webBeansContext.getAnnotationManager().getRepeatableMethod(annotation.annotationType()).isPresent();
    }

    private boolean hasAnyQualifier() {
        return AnnotationUtil.getAnnotation(this.qualifiers, Any.class) != null;
    }

    protected abstract void defineScope();

    protected void defineScope(String errorMessage) {
        this.defineScope(null, false, errorMessage);
    }

    protected void defineScope(Class<?> declaringClass, boolean onlyScopedBeans, String errorMessage) {
        Annotation[] annotations = AnnotationUtil.asArray(this.annotated.getAnnotations());
        boolean found = false;
        List<ExternalScope> additionalScopes = this.webBeansContext.getBeanManagerImpl().getAdditionalScopes();
        for (Annotation annotation : annotations) {
            if (declaringClass != null && AnnotationUtil.getDeclaringClass(annotation, declaringClass) != null && !AnnotationUtil.isDeclaringClass(declaringClass, annotation)) continue;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.webBeansContext.getBeanManagerImpl().isScope(annotationType)) continue;
            Object var = annotationType.getAnnotation(NormalScope.class);
            Object pseudo = annotationType.getAnnotation(Scope.class);
            if (var == null && pseudo == null) {
                for (ExternalScope additionalScope : additionalScopes) {
                    if (!annotationType.equals(additionalScope.getScope())) continue;
                    Annotation scopeAnnotation = additionalScope.getScopeAnnotation();
                    if (additionalScope.isNormal()) {
                        var = scopeAnnotation;
                        continue;
                    }
                    pseudo = scopeAnnotation;
                }
            }
            if (var != null) {
                if (pseudo != null) {
                    throw new WebBeansConfigurationException("Not to define both @Scope and @NormalScope on bean : " + ClassUtil.getClass(this.annotated.getBaseType()).getName());
                }
                if (found) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                found = true;
                this.scope = annotation.annotationType();
                continue;
            }
            if (pseudo == null) continue;
            if (found) {
                throw new WebBeansConfigurationException(errorMessage);
            }
            found = true;
            this.scope = annotation.annotationType();
        }
        if (found && this.annotated.getAnnotation(Interceptor.class) != null && this.scope != Dependent.class) {
            throw new WebBeansConfigurationException("An Interceptor must declare any other Scope than @Dependent: " + ClassUtil.getClass(this.annotated.getBaseType()).getName());
        }
        if (found && this.annotated.getAnnotation(Decorator.class) != null && this.scope != Dependent.class) {
            throw new WebBeansConfigurationException("A Decorator must declare any other Scope than @Dependent: " + ClassUtil.getClass(this.annotated.getBaseType()).getName());
        }
        if (!found && declaringClass != null && !this.hasDeclaredNonInheritedScope(declaringClass)) {
            this.defineScope(declaringClass.getSuperclass(), onlyScopedBeans, errorMessage);
        } else if (!found) {
            this.defineDefaultScope(errorMessage, onlyScopedBeans);
        }
    }

    private void defineDefaultScope(String exceptionMessage, boolean onlyScopedBeans) {
        if (this.scope == null) {
            Constructor defaultCt;
            Set<Class<? extends Annotation>> stereos = this.stereotypes;
            if (stereos != null && stereos.size() > 0) {
                Annotation defined = null;
                Set<Class<? extends Annotation>> anns = this.stereotypes;
                for (Class<? extends Annotation> stero : anns) {
                    boolean containsNormal = AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class);
                    if (!AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class) && !AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), Scope.class)) continue;
                    Annotation next = containsNormal ? AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), NormalScope.class)[0] : AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), Scope.class)[0];
                    if (defined == null) {
                        defined = next;
                        continue;
                    }
                    if (defined.equals(next)) continue;
                    throw new WebBeansConfigurationException(exceptionMessage);
                }
                this.scope = defined != null ? defined.annotationType() : Dependent.class;
            }
            if (this.scope == null && this.annotated instanceof AnnotatedType && (defaultCt = this.webBeansContext.getWebBeansUtil().getNoArgConstructor(((AnnotatedType)this.annotated).getJavaClass())) != null && Modifier.isPrivate(defaultCt.getModifiers())) {
                return;
            }
            if (!(this.scope != null || onlyScopedBeans && this.annotated.getAnnotation(Interceptor.class) == null && this.annotated.getAnnotation(Decorator.class) == null)) {
                this.scope = Dependent.class;
            }
        }
    }

    private boolean hasDeclaredNonInheritedScope(Class<?> type) {
        return this.webBeansContext.getAnnotationManager().getDeclaredScopeAnnotation(type) != null;
    }

    protected abstract void defineName();

    protected void defineName(Annotated annotated, Supplier<String> name) {
        Named nameAnnot = (Named)annotated.getAnnotation(Named.class);
        boolean isDefault = false;
        if (nameAnnot == null) {
            if (this.webBeansContext.getAnnotationManager().hasNamedOnStereoTypes(this.stereotypes)) {
                isDefault = true;
            }
        } else if (nameAnnot.value().length() == 0) {
            isDefault = true;
        } else {
            this.name = nameAnnot.value();
        }
        if (isDefault) {
            this.name = name.get();
        }
    }

    protected abstract Annotated getSuperAnnotated();

    protected Set<Class<? extends Annotation>> defineStereotypes(Annotated annot) {
        HashSet<Class<? extends Annotation>> stereos = null;
        Annotation[] anns = AnnotationUtil.asArray(annot.getAnnotations());
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.hasStereoTypeMetaAnnotation(anns)) {
            Annotation[] steroAnns;
            for (Annotation stereo : steroAnns = annotationManager.getStereotypeMetaAnnotations(anns)) {
                if (stereos == null) {
                    stereos = new HashSet<Class<? extends Annotation>>();
                }
                stereos.add(stereo.annotationType());
            }
        }
        return stereos != null ? stereos : Collections.EMPTY_SET;
    }

    protected void defineAlternative() {
        if (this.alternative == null) {
            this.alternative = WebBeansUtil.isAlternative(this.annotated, this.stereotypes);
        }
    }

    protected String getManagedBeanDefaultName(AnnotatedType<?> annotatedType) {
        String clazzName = annotatedType.getJavaClass().getSimpleName();
        Asserts.assertNotNull(annotatedType);
        if (clazzName.length() > 0) {
            StringBuilder name = new StringBuilder(clazzName);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return name.toString();
        }
        return clazzName;
    }

    protected String getProducerDefaultName(AnnotatedMember<?> annotatedMember) {
        String memberName = annotatedMember.getJavaMember().getName();
        StringBuilder buffer = new StringBuilder(memberName);
        if (buffer.length() > 3 && (buffer.substring(0, 3).equals("get") || buffer.substring(0, 3).equals("set"))) {
            if (Character.isUpperCase(buffer.charAt(3))) {
                buffer.setCharAt(3, Character.toLowerCase(buffer.charAt(3)));
            }
            return buffer.substring(3);
        }
        if (buffer.length() > 2 && buffer.substring(0, 2).equals("is")) {
            if (Character.isUpperCase(buffer.charAt(2))) {
                buffer.setCharAt(2, Character.toLowerCase(buffer.charAt(2)));
            }
            return buffer.substring(2);
        }
        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
        return buffer.toString();
    }

    private static abstract class AnnotatedMemberBeanAttributesBuilder<M, A extends AnnotatedMember<M>>
    extends BeanAttributesBuilder<M, A> {
        protected AnnotatedMemberBeanAttributesBuilder(WebBeansContext webBeansContext, A annotated) {
            super(webBeansContext, annotated);
        }

        protected AnnotatedType<? super M> getSuperType() {
            Class superclass = ((AnnotatedMember)this.getAnnotated()).getDeclaringType().getJavaClass().getSuperclass();
            if (superclass == null) {
                return null;
            }
            return this.webBeansContext.getAnnotatedElementFactory().getAnnotatedType(superclass);
        }
    }

    private static class AnnotatedMethodBeanAttributesBuilder<M>
    extends AnnotatedMemberBeanAttributesBuilder<M, AnnotatedMethod<M>> {
        protected AnnotatedMethodBeanAttributesBuilder(WebBeansContext webBeansContext, AnnotatedMethod<M> annotated) {
            super(webBeansContext, annotated);
        }

        @Override
        protected void defineScope() {
            this.defineScope("Annotated producer method : " + ((AnnotatedMethod)this.getAnnotated()).getJavaMember() + "must declare default @Scope annotation");
        }

        @Override
        protected void defineName() {
            if (((AnnotatedMethod)this.getAnnotated()).isAnnotationPresent(Specializes.class)) {
                AnnotatedMethod<M> superAnnotated = this.getSuperAnnotated();
                this.defineName((Annotated)superAnnotated, () -> this.getProducerDefaultName((AnnotatedMember<?>)superAnnotated));
            }
            if (this.name == null) {
                this.defineName((Annotated)this.getAnnotated(), () -> this.getProducerDefaultName((AnnotatedMember)this.getAnnotated()));
            } else if (((AnnotatedMethod)this.getAnnotated()).isAnnotationPresent(Named.class)) {
                throw new WebBeansConfigurationException("@Specialized Producer method : " + ((AnnotatedMethod)this.getAnnotated()).getJavaMember().getName() + " may not explicitly declare a bean name");
            }
        }

        protected AnnotatedMethod<? super M> getSuperAnnotated() {
            AnnotatedMethod thisMethod = (AnnotatedMethod)this.getAnnotated();
            for (AnnotatedMethod superMethod : this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.getSuperType())) {
                List thisParameters = thisMethod.getParameters();
                if (!thisMethod.getJavaMember().getName().equals(superMethod.getJavaMember().getName()) || !thisMethod.getBaseType().equals(superMethod.getBaseType()) || thisParameters.size() != superMethod.getParameters().size()) continue;
                List superParameters = superMethod.getParameters();
                boolean match = true;
                for (int i = 0; i < thisParameters.size(); ++i) {
                    if (((AnnotatedParameter)thisParameters.get(i)).getBaseType().equals(((AnnotatedParameter)superParameters.get(i)).getBaseType())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return superMethod;
            }
            return null;
        }
    }

    private static class AnnotatedFieldBeanAttributesBuilder<M>
    extends AnnotatedMemberBeanAttributesBuilder<M, AnnotatedField<M>> {
        protected AnnotatedFieldBeanAttributesBuilder(WebBeansContext webBeansContext, AnnotatedField<M> annotated) {
            super(webBeansContext, annotated);
        }

        @Override
        protected void defineScope() {
            this.defineScope("Annotated producer field: " + ((AnnotatedField)this.getAnnotated()).getJavaMember() + "must declare default @Scope annotation");
        }

        @Override
        protected void defineName() {
            this.defineName((Annotated)this.getAnnotated(), () -> this.getProducerDefaultName((AnnotatedMember)this.getAnnotated()));
        }

        protected AnnotatedField<? super M> getSuperAnnotated() {
            AnnotatedField thisField = (AnnotatedField)this.getAnnotated();
            for (AnnotatedField superField : this.getSuperType().getFields()) {
                if (!thisField.getJavaMember().getName().equals(superField.getJavaMember().getName()) || !thisField.getBaseType().equals(superField.getBaseType())) continue;
                return superField;
            }
            return null;
        }
    }

    private static class AnnotatedTypeBeanAttributesBuilder<C>
    extends BeanAttributesBuilder<C, AnnotatedType<C>> {
        private final boolean onlyScopedBeans;

        public AnnotatedTypeBeanAttributesBuilder(WebBeansContext webBeansContext, AnnotatedType<C> annotated, boolean onlyScopedBeans) {
            super(webBeansContext, annotated);
            this.onlyScopedBeans = onlyScopedBeans;
        }

        @Override
        protected void defineScope() {
            this.defineScope(((AnnotatedType)this.getAnnotated()).getJavaClass(), this.onlyScopedBeans, WebBeansLoggerFacade.getTokenString("TEXT_MB_IMPL") + ((AnnotatedType)this.getAnnotated()).getJavaClass().getName() + WebBeansLoggerFacade.getTokenString("TEXT_SAME_SCOPE"));
        }

        @Override
        protected void defineName() {
            if (((AnnotatedType)this.getAnnotated()).isAnnotationPresent(Specializes.class)) {
                Class superclass;
                AnnotatedType annotatedToSpecialize = (AnnotatedType)this.getAnnotated();
                do {
                    if (!(superclass = annotatedToSpecialize.getJavaClass().getSuperclass()).equals(Object.class)) continue;
                    throw new WebBeansConfigurationException("@Specialized Class : " + ((AnnotatedType)this.getAnnotated()).getJavaClass().getName() + " must not directly extend Object.class");
                } while ((annotatedToSpecialize = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(superclass)).getAnnotation(Specializes.class) != null);
                AnnotatedType finalAnnotatedToSpecialize = annotatedToSpecialize;
                this.defineName((Annotated)annotatedToSpecialize, () -> this.getManagedBeanDefaultName(finalAnnotatedToSpecialize));
            }
            if (this.name == null) {
                this.defineName((Annotated)this.getAnnotated(), () -> this.getManagedBeanDefaultName((AnnotatedType)this.getAnnotated()));
            } else if (((AnnotatedType)this.getAnnotated()).getJavaClass().isAnnotationPresent(Named.class)) {
                throw new WebBeansConfigurationException("@Specialized Class : " + ((AnnotatedType)this.getAnnotated()).getJavaClass().getName() + " may not explicitly declare a bean name");
            }
        }

        protected AnnotatedType<? super C> getSuperAnnotated() {
            Class superclass;
            AnnotatedType annotatedType = (AnnotatedType)this.getAnnotated();
            do {
                if ((superclass = annotatedType.getJavaClass().getSuperclass()) != null && !superclass.equals(Object.class)) continue;
                return null;
            } while ((annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(superclass)).getAnnotation(Specializes.class) != null);
            return annotatedType;
        }
    }

    public static class BeanAttributesBuilderFactory {
        private WebBeansContext webBeansContext;

        private BeanAttributesBuilderFactory(WebBeansContext webBeansContext) {
            Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
            this.webBeansContext = webBeansContext;
        }

        public <T> BeanAttributesBuilder<T, AnnotatedType<T>> newBeanAttibutes(AnnotatedType<T> annotatedType) {
            return this.newBeanAttibutes(annotatedType, false);
        }

        public <T> BeanAttributesBuilder<T, AnnotatedType<T>> newBeanAttibutes(AnnotatedType<T> annotatedType, boolean onlyScopedBeans) {
            return new AnnotatedTypeBeanAttributesBuilder<T>(this.webBeansContext, annotatedType, onlyScopedBeans);
        }

        public <T> BeanAttributesBuilder<T, AnnotatedField<T>> newBeanAttibutes(AnnotatedField<T> annotatedField) {
            return new AnnotatedFieldBeanAttributesBuilder<T>(this.webBeansContext, annotatedField);
        }

        public <T> BeanAttributesBuilder<T, AnnotatedMethod<T>> newBeanAttibutes(AnnotatedMethod<T> annotatedMethod) {
            return new AnnotatedMethodBeanAttributesBuilder<T>(this.webBeansContext, annotatedMethod);
        }
    }
}

