/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.pool2.PooledObject;

class AbstractConnectionFactory {
    protected final ConnectionPoolDataSource cpds;
    protected Duration maxConnDuration = Duration.ofMillis(-1L);
    protected final boolean rollbackAfterValidation;
    protected final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();
    protected final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final String validationQuery;
    protected final Duration validationQueryTimeoutDuration;

    AbstractConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, Duration validationQueryTimeoutDuration, boolean rollbackAfterValidation) {
        this.cpds = cpds;
        this.validationQuery = validationQuery;
        this.validationQueryTimeoutDuration = validationQueryTimeoutDuration;
        this.rollbackAfterValidation = rollbackAfterValidation;
    }

    void setMaxConn(Duration duration) {
        this.maxConnDuration = duration;
    }

    private int toSeconds(Duration duration) {
        if (duration.isNegative() || duration.isZero()) {
            return 0;
        }
        long seconds = this.validationQueryTimeoutDuration.getSeconds();
        return seconds != 0L ? Math.toIntExact(seconds) : 1;
    }

    protected void validateLifetime(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        Utils.validateLifetime(pooledObject, this.maxConnDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateObject(PooledObject<PooledConnectionAndInfo> pooledObject) {
        Connection conn;
        PooledConnection pooledConn;
        boolean valid;
        block14: {
            try {
                this.validateLifetime(pooledObject);
            }
            catch (Exception e) {
                return false;
            }
            valid = false;
            pooledConn = pooledObject.getObject().getPooledConnection();
            conn = null;
            this.validatingSet.add(pooledConn);
            try {
                int timeoutSeconds = this.toSeconds(this.validationQueryTimeoutDuration);
                if (this.validationQuery == null) {
                    try {
                        conn = pooledConn.getConnection();
                        valid = conn.isValid(timeoutSeconds);
                    }
                    catch (SQLException e) {
                        valid = false;
                    }
                    break block14;
                }
                Statement stmt = null;
                ResultSet rset = null;
                try {
                    conn = pooledConn.getConnection();
                    stmt = conn.createStatement();
                    if (timeoutSeconds > 0) {
                        stmt.setQueryTimeout(timeoutSeconds);
                    }
                    rset = stmt.executeQuery(this.validationQuery);
                    valid = rset.next();
                    if (this.rollbackAfterValidation) {
                        conn.rollback();
                    }
                    Utils.closeQuietly((AutoCloseable)rset);
                }
                catch (Exception e) {
                    valid = false;
                    break block14;
                }
                Utils.closeQuietly((AutoCloseable)stmt);
                break block14;
                finally {
                    Utils.closeQuietly(rset);
                    Utils.closeQuietly((AutoCloseable)stmt);
                }
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(conn);
                this.validatingSet.remove(pooledConn);
                throw throwable;
            }
        }
        Utils.closeQuietly((AutoCloseable)conn);
        this.validatingSet.remove(pooledConn);
        return valid;
    }
}

