/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.naivebayes.NaiveBayesModelWriter;

public class PlainTextNaiveBayesModelWriter
extends NaiveBayesModelWriter {
    private final BufferedWriter output;

    public PlainTextNaiveBayesModelWriter(AbstractModel model, File f) throws IOException {
        super(model);
        this.output = f.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f)))) : new BufferedWriter(new FileWriter(f));
    }

    public PlainTextNaiveBayesModelWriter(AbstractModel model, BufferedWriter bw) {
        super(model);
        this.output = bw;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.output.write(s);
        this.output.newLine();
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.output.write(Integer.toString(i));
        this.output.newLine();
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.output.write(Double.toString(d));
        this.output.newLine();
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

