<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

### 6.0 (Wed Dec 3 12:48:34 2025 -0300)

**Database Migrations**

- [#34560](https://github.com/apache/superset/pull/34560) feat: Implement UI-based system theme administration (@mistercrunch)
- [#34521](https://github.com/apache/superset/pull/34521) chore: use logger on all migrations (@villebro)
- [#34345](https://github.com/apache/superset/pull/34345) chore: proper current_app.config proxy usage (@mistercrunch)
- [#34182](https://github.com/apache/superset/pull/34182) feat: add a theme CRUD page to manage themes (@mistercrunch)
- [#34292](https://github.com/apache/superset/pull/34292) chore: move some rules from ruff -> pylint (@mistercrunch)
- [#33682](https://github.com/apache/superset/pull/33682) fix: Dataset currency (@Vitor-Avila)
- [#33564](https://github.com/apache/superset/pull/33564) chore: remove sqlparse (@betodealmeida)
- [#33303](https://github.com/apache/superset/pull/33303) fix: `metric.currency` should be JSON, not string (@betodealmeida)
- [#33155](https://github.com/apache/superset/pull/33155) chore: migrate to more db migration utils (@eschutho)
- [#33072](https://github.com/apache/superset/pull/33072) chore: use create table util  (@eschutho)
- [#33116](https://github.com/apache/superset/pull/33116) feat(explore): X-axis sort by specific metric when more than 1 metric is set (@kgabryje)
- [#32852](https://github.com/apache/superset/pull/32852) chore: update migrations to use utils (@sadpandajoe)
- [#32759](https://github.com/apache/superset/pull/32759) fix(migrations): fix foreign keys to match FAB 4.6.0 tables (@Antonio-RiveroMartnez)
- [#32680](https://github.com/apache/superset/pull/32680) feat: DB migration for dataset folders (@betodealmeida)
- [#32352](https://github.com/apache/superset/pull/32352) fix(dev/ci): pre-commit fixes galore  (@rusackas)

**Features**

- [#34732](https://github.com/apache/superset/pull/34732) feat: completely migrate from DeprecatedThemeColors to Antd semantic tokens (@mistercrunch)
- [#29573](https://github.com/apache/superset/pull/29573) feat(api): Added uuid filed support to dataset, chart, dashboard API (@dankor)
- [#34712](https://github.com/apache/superset/pull/34712) feat: replace react-color with AntD ColorPicker for theming support (@mistercrunch)
- [#34678](https://github.com/apache/superset/pull/34678) feat(extension): Add extension for chart header (@justinpark)
- [#34658](https://github.com/apache/superset/pull/34658) feat(sqllab): improve SaveDatasetModal design with proper theme spacing (@kasiazjc)
- [#27086](https://github.com/apache/superset/pull/27086) feat(filter_state): Added @api and @has_access_api to all methods of filter_state API. (@xneg)
- [#34663](https://github.com/apache/superset/pull/34663) feat: add @sadpandajoe to migrations CODEOWNERS (@mistercrunch)
- [#34655](https://github.com/apache/superset/pull/34655) feat(dashboard): change chart background option from "White" to "Solid" (@kasiazjc)
- [#34561](https://github.com/apache/superset/pull/34561) feat: Tiled screenshots in Playwright reports (@kgabryje)
- [#34434](https://github.com/apache/superset/pull/34434) feat: Add ESLint rule to enforce sentence case in button text (@sadpandajoe)
- [#34322](https://github.com/apache/superset/pull/34322) feat(deckgl): add selected cross-filter indication (@DamianPendrak)
- [#34373](https://github.com/apache/superset/pull/34373) feat(docker): Add pytest support to docker-compose-light.yml (@mistercrunch)
- [#34375](https://github.com/apache/superset/pull/34375) feat(timeshift): Add support for date range timeshifts (@msyavuz)
- [#34319](https://github.com/apache/superset/pull/34319) feat: Enable drilling in embedded (@Vitor-Avila)
- [#34406](https://github.com/apache/superset/pull/34406) feat: Add configurable query identifiers for Mixed Timeseries charts (@yousoph)
- [#34416](https://github.com/apache/superset/pull/34416) feat: add runtime custom font loading via configuration (@mistercrunch)
- [#34409](https://github.com/apache/superset/pull/34409) feat(codespaces): auto-setup Python venv with dependencies (@mistercrunch)
- [#34206](https://github.com/apache/superset/pull/34206) feat(i18n): update Spanish translations (messages.po) (@cbausaonebox)
- [#34376](https://github.com/apache/superset/pull/34376) feat: Add GitHub Codespaces support with docker-compose-light (@mistercrunch)
- [#34383](https://github.com/apache/superset/pull/34383) feat(charts): Enable async buildQuery support for complex chart logic (@mistercrunch)
- [#34380](https://github.com/apache/superset/pull/34380) feat: allow creating dataset without exploring (@betodealmeida)
- [#34379](https://github.com/apache/superset/pull/34379) feat: focus on text input when modal opens (@betodealmeida)
- [#34359](https://github.com/apache/superset/pull/34359) feat: read column metadata (@betodealmeida)
- [#34273](https://github.com/apache/superset/pull/34273) feat(theming): Align embedded sdk with theme configs (@gabotorresruiz)
- [#34324](https://github.com/apache/superset/pull/34324) feat: introducing a docker-compose-light.yml for lighter development (@mistercrunch)
- [#34308](https://github.com/apache/superset/pull/34308) feat(timeseries): enhance 'Series Limit' to support grouping the long tail (@mistercrunch)
- [#34294](https://github.com/apache/superset/pull/34294) feat: re-order CRUD list view action buttons (@mistercrunch)
- [#34290](https://github.com/apache/superset/pull/34290) feat: make `SupersetClient` retry on 502-504 (@betodealmeida)
- [#34258](https://github.com/apache/superset/pull/34258) feat(docker): do not include chromium (headless browser) by default in Dockerfile (@mistercrunch)
- [#34194](https://github.com/apache/superset/pull/34194) feat: introduce comprehensive LLM context guides for AI-powered development (@mistercrunch)
- [#34207](https://github.com/apache/superset/pull/34207) feat(docs): migrate ESLint to v9 (@hainenber)
- [#34231](https://github.com/apache/superset/pull/34231) feat: add Claude Code GitHub Action integration (@mistercrunch)
- [#34204](https://github.com/apache/superset/pull/34204) feat(deckgl): add support for OpenStreetMap as our new default and make "tile-providers" more configurable FIX (@plavacquery)
- [#33569](https://github.com/apache/superset/pull/33569) feat(pivot-table-chart): Download as pivoted excel (@mdusmanalvi)
- [#34156](https://github.com/apache/superset/pull/34156) feat(snowflake): Support Snowflake private keys w/o passphrase (@junyoneyama)
- [#33953](https://github.com/apache/superset/pull/33953) feat(i18n): add Catalan (ca) translations (@cbausaonebox)
- [#34177](https://github.com/apache/superset/pull/34177) feat: removing dup logic in sqla/models.py and models/helpers.py (@mistercrunch)
- [#34144](https://github.com/apache/superset/pull/34144) feat(theming): Introduce bootstrap-driven Superset theme configurations (@gabotorresruiz)
- [#32870](https://github.com/apache/superset/pull/32870) feat(filter panel): hide filter panel on all dashboard by default. (@SBIN2010)
- [#34119](https://github.com/apache/superset/pull/34119) feat(i18n): load language pack asynchronously (@mistercrunch)
- [#34140](https://github.com/apache/superset/pull/34140) feat: improve Doris catalog support (@betodealmeida)
- [#34017](https://github.com/apache/superset/pull/34017) feat(deckgl): add new color controls with color breakpoints (@DamianPendrak)
- [#33603](https://github.com/apache/superset/pull/33603) feat(deckgl): add support for OpenStreetMap as our new default and make "tile-providers" more configurable (@plavacquery)
- [#33769](https://github.com/apache/superset/pull/33769) feat(deck-gl): Enable individual deck.gl layer selection in FilterScope tree (@richardfogaca)
- [#34095](https://github.com/apache/superset/pull/34095) feat: Don't show the row limit warning for embedded dashboards by default (@Vitor-Avila)
- [#33517](https://github.com/apache/superset/pull/33517) feat(viz-type):  Ag grid table plugin Integration (@amaannawab923)
- [#33789](https://github.com/apache/superset/pull/33789) feat(deckgl): add cross-filters to deck.gl charts (@DamianPendrak)
- [#33170](https://github.com/apache/superset/pull/33170) feat(filter): Add Slider Range Inputs Option for Numerical Range Filters (@payose)
- [#33716](https://github.com/apache/superset/pull/33716) feat(plugin-chart-echarts): add Gantt Chart plugin (@Quatters)
- [#34023](https://github.com/apache/superset/pull/34023) feat(flag): Added feature_flag for superset security_views (@alexandrusoare)
- [#33809](https://github.com/apache/superset/pull/33809) feat: Add confirmation modal for unsaved changes (@gabotorresruiz)
- [#33947](https://github.com/apache/superset/pull/33947) feat(Table): Add infrastructure to override time shifts (@msyavuz)
- [#33929](https://github.com/apache/superset/pull/33929) feat(db): remove Rockset DB support (@hainenber)
- [#33781](https://github.com/apache/superset/pull/33781) feat(Dashboard): Row limit warning in dashboards (@msyavuz)
- [#33631](https://github.com/apache/superset/pull/33631) feat(User Registrations): Migrate user registrations fab view (@msyavuz)
- [#33871](https://github.com/apache/superset/pull/33871) feat(charts): Add row limit control to box plot chart (@DamianPendrak)
- [#33863](https://github.com/apache/superset/pull/33863) feat(Icons): Add HistoryOutlined (@msyavuz)
- [#33851](https://github.com/apache/superset/pull/33851) feat(theming): improving theme docs and configuration (@mistercrunch)
- [#31590](https://github.com/apache/superset/pull/31590) feat(theming): land Ant Design v5 overhaul — dynamic themes, real dark mode + massive styling refactor (@mistercrunch)
- [#33847](https://github.com/apache/superset/pull/33847) feat: initial Dremio sqlglot dialect (@betodealmeida)
- [#33829](https://github.com/apache/superset/pull/33829) feat(extension): Added extension point for Time Filters (@alexandrusoare)
- [#33656](https://github.com/apache/superset/pull/33656) feat(chart): add toggle for percentage metric calculation mode in Table chart (@LevisNgigi)
- [#33709](https://github.com/apache/superset/pull/33709) feat(DatasourceEditor): Format sql shortcut and bigger table (@msyavuz)
- [#33729](https://github.com/apache/superset/pull/33729) feat: x axis interval control to show ALL ticks on timeseries charts (@rusackas)
- [#32610](https://github.com/apache/superset/pull/32610) feat(clickhouse): allow dynamic schema (@codenamelxl)
- [#33634](https://github.com/apache/superset/pull/33634) feat(MixedTimeSeries): Add onlyTotal and Sort Series to Mixed TimeSeries (@nilmonto)
- [#33443](https://github.com/apache/superset/pull/33443) feat(Dataset): editor improvements - run in sqllab (@rebenitez1802)
- [#33620](https://github.com/apache/superset/pull/33620) feat(UserInfo): Migrate User Info FAB to React (@EnxDev)
- [#33301](https://github.com/apache/superset/pull/33301) feat(List Groups): Migrate List Groups FAB to React (@EnxDev)
- [#32887](https://github.com/apache/superset/pull/32887) feat(database): add SingleStore engine specification (@AdalbertMemSQL)
- [#33434](https://github.com/apache/superset/pull/33434) feat: Python 3.12 support (@rad-pat)
- [#33560](https://github.com/apache/superset/pull/33560) feat: use sqlglot to validate adhoc subquery (@betodealmeida)
- [#33542](https://github.com/apache/superset/pull/33542) feat(sqllab): use sqlglot instead of sqlparse (@betodealmeida)
- [#33614](https://github.com/apache/superset/pull/33614) feat: current_user_rls_rules Jinja macro (@Vitor-Avila)
- [#33525](https://github.com/apache/superset/pull/33525) feat: implement CVAS/CTAS in sqlglot (@betodealmeida)
- [#33524](https://github.com/apache/superset/pull/33524) feat: implement RLS in sqlglot (@betodealmeida)
- [#33518](https://github.com/apache/superset/pull/33518) feat: implement CTEs logic in sqlglot (@betodealmeida)
- [#33298](https://github.com/apache/superset/pull/33298) feat(Action Logs): Migrate Action Log FAB to React (@EnxDev)
- [#33473](https://github.com/apache/superset/pull/33473) feat: use sqlglot to set limit (@betodealmeida)
- [#33456](https://github.com/apache/superset/pull/33456) feat: implement limit extraction in sqlglot (@betodealmeida)
- [#32707](https://github.com/apache/superset/pull/32707) feat(stack by dimension): add a stack by dimension dropdown list (@jpchev)
- [#33451](https://github.com/apache/superset/pull/33451) feat(chart): add dynamicQueryObjectCount property to Chart Metadata (@DamianPendrak)
- [#33348](https://github.com/apache/superset/pull/33348) feat(Pie Chart): threshold for Other (@Quatters)
- [#33357](https://github.com/apache/superset/pull/33357) feat(Table Chart): Row limit Increase , Backend Sorting , Backend Search , Excel/CSV Improvements (@amaannawab923)
- [#33340](https://github.com/apache/superset/pull/33340) feat: Run SQL on DataSourceEditor implementation (@rebenitez1802)
- [#33099](https://github.com/apache/superset/pull/33099) feat: add metric name for big number chart types #33013 (@fardin-developer)
- [#29580](https://github.com/apache/superset/pull/29580) feat: Persian translations (@CodeWithEmad)
- [#33208](https://github.com/apache/superset/pull/33208) feat(maps): Adding Republic of Serbia to country maps (@rusackas)
- [#33192](https://github.com/apache/superset/pull/33192) feat(i18n): Frontend add zh_TW Option (@bestlong)
- [#33198](https://github.com/apache/superset/pull/33198) feat(maps): Adding Ivory Coast / Côte d'Ivoire (@rusackas)
- [#32695](https://github.com/apache/superset/pull/32695) feat(country-map): fix France Regions IDF region code - Fixes #32627 (@tarraschk)
- [#33043](https://github.com/apache/superset/pull/33043) feat(Select): Select all and Deselect all that works on visible items while searching (@msyavuz)
- [#33054](https://github.com/apache/superset/pull/33054) feat(Native Filters): Exclude Filter Values (@amaannawab923)
- [#32882](https://github.com/apache/superset/pull/32882) feat(List Users): Migrate List Users FAB to React (@EnxDev)
- [#29827](https://github.com/apache/superset/pull/29827) feat(lang): update Italian language (@WLCFaro)
- [#33104](https://github.com/apache/superset/pull/33104) feat(explore): Integrate dataset panel with Folders feature (@eschutho)
- [#28751](https://github.com/apache/superset/pull/28751) feat: catalogs for DuckDB (@betodealmeida)
- [#32520](https://github.com/apache/superset/pull/32520) feat: dataset folders (backend) (@betodealmeida)
- [#33096](https://github.com/apache/superset/pull/33096) feat(Native Filters): Configure creatable filter behavior (@geido)
- [#33000](https://github.com/apache/superset/pull/33000) feat: optimize catalog permission sync (@betodealmeida)
- [#32975](https://github.com/apache/superset/pull/32975) feat(charts): add subtitle option and metric customization controls (@LevisNgigi)
- [#30134](https://github.com/apache/superset/pull/30134) feat: Allow superset to be deployed under a prefixed URL (@martyngigg)
- [#33046](https://github.com/apache/superset/pull/33046) feat: add a title prop to the dashboard link in CRUD LIST view (@mistercrunch)
- [#30833](https://github.com/apache/superset/pull/30833) feat(tags): Export and Import Functionality for Superset Dashboards and Charts (@asher-lab)
- [#32997](https://github.com/apache/superset/pull/32997) feat: Add getDataMask function to embedded SDK (@kgabryje)
- [#31331](https://github.com/apache/superset/pull/31331) feat(embedding-sdk): emit data-mask events through embedded sdk to iframe parent (@MohamedHalat)
- [#32432](https://github.com/apache/superset/pull/32432) feat(List Roles): Migrate FAB view to React (@EnxDev)
- [#30760](https://github.com/apache/superset/pull/30760) feat: add latest partition support for BigQuery (@mistercrunch)
- [#32900](https://github.com/apache/superset/pull/32900) feat: Enable passing a permalink to cache_dashboard_screenshot endpoint (@kgabryje)
- [#28605](https://github.com/apache/superset/pull/28605) feat(plugins): Make comparison values on BigNumberPeriodOverPeriod toggleable (@mkramer5454)
- [#32814](https://github.com/apache/superset/pull/32814) feat(chart controls): Add  "%d.%m.%Y" time format option (@Quatters)
- [#32767](https://github.com/apache/superset/pull/32767) feat: Add Aggregation Method for Big Number with Trendline (@LevisNgigi)
- [#32770](https://github.com/apache/superset/pull/32770) feat: Add current_user_roles() Jinja macro (@bmaquet)
- [#32781](https://github.com/apache/superset/pull/32781) feat(Jinja): to_datetime filter (@Vitor-Avila)
- [#32721](https://github.com/apache/superset/pull/32721) feat(FormModal): Specialized Modal component for forms (@alexandrusoare)
- [#32735](https://github.com/apache/superset/pull/32735) feat(embedded): Force a specific referrerPolicy for the iframe request (@Vitor-Avila)
- [#32731](https://github.com/apache/superset/pull/32731) feat(where_in): Support returning None if filter_values return None (@Vitor-Avila)
- [#32670](https://github.com/apache/superset/pull/32670) feat: Implement sparse import for ImportAssetsCommand (@withnale)
- [#32682](https://github.com/apache/superset/pull/32682) feat(docs): Adding Kapa.ai integration (@rusackas)
- [#32662](https://github.com/apache/superset/pull/32662) feat: add a note to install cors-related dependency when using ENABLE_CORS (@mistercrunch)
- [#32546](https://github.com/apache/superset/pull/32546) feat: `OAuth2StoreTokenCommand` (@betodealmeida)
- [#32366](https://github.com/apache/superset/pull/32366) feat(reports): removing index column (@SkinnyPigeon)
- [#32170](https://github.com/apache/superset/pull/32170) feat(charts): add two new boxplot parameter sets (@sfirke)
- [#32510](https://github.com/apache/superset/pull/32510) feat(slack): adds rate limit error handler for Slack client (@Usiel)
- [#32509](https://github.com/apache/superset/pull/32509) feat(KustoKQL): Update KQL alchemy version and update timegrain expressions (@ag-ramachandran)
- [#32506](https://github.com/apache/superset/pull/32506) feat: make user agent customizable (@villebro)
- [#32317](https://github.com/apache/superset/pull/32317) feat(flag flip): Setting Horizontal Filters to True by default. (@rusackas)
- [#32121](https://github.com/apache/superset/pull/32121) feat: security, user group support (@dpgaspar)
- [#31996](https://github.com/apache/superset/pull/31996) feat: cache the frontend's bootstrap data (@mistercrunch)
- [#32048](https://github.com/apache/superset/pull/32048) feat: improve GSheets OAuth2 (@betodealmeida)
- [#32231](https://github.com/apache/superset/pull/32231) feat: Update database permissions in async mode (@Vitor-Avila)
- [#31726](https://github.com/apache/superset/pull/31726) feat(filter): adding inputs to Numerical Range Filter (@alexandrusoare)
- [#31506](https://github.com/apache/superset/pull/31506) feat(i18n): Add polish to default language (@EmmanuelCbd)
- [#32403](https://github.com/apache/superset/pull/32403) feat: default ports for SSH tunnel (@betodealmeida)
- [#32358](https://github.com/apache/superset/pull/32358) feat: Adding the option and feature to enable borders with color, opacity and width control on heatmaps along with white borders on emphasis  (@Dev10-34)
- [#32339](https://github.com/apache/superset/pull/32339) feat: allow importing encrypted_extra (@betodealmeida)
- [#32264](https://github.com/apache/superset/pull/32264) feat(number-format): adds memory data transfer rates in binary and decimal format (@tshallenberger)
- [#32261](https://github.com/apache/superset/pull/32261) feat(type-checking): Add type-checking pre-commit hooks (@alveifbklsiu259)
- [#32228](https://github.com/apache/superset/pull/32228) feat: recursive metric definitions (@betodealmeida)
- [#32189](https://github.com/apache/superset/pull/32189) feat(dropdown accessibility): Wrap dropdown triggers with buttons for accessibility (@msyavuz)
- [#31998](https://github.com/apache/superset/pull/31998) feat: Add parseJson Handlebars Helper to Support Processing Nested JSON Data (@AdrianKoszalka)
- [#31998](https://github.com/apache/superset/pull/31998) feat: Add parseJson Handlebars Helper to Support Processing Nested JSON Data (@AdrianKoszalka)
- [#32041](https://github.com/apache/superset/pull/32041) feat: add TDengine.py driver to db_engine (@DuanKuanJun)

**Fixes**

- [#36359](https://github.com/apache/superset/pull/36359) fix(SQLLab): most recent queries at the top in Query History without refreshing the page (@FelipeGLopez)
- [#36382](https://github.com/apache/superset/pull/36382) fix: `is_column_reference` check (@betodealmeida)
- [#36289](https://github.com/apache/superset/pull/36289) fix(controlPanel): add integer validation for rows per page setting (@ompharate)
- [#36269](https://github.com/apache/superset/pull/36269) fix(log): remove unwanted info from logs REST API (@dpgaspar)
- [#36266](https://github.com/apache/superset/pull/36266) fix: remove unwanted info from tags REST API (@dpgaspar)
- [#36134](https://github.com/apache/superset/pull/36134) fix: Columns bleeding into other cells (@EnxDev)
- [#36190](https://github.com/apache/superset/pull/36190) fix: Table chart types headers are offset from the columns in the table (@EnxDev)
- [#36133](https://github.com/apache/superset/pull/36133) fix: Extra controls width for Area Chart on dashboards (@EnxDev)
- [#36126](https://github.com/apache/superset/pull/36126) fix(screenshots): Only cache thumbnails when image generation succeeds (@eschutho)
- [#36215](https://github.com/apache/superset/pull/36215) fix: adhoc column quoting (@betodealmeida)
- [#36222](https://github.com/apache/superset/pull/36222) fix(sqllab): validate results backend writes and enhance 410 diagnostics (@dpgaspar)
- [#36167](https://github.com/apache/superset/pull/36167) fix(dashboard): adjust vertical spacing for numerical range filter to prevent overlaps (@EnxDev)
- [#36011](https://github.com/apache/superset/pull/36011) fix(dashboard): ensure charts re-render when visibility state changes (@richardfogaca)
- [#36166](https://github.com/apache/superset/pull/36166) fix(datasets): prevent viewport overflow in dataset creation page (@EnxDev)
- [#36123](https://github.com/apache/superset/pull/36123) fix:  role list edit modal height (@SBIN2010)
- [#36109](https://github.com/apache/superset/pull/36109) fix(cache): apply dashboard filters to non-legacy visualizations in w… (@richardfogaca)
- [#36122](https://github.com/apache/superset/pull/36122) fix: 'save and go to dashboard' option was disabled after changing the chart type (@richardfogaca)
- [#34055](https://github.com/apache/superset/pull/34055) fix(translations): Fix Russian translations for EmptyState (@PolinaFam)
- [#36075](https://github.com/apache/superset/pull/36075) fix(tags): ensure tag creation is compatible with MySQL by avoiding Markup objects (@ysinghc)
- [#35890](https://github.com/apache/superset/pull/35890) fix(datasets): prevent double time filter application in virtual datasets (@betodealmeida)
- [#36120](https://github.com/apache/superset/pull/36120) fix(navbar): some styling + components inconsistencies (@gabotorresruiz)
- [#35919](https://github.com/apache/superset/pull/35919) fix(dashboard): ensure world map chart uses correct country code format in crossfilter (@yong1le)
- [#35998](https://github.com/apache/superset/pull/35998) fix: fix crossfilter persisting after removal (@LevisNgigi)
- [#36101](https://github.com/apache/superset/pull/36101) fix: opacity color formating (@SBIN2010)
- [#35968](https://github.com/apache/superset/pull/35968) fix(table-chart): fix missing table header IDs (@sadpandajoe)
- [#35817](https://github.com/apache/superset/pull/35817) fix: save button was enabled even no changes were made to the dashboard (@richardfogaca)
- [#35693](https://github.com/apache/superset/pull/35693) fix(histogram): add NULL handling for histogram (@janani-gurram)
- [#36061](https://github.com/apache/superset/pull/36061) fix: RLS in virtual datasets (@betodealmeida)
- [#35986](https://github.com/apache/superset/pull/35986) fix(ace-editor-popover): main AntD popover closes when clicking autocomplete suggestions in Ace Editor (@EnxDev)
- [#36077](https://github.com/apache/superset/pull/36077) fix(chart): align legend with chart grid in List mode for Top/Bottom orientations (@richardfogaca)
- [#35834](https://github.com/apache/superset/pull/35834) fix(dashboard): prevent tab content cutoff and excessive whitespace in empty tabs (@richardfogaca)
- [#35265](https://github.com/apache/superset/pull/35265) fix(dashboard): refresh tabs as they load when dashboard is refreshed (@msyavuz)
- [#35937](https://github.com/apache/superset/pull/35937) fix(explore): re-apply filters when 'Group remaining as Others' is enabled (@richardfogaca)
- [#36096](https://github.com/apache/superset/pull/36096) fix: Use singlestoredb dialect for sqlglot (@Vitor-Avila)
- [#36091](https://github.com/apache/superset/pull/36091) fix(navbar): Minor fixes in navbar spacings (@gabotorresruiz)
- [#35553](https://github.com/apache/superset/pull/35553) fix(sql): quote column names with spaces to prevent SQLGlot parsing errors (@msyavuz)
- [#35984](https://github.com/apache/superset/pull/35984) fix: fix tabs overflow in dashboards (@LevisNgigi)
- [#35886](https://github.com/apache/superset/pull/35886) fix(dashboard): dashboard filter was incorrectly showing as out of scope (@richardfogaca)
- [#36036](https://github.com/apache/superset/pull/36036) fix(dashboard): align filter bar elements vertically in horizontal mode (@richardfogaca)
- [#35992](https://github.com/apache/superset/pull/35992) fix(sqllab): prevent unwanted tab switching when autocompleting table names on SQL Lab (@richardfogaca)
- [#35866](https://github.com/apache/superset/pull/35866) fix: saved query preview modal not highlighting active rows (@richardfogaca)
- [#35889](https://github.com/apache/superset/pull/35889) fix(permalink): exclude edit mode from dashboard permalink (@msyavuz)
- [#35969](https://github.com/apache/superset/pull/35969) fix(explore): show validation errors in View Query modal (@sadpandajoe)
- [#36051](https://github.com/apache/superset/pull/36051) fix: Flakiness around scrolling during taking tiled screenshots with Playwright (@kgabryje)
- [#36039](https://github.com/apache/superset/pull/36039) fix(date_parser): add check for time range timeshifts (@msyavuz)
- [#35800](https://github.com/apache/superset/pull/35800) fix(reports): improve error handling for report schedule execution (@eschutho)
- [#35152](https://github.com/apache/superset/pull/35152) fix(filters): preserve backend metric-based sorting (@eschutho)
- [#33677](https://github.com/apache/superset/pull/33677) fix(echarts): Series style hidden for line charts (@vedantprajapati)
- [#36027](https://github.com/apache/superset/pull/36027) fix: Ensure that Playwright tile height is always positive (@kgabryje)
- [#33791](https://github.com/apache/superset/pull/33791) fix(Context-Menu): Fixing Context Menu for Table Chart with Html Content (@amaannawab923)
- [#36010](https://github.com/apache/superset/pull/36010) fix(UI): spacings + UI fixes (@gabotorresruiz)
- [#35303](https://github.com/apache/superset/pull/35303) fix(SelectFilterPlugin): clear all clears all filters including dependent ones (@msyavuz)
- [#35931](https://github.com/apache/superset/pull/35931) fix(view-in-sqllab): unable to open virtual dataset after discarding chart edits (@EnxDev)
- [#33392](https://github.com/apache/superset/pull/33392) fix(chart list): Facepile shows correct users when saving chart properties (@ethan-l-geotab)
- [#35916](https://github.com/apache/superset/pull/35916) fix(DatabaseModal): prevent errors when pasting text into supported database select (@EnxDev)
- [#35888](https://github.com/apache/superset/pull/35888) fix(explore): Overwriting a chart updates the form_data_key (@msyavuz)
- [#35619](https://github.com/apache/superset/pull/35619) fix(TimeTable): Match calculations between filtered and non filtered states (@msyavuz)
- [#35488](https://github.com/apache/superset/pull/35488) fix(dashboard): fix dataset search in filter config modal (@rebenitez1802)
- [#35790](https://github.com/apache/superset/pull/35790) fix(DatasourceEditor): preserve calculated column order when editing sql (@msyavuz)
- [#35917](https://github.com/apache/superset/pull/35917) fix(sqllab): align refresh buttons with select input fields (@richardfogaca)
- [#35898](https://github.com/apache/superset/pull/35898) fix(explore): formatting the SQL in "View Query" pop-up doesn't format (@sadpandajoe)
- [#35848](https://github.com/apache/superset/pull/35848) fix(db2): update time grain expressions for DAY to use DATE function (@ysinghc)
- [#35912](https://github.com/apache/superset/pull/35912) fix: set pandas 2.1 as requirement (@villebro)
- [#35885](https://github.com/apache/superset/pull/35885) fix: displaying cell bars in table (@SBIN2010)
- [#35587](https://github.com/apache/superset/pull/35587) fix: add utc=True to pd.to_datetime for timezone-aware datetimes (@aminghadersohi)
- [#35807](https://github.com/apache/superset/pull/35807) fix(reports): Add celery task execution ID to email notification logs (@eschutho)
- [#35826](https://github.com/apache/superset/pull/35826) fix(echarts): fix time shift color matching functionality (@msyavuz)
- [#35750](https://github.com/apache/superset/pull/35750) fix: update Russian translations (@innovark37)
- [#35821](https://github.com/apache/superset/pull/35821) fix(theme): add fontWeightStrong to allowedAntdTokens to fix bold markdown rendering (@sadpandajoe)
- [#35118](https://github.com/apache/superset/pull/35118) fix(sqllab): Fix CSV export button href in SQL Lab when application root is defined (@martyngigg)
- [#35601](https://github.com/apache/superset/pull/35601) fix(SqlLab): South pane visual changes (@msyavuz)
- [#35317](https://github.com/apache/superset/pull/35317) fix(native-filters): prevent circular dependencies and improve dependency handling (@ngokturkkarli)
- [#35289](https://github.com/apache/superset/pull/35289) fix(database-modal): fix issue where commas could not be typed into DB configuration. (@LevisNgigi)
- [#35771](https://github.com/apache/superset/pull/35771) fix: unpin holidays and prophet (@dpgaspar)
- [#35808](https://github.com/apache/superset/pull/35808) fix(dashboard): handle invalid thumbnail BytesIO objects gracefully (@eschutho)
- [#35622](https://github.com/apache/superset/pull/35622) fix(alerts): improve Slack API rate limiting for large workspaces (@marcosmamorim)
- [#35605](https://github.com/apache/superset/pull/35605) fix(ag-grid): fix conditional formatting theme colors and module extensibility (@gabotorresruiz)
- [#35799](https://github.com/apache/superset/pull/35799) fix: edit dataset modal visual fixes (@richardfogaca)
- [#35794](https://github.com/apache/superset/pull/35794) fix(ThemeController): replace fetch with SupersetClient for proper auth (@msyavuz)
- [#35454](https://github.com/apache/superset/pull/35454) fix(security): Add active property to guest user (@msyavuz)
- [#35724](https://github.com/apache/superset/pull/35724) fix(Actions): Improper spacing (@geido)
- [#35484](https://github.com/apache/superset/pull/35484) fix(playwright): Download dashboard correctly (@tahvane1)
- [#35694](https://github.com/apache/superset/pull/35694) fix(charts): update axis title labels to sentence case (@yousoph)
- [#35345](https://github.com/apache/superset/pull/35345) fix(auth): redirect anonymous attempts to view dashboard with next (@sfirke)
- [#35669](https://github.com/apache/superset/pull/35669) fix(dataset): render default URL description properly in settings (@betodealmeida)
- [#35558](https://github.com/apache/superset/pull/35558) fix(theme-crud): enable overwrite confirmation UI for theme imports (@gabotorresruiz)
- [#35648](https://github.com/apache/superset/pull/35648) fix(table-chart): fix page size label visibility and improve header control wrapping (@gabotorresruiz)
- [#35651](https://github.com/apache/superset/pull/35651) fix(theme): align "Clear local theme" option with other theme menu items (@rebenitez1802)
- [#35595](https://github.com/apache/superset/pull/35595) fix: Log Celery task failures with a signal handler (@eschutho)
- [#35529](https://github.com/apache/superset/pull/35529) fix(d3-format): call setupFormatters synchronously to apply D3 format… (@innovark37)
- [#35537](https://github.com/apache/superset/pull/35537) fix(deckgl): scatterplot fix categorical color (@DamianPendrak)
- [#35586](https://github.com/apache/superset/pull/35586) fix(csv upload): Correctly casting to string numbers with floating points (e+) (@luizotavio32)
- [#35592](https://github.com/apache/superset/pull/35592) fix(alerts): log execution_id instead of report schedule name in query timing (@eschutho)
- [#35338](https://github.com/apache/superset/pull/35338) fix(tables): Dark mode scrollbar styles for webkit (@msyavuz)
- [#35572](https://github.com/apache/superset/pull/35572) fix(Alerts): Correct icon sizes (@msyavuz)
- [#35543](https://github.com/apache/superset/pull/35543) fix: dataset update with invalid SQL query (@dpgaspar)
- [#35123](https://github.com/apache/superset/pull/35123) fix(charts): fix legend theming and hollow symbols in dark mode (@gabotorresruiz)
- [#35527](https://github.com/apache/superset/pull/35527) fix(chart): Fixes BigNumber gradient appearing blackish in light mode (@rebenitez1802)
- [#35491](https://github.com/apache/superset/pull/35491) fix(explore): Include chart canvases in the screenshot (@msyavuz)
- [#35523](https://github.com/apache/superset/pull/35523) fix: update chart with dashboards validation (@dpgaspar)
- [#35504](https://github.com/apache/superset/pull/35504) fix(webdriver): add missing options object to WebDriver initialization (@aminghadersohi)
- [#35508](https://github.com/apache/superset/pull/35508) fix: Support metric macro for  embedded users (@Vitor-Avila)
- [#35489](https://github.com/apache/superset/pull/35489) fix(explore): correct search icon in dashboard submenu (@rebenitez1802)
- [#35487](https://github.com/apache/superset/pull/35487) fix(Select): Prevent closing the select when clicking on a tag (@msyavuz)
- [#35129](https://github.com/apache/superset/pull/35129) fix(loading): improve loading screen theming for dark mode support (@eschutho)
- [#35290](https://github.com/apache/superset/pull/35290) fix(security-manager): switch from deprecated get_session to session attribute (@tuantran0910)
- [#35482](https://github.com/apache/superset/pull/35482) fix(sqlglot): adhoc expressions (@betodealmeida)
- [#35339](https://github.com/apache/superset/pull/35339) fix(dashboard): Navigate to new dashboard when saved as a new one (@msyavuz)
- [#35321](https://github.com/apache/superset/pull/35321) fix(theming): CRUD view padding (@msyavuz)
- [#35453](https://github.com/apache/superset/pull/35453) fix(ag-grid-table): remove enterprise features to use community version (@amaannawab923)
- [#35419](https://github.com/apache/superset/pull/35419) fix(cache): ensure SQL is sanitized before cache key generation (@betodealmeida)
- [#35451](https://github.com/apache/superset/pull/35451) fix(pinot): more functions (@betodealmeida)
- [#35336](https://github.com/apache/superset/pull/35336) fix(dashboard): exit markdown edit mode when clicking outside of element (@gabotorresruiz)
- [#35277](https://github.com/apache/superset/pull/35277) fix(dataset): sort by database in Dataset and Saved queries Issue (@rebenitez1802)
- [#35427](https://github.com/apache/superset/pull/35427) fix(pinot): `SUBSTR` function (@betodealmeida)
- [#35426](https://github.com/apache/superset/pull/35426) fix(pinot): `DATE_SUB` function (@betodealmeida)
- [#35452](https://github.com/apache/superset/pull/35452) fix(slice): Fix using isdigit when id passed as int (@Antonio-RiveroMartnez)
- [#35424](https://github.com/apache/superset/pull/35424) fix(pinot): `DATE_ADD` function (@betodealmeida)
- [#35420](https://github.com/apache/superset/pull/35420) fix(pinot): dialect date truncation (@betodealmeida)
- [#35350](https://github.com/apache/superset/pull/35350) fix: table quoting in DBs with `supports_cross_catalog_queries=True` (@betodealmeida)
- [#35307](https://github.com/apache/superset/pull/35307) fix(explore): close unsaved changes modal when discarding changes (@rebenitez1802)
- [#35341](https://github.com/apache/superset/pull/35341) fix(SqlLab): Hit tableschemaview with a valid queryEditorId (@geido)
- [#35337](https://github.com/apache/superset/pull/35337) fix(pinot): restrict types in dialect (@betodealmeida)
- [#35342](https://github.com/apache/superset/pull/35342) fix: adhoc orderby in explore (@betodealmeida)
- [#35333](https://github.com/apache/superset/pull/35333) fix: sqlglot dialect for Pinot (@betodealmeida)
- [#35332](https://github.com/apache/superset/pull/35332) fix(doris): Don't set supports_cross_catalog_queries to true (@msyavuz)
- [#35316](https://github.com/apache/superset/pull/35316) fix: AceEditor Autocomplete Highlight (@geido)
- [#35256](https://github.com/apache/superset/pull/35256) fix(DatasourceModal): replace imperative modal updates with declarative state (@eschutho)
- [#35309](https://github.com/apache/superset/pull/35309) fix(sqllab): fix blank bottom section in SQL Lab left panel (@gabotorresruiz)
- [#35292](https://github.com/apache/superset/pull/35292) fix(DateFilterControl): remove modal overlay style to fix z-index issues (@msyavuz)
- [#35274](https://github.com/apache/superset/pull/35274) fix(table): New ad-hoc columns retain the name of previous columns (@SBIN2010)
- [#35122](https://github.com/apache/superset/pull/35122) fix: Cosmetic issues (@geido)
- [#35213](https://github.com/apache/superset/pull/35213) fix(BuilderComponentPane): navigation tabs padding (@msyavuz)
- [#35033](https://github.com/apache/superset/pull/35033) fix(deck.gl): ensure min/max values are included in polygon map legend breakpoints (@giuliosmall)
- [#35216](https://github.com/apache/superset/pull/35216) fix(SQL Lab): syncTable on new tabs (@betodealmeida)
- [#35224](https://github.com/apache/superset/pull/35224) fix(Mixed Chart): Tooltip incorrectly displays numbers with optional Y-axis format and showQueryIdentifiers set to true (@SBIN2010)
- [#35199](https://github.com/apache/superset/pull/35199) fix(dashboard): update header border to use colorBorder token (@eschutho)
- [#35243](https://github.com/apache/superset/pull/35243) fix(ConditionalFormattingControl): icon color in dark mode (@msyavuz)
- [#35211](https://github.com/apache/superset/pull/35211) fix(table-chart): fix cell bar visibility in dark theme (@LevisNgigi)
- [#35219](https://github.com/apache/superset/pull/35219) fix: defensive code to avoid accesing attribute of a NoneType object (@gabotorresruiz)
- [#35212](https://github.com/apache/superset/pull/35212) fix(SQLPopover): Use correct component (@msyavuz)
- [#35179](https://github.com/apache/superset/pull/35179) fix: bug in tooltip timeseries chart in calculated total with annotation layer (@SBIN2010)
- [#34999](https://github.com/apache/superset/pull/34999) fix: Bump pandas to 2.1.4 for python 3.12 (@rad-pat)
- [#35076](https://github.com/apache/superset/pull/35076) fix(Funnel): onInit overridden row_limit to default value on save chart (@SBIN2010)
- [#35189](https://github.com/apache/superset/pull/35189) fix(gantt-chart): fix Y-axis label visibility in dark theme (@LevisNgigi)
- [#35155](https://github.com/apache/superset/pull/35155) fix(CrudThemeProvider): Optimized theme loading logic (@marunrun)
- [#35168](https://github.com/apache/superset/pull/35168) fix(embedded): resolve theme context error in Loading component (@marunrun)
- [#35151](https://github.com/apache/superset/pull/35151) fix(viz): resolve dark mode compatibility issues in BigNumber and Heatmap (@mistercrunch)
- [#35144](https://github.com/apache/superset/pull/35144) fix: import bug template params (@SBIN2010)
- [#35142](https://github.com/apache/superset/pull/35142) fix(deck.gl): restore legend display for Polygon charts with linear palette and fixed color schemes (@sadpandajoe)
- [#35124](https://github.com/apache/superset/pull/35124) fix: Remove emotion-rgba from dependencies and codebase (@eschutho)
- [#35057](https://github.com/apache/superset/pull/35057) fix(ListView): implement AntD pagination for ListView component (@gabotorresruiz)
- [#35114](https://github.com/apache/superset/pull/35114) fix(theming): Lighter text colors on dark mode (@msyavuz)
- [#33055](https://github.com/apache/superset/pull/33055) fix: Bump FAB to 5.X (@dpgaspar)
- [#35105](https://github.com/apache/superset/pull/35105) fix: SQL Lab tab events (@michael-s-molina)
- [#35095](https://github.com/apache/superset/pull/35095) fix: page size options 'all' correct in table and remove PAGE_SIZE_OPTIONS in handlebars (@SBIN2010)
- [#35086](https://github.com/apache/superset/pull/35086) fix(pie): fixes pie chart other click error (@cbum-dev)
- [#35090](https://github.com/apache/superset/pull/35090) fix(theming): replace error color with bolt icon for local themes (@gabotorresruiz)
- [#35094](https://github.com/apache/superset/pull/35094) fix(templates): Restores templates files accidentally removed  (@rebenitez1802)
- [#35096](https://github.com/apache/superset/pull/35096) fix(settingsMenu): Version  (@rebenitez1802)
- [#34694](https://github.com/apache/superset/pull/34694) fix(drill-to-detail): ensure axis label filters map to original column names (@LisaHusband)
- [#35072](https://github.com/apache/superset/pull/35072) fix(timeshifts): Add missing feature flag to enum (@msyavuz)
- [#34558](https://github.com/apache/superset/pull/34558) fix(Table Chart): render null dates properly (@nicob3y)
- [#35064](https://github.com/apache/superset/pull/35064) fix(table): table search input placeholder (@SBIN2010)
- [#35007](https://github.com/apache/superset/pull/35007) fix(tests): one of integration test in TestSqlaTableModel  does not support MySQL "concat"  (@catpineapple)
- [#34763](https://github.com/apache/superset/pull/34763) fix: Upload CSV as Dataset (@luizotavio32)
- [#35001](https://github.com/apache/superset/pull/35001) fix(dashboard): normalize spacings and background colors (@gabotorresruiz)
- [#34828](https://github.com/apache/superset/pull/34828) fix(theming): Icons in ExecutionLogList and Country map chart tooltip theme consistency (@rebenitez1802)
- [#35036](https://github.com/apache/superset/pull/35036) fix: mixed timeseries chart add legend margin (@SBIN2010)
- [#34973](https://github.com/apache/superset/pull/34973) fix(chart): change "No query." to "Query cannot be loaded" in Multi Layer Deck.gl Chart (@DamianPendrak)
- [#35022](https://github.com/apache/superset/pull/35022) fix(echarts): rename time series shifted for isTimeComparisonValue (@justinpark)
- [#35005](https://github.com/apache/superset/pull/35005) fix: display legend mixed timeseries chart  (@SBIN2010)
- [#34662](https://github.com/apache/superset/pull/34662) fix(sql): Add Impala dialect support to sqlglot parser (@rusackas)
- [#34987](https://github.com/apache/superset/pull/34987) fix(theming): more visual bugs (@msyavuz)
- [#35017](https://github.com/apache/superset/pull/35017) fix(RoleListEditModal): display user's other properties in table (@msyavuz)
- [#35011](https://github.com/apache/superset/pull/35011) fix: doris genericDataType modify (@catpineapple)
- [#34870](https://github.com/apache/superset/pull/34870) fix(deps): expand pyarrow version range to <19 (@sha174n)
- [#34995](https://github.com/apache/superset/pull/34995) fix(tests): resolve AlertReportModal checkmark test failures (@sadpandajoe)
- [#34874](https://github.com/apache/superset/pull/34874) fix(ui-core): Invalid postTransform process (@justinpark)
- [#34781](https://github.com/apache/superset/pull/34781) fix(sqllab): autocomplete and delete tabs (@justinpark)
- [#34803](https://github.com/apache/superset/pull/34803) fix(error-handling): jinja2 error handling improvements (@gabotorresruiz)
- [#34991](https://github.com/apache/superset/pull/34991) fix(databricks): string escaper v2 (@Vitor-Avila)
- [#34760](https://github.com/apache/superset/pull/34760) fix(charts): Handle virtual dataset names without schema prefix correctly (@rusackas)
- [#34761](https://github.com/apache/superset/pull/34761) fix(echarts): Display NULL values in categorical x-axis for bar charts (@rusackas)
- [#34918](https://github.com/apache/superset/pull/34918) fix(ChartCreation): Translate chart description (@msyavuz)
- [#34978](https://github.com/apache/superset/pull/34978) fix: playwright feature flag evaluation (@dpgaspar)
- [#34989](https://github.com/apache/superset/pull/34989) fix(TimeTable): use type-only export for TableChartProps to resolve webpack warnings (@gabotorresruiz)
- [#34975](https://github.com/apache/superset/pull/34975) fix(dashboard): table charts render correctly after tab switch and refresh (@gabotorresruiz)
- [#34895](https://github.com/apache/superset/pull/34895) fix: Athena quoting (@betodealmeida)
- [#34909](https://github.com/apache/superset/pull/34909) fix: revert mistake setting TALISMAN_ENABLED=False (@mistercrunch)
- [#34868](https://github.com/apache/superset/pull/34868) fix(theming): fix TimeTable chart issues (@gabotorresruiz)
- [#34850](https://github.com/apache/superset/pull/34850) fix: complete theme management system import/export (@mistercrunch)
- [#34887](https://github.com/apache/superset/pull/34887) fix: Improve table layout and column sizing (@kgabryje)
- [#34724](https://github.com/apache/superset/pull/34724) fix(drilling): drill by pagination works with MSSQL data source, cont. (@sfirke)
- [#34900](https://github.com/apache/superset/pull/34900) fix: Filter bar orientation submenu should not be highlighted (@kgabryje)
- [#34864](https://github.com/apache/superset/pull/34864) fix(ConfirmStatusChange): remove deprecated event.persist() to fix headless browser crashes (@sadpandajoe)
- [#34878](https://github.com/apache/superset/pull/34878) fix(tests): Improve MessageChannel mocking to prevent worker force exits (@sadpandajoe)
- [#34858](https://github.com/apache/superset/pull/34858) fix: SelectControl default sort numeric choices by value (@kgabryje)
- [#34869](https://github.com/apache/superset/pull/34869) fix: Undefined error when viewing query in Explore + visual fixes (@kgabryje)
- [#34871](https://github.com/apache/superset/pull/34871) fix(tests): Mock MessageChannel to prevent Jest hanging from rc-overflow (@sadpandajoe)
- [#34855](https://github.com/apache/superset/pull/34855) fix: Remove the underline from the right section of main menu (@kgabryje)
- [#34854](https://github.com/apache/superset/pull/34854) fix: DB icon sizes in database add modal (@kgabryje)
- [#34843](https://github.com/apache/superset/pull/34843) fix(dashboard): Anchor link positions (@kgabryje)
- [#34846](https://github.com/apache/superset/pull/34846) fix(sqllab): Missing executed sql value in the result table (@justinpark)
- [#34665](https://github.com/apache/superset/pull/34665) fix: Avoid dataset drill request if no perm (@Vitor-Avila)
- [#34782](https://github.com/apache/superset/pull/34782) fix: Add dataset ID to file name on exports (@Vitor-Avila)
- [#34795](https://github.com/apache/superset/pull/34795) fix(theming): explore chart type style fixes, nav right menu spacing fixed (@rebenitez1802)
- [#34801](https://github.com/apache/superset/pull/34801) fix: make `get_image()` always return `BytesIO` (@betodealmeida)
- [#34798](https://github.com/apache/superset/pull/34798) fix: Unexpected overflow ellipsis dots after status icon in Dashboard list (@kgabryje)
- [#34815](https://github.com/apache/superset/pull/34815) fix(echarts): Series labels hard to read in dark mode (@kgabryje)
- [#34809](https://github.com/apache/superset/pull/34809) fix(Icons): Add missing data-test and aria-label attributes to   custom icons (@sadpandajoe)
- [#34802](https://github.com/apache/superset/pull/34802) fix: User-provided Jinja template parameters causing SQL parsing errors (@michael-s-molina)
- [#34808](https://github.com/apache/superset/pull/34808) fix: customize column description limit size in db_engine_spec (@justinpark)
- [#34790](https://github.com/apache/superset/pull/34790) fix(DetailsPanel): Applied filters colors (@msyavuz)
- [#34812](https://github.com/apache/superset/pull/34812) fix(native-filters): Low contrast of empty state in dark mode (@kgabryje)
- [#34811](https://github.com/apache/superset/pull/34811) fix: Low contrast in viz creator selected tag in dark mode (@kgabryje)
- [#34814](https://github.com/apache/superset/pull/34814) fix: Remove border around textarea in dashboard edit mode (@kgabryje)
- [#34799](https://github.com/apache/superset/pull/34799) fix: Misaligned global controls in Table chart (@kgabryje)
- [#34777](https://github.com/apache/superset/pull/34777) fix(dashboard): enable undo/redo buttons for layout changes (@gabotorresruiz)
- [#34679](https://github.com/apache/superset/pull/34679) fix: Check migration status before initializing database-dependent features (@mistercrunch)
- [#34719](https://github.com/apache/superset/pull/34719) fix: default value in run-server.sh (@prochac)
- [#32640](https://github.com/apache/superset/pull/32640) fix: catch no table error (@eschutho)
- [#34793](https://github.com/apache/superset/pull/34793) fix(PivotExcelExport): select correct chart for export (@msyavuz)
- [#34780](https://github.com/apache/superset/pull/34780) fix(tests): make SingleStore test_adjust_engine_params version-agnostic (@sadpandajoe)
- [#34791](https://github.com/apache/superset/pull/34791) fix(webpack): Bump webpack dev-server to handle Errors on Firefox where error object is not defined (@amaannawab923)
- [#34765](https://github.com/apache/superset/pull/34765) fix(sqllab): Fix save query modal closing prematurely on new tabs (@rusackas)
- [#34051](https://github.com/apache/superset/pull/34051) fix(translations): Fix translation of time-related strings like "7 seconds ago", "a minute ago", etc (@PolinaFam)
- [#34769](https://github.com/apache/superset/pull/34769) fix: Fix TypeError in Slice.get() method when using filter_by() with BinaryExpression (@sadpandajoe)
- [#34743](https://github.com/apache/superset/pull/34743) fix(duckdb): Add support for DuckDB-specific numeric types (@rusackas)
- [#34683](https://github.com/apache/superset/pull/34683) fix(sqllab): Invisible grid table due to the invalid height (@justinpark)
- [#34757](https://github.com/apache/superset/pull/34757) fix: Users can't skip column sync when saving virtual datasets (@michael-s-molina)
- [#34720](https://github.com/apache/superset/pull/34720) fix(sqllab): Reduce flushing caused by ID updates (@justinpark)
- [#34758](https://github.com/apache/superset/pull/34758) fix(saved_query): Copy link to clipboard before redirect to edit (#34567) (@justinpark)
- [#34756](https://github.com/apache/superset/pull/34756) fix(RightMenu): Move RightMenu carets to the right side (@msyavuz)
- [#34705](https://github.com/apache/superset/pull/34705) fix: Highlight outline of numerical range and time range filters (@kgabryje)
- [#34676](https://github.com/apache/superset/pull/34676) fix(theming): Some visual issues (@rebenitez1802)
- [#34660](https://github.com/apache/superset/pull/34660) fix: Table chart server side pagination not working on dashboard (@kgabryje)
- [#34708](https://github.com/apache/superset/pull/34708) fix(dashboard): Remove Tab from Dashboard Confirm Modal themed (@rebenitez1802)
- [#34706](https://github.com/apache/superset/pull/34706) fix(dashboard): Titles tooltip flickering (@rebenitez1802)
- [#34654](https://github.com/apache/superset/pull/34654) fix: centralize cache timeout -1 logic to prevent caching (@dpgaspar)
- [#34686](https://github.com/apache/superset/pull/34686) fix(ag-grid): Fix broken string column filters in AG Grid Table V2 (@amaannawab923)
- [#34418](https://github.com/apache/superset/pull/34418) fix(dashboard): update cross filter scoping chart id references during dashboard import (@trentontrees)
- [#34709](https://github.com/apache/superset/pull/34709) fix: Timeseries annotation layers (@michael-s-molina)
- [#34690](https://github.com/apache/superset/pull/34690) fix(deck.gl): add webpack rule to define module global for deck.gl charts (@richardfogaca)
- [#34698](https://github.com/apache/superset/pull/34698) fix: Invalid error tooltip if control label is function (@kgabryje)
- [#34671](https://github.com/apache/superset/pull/34671) fix: Bar chart crash when switching from Big Number (@kgabryje)
- [#34680](https://github.com/apache/superset/pull/34680) fix(bootstrapData): Missing application_root data throws an error (@justinpark)
- [#34675](https://github.com/apache/superset/pull/34675) fix(theming): Fix ag-grid theming regression in SQL Lab (@mistercrunch)
- [#34672](https://github.com/apache/superset/pull/34672) fix(row_level_security): Correct api response code for update (@msyavuz)
- [#34585](https://github.com/apache/superset/pull/34585) fix(theming): Theming visual fixes p5 (@msyavuz)
- [#34664](https://github.com/apache/superset/pull/34664) fix(csv_tests): Import from utils (@msyavuz)
- [#34511](https://github.com/apache/superset/pull/34511) fix(sqllab): show actual execution duration in Query History (@rusackas)
- [#34395](https://github.com/apache/superset/pull/34395) fix(superset-ui-core): Include appRoot in endpoint of SupersetClientClass.postForm action (@martyngigg)
- [#34304](https://github.com/apache/superset/pull/34304) fix(presto): return proper data type for column (@betodealmeida)
- [#32340](https://github.com/apache/superset/pull/32340) fix(security): grant TableSchemaView to only sql_lab role (@codenamelxl)
- [#33503](https://github.com/apache/superset/pull/33503) fix: activity table delta time (@natilehrer)
- [#33202](https://github.com/apache/superset/pull/33202) fix(open-api): Add missing FormatQueryPayloadSchema and DashboardScreenshotPostSchema to open-api component schemas (@dogfootruler-kr)
- [#32405](https://github.com/apache/superset/pull/32405) fix(daos/tag): prevent non-unique tags getting created along with unique ones (@hainenber)
- [#21083](https://github.com/apache/superset/pull/21083) fix(install): set SUPERSET_VERSION_RC at the right time (@Joel-Haeberli)
- [#34645](https://github.com/apache/superset/pull/34645) fix(webpack): webpack warnings (@gabotorresruiz)
- [#34005](https://github.com/apache/superset/pull/34005) fix: update Russian translations (@PolinaFam)
- [#34644](https://github.com/apache/superset/pull/34644) fix: Fix Slice import on has_drill_by_access (@Vitor-Avila)
- [#34641](https://github.com/apache/superset/pull/34641) fix: Slack channels and Color Palettes search (@Vitor-Avila)
- [#34584](https://github.com/apache/superset/pull/34584) fix(initialization): prevent startup failures when database tables don't   exist (@eschutho)
- [#34625](https://github.com/apache/superset/pull/34625) fix: Remove deprecated @types/classnames package (@rusackas)
- [#34602](https://github.com/apache/superset/pull/34602) fix(Dashboards): Tabs highlight and dataset contrast in darkmode issues (@rebenitez1802)
- [#34620](https://github.com/apache/superset/pull/34620) fix: Use labels in Drill to Detail (@Vitor-Avila)
- [#34636](https://github.com/apache/superset/pull/34636) fix(DatabaseModal): Don't set activeKey to undefined repeatedly (@msyavuz)
- [#33843](https://github.com/apache/superset/pull/33843) fix: Reset description height to zero when chart is not expanded (@abhinav-1305)
- [#34239](https://github.com/apache/superset/pull/34239) fix(Heatmap): addin x axis label rotation (@SBIN2010)
- [#34598](https://github.com/apache/superset/pull/34598) fix(db_engine_specs): generate correct boolean filter SQL syntax for Athena compatibility (@oscep)
- [#34582](https://github.com/apache/superset/pull/34582) fix(Timeshift): Determine temporal column correctly (@msyavuz)
- [#34580](https://github.com/apache/superset/pull/34580) fix(echart): broken aggregator due to bigint value (@justinpark)
- [#34569](https://github.com/apache/superset/pull/34569) fix: navigate to SQL Lab due to router api updates (@justinpark)
- [#34175](https://github.com/apache/superset/pull/34175) fix(Table chart): fix percentage metric column (@LevisNgigi)
- [#34541](https://github.com/apache/superset/pull/34541) fix(echarts): rename time series shifted without dimensions (@justinpark)
- [#34508](https://github.com/apache/superset/pull/34508) fix: update copy text for better capitalization and abbreviation standards (@yousoph)
- [#34556](https://github.com/apache/superset/pull/34556) fix(table chart): render bigint value in a raw mode (@justinpark)
- [#34507](https://github.com/apache/superset/pull/34507) fix(theming): More theming bugs/regressions (@msyavuz)
- [#34545](https://github.com/apache/superset/pull/34545) fix: Avoid null `scrollLeft` in `VirtualTable` (@Vitor-Avila)
- [#34528](https://github.com/apache/superset/pull/34528) fix(explore): Fix missing await for async buildV1ChartDataPayload calls (@mistercrunch)
- [#34539](https://github.com/apache/superset/pull/34539) fix(native filters): throws an error when a chart containing a bigint value (@justinpark)
- [#34512](https://github.com/apache/superset/pull/34512) fix(sqllab): prevent strings with angle brackets from being hidden (@rusackas)
- [#34520](https://github.com/apache/superset/pull/34520) fix: docs eslint command (@villebro)
- [#34516](https://github.com/apache/superset/pull/34516) fix(echart): initial chart animation (@justinpark)
- [#34438](https://github.com/apache/superset/pull/34438) fix: Update table chart configuration labels to sentence case (@yousoph)
- [#34435](https://github.com/apache/superset/pull/34435) fix(pie chart): Total now positioned correctly with all Legend positions, and respects theming (@rusackas)
- [#34436](https://github.com/apache/superset/pull/34436) fix(echarts): resolve bar chart X-axis time formatting stuck on adaptive (@rusackas)
- [#34424](https://github.com/apache/superset/pull/34424) fix(theming): Visual bugs p-3 (@msyavuz)
- [#34431](https://github.com/apache/superset/pull/34431) fix: time grain and DB dropdowns (@betodealmeida)
- [#34137](https://github.com/apache/superset/pull/34137) fix(dashboard): adds dependent filter select first value fixes (@ObservabilityTeam)
- [#34433](https://github.com/apache/superset/pull/34433) fix(migrations): prevent theme seeding before themes table exists (@mistercrunch)
- [#34412](https://github.com/apache/superset/pull/34412) fix: prevent anonymous code in Postgres (@betodealmeida)
- [#34411](https://github.com/apache/superset/pull/34411) fix(sqllab): access legacy kv record (@justinpark)
- [#31495](https://github.com/apache/superset/pull/31495) fix(sunburst): Fix sunburst chart cross-filter logic (@gerbermichi)
- [#34389](https://github.com/apache/superset/pull/34389) fix(theme-list): reorder buttons to place import leftmost (@mistercrunch)
- [#34178](https://github.com/apache/superset/pull/34178) fix: Console errors from various sources (@msyavuz)
- [#34390](https://github.com/apache/superset/pull/34390) fix(charts): Fix unquoted 'Others' literal in series limit GROUP BY clause (@mistercrunch)
- [#34296](https://github.com/apache/superset/pull/34296) fix(big number with trendline): running 2 identical queries for no good reason (@mistercrunch)
- [#34381](https://github.com/apache/superset/pull/34381) fix: rate limiting issues with example data hosted on github.com (@mistercrunch)
- [#34339](https://github.com/apache/superset/pull/34339) fix: prevent theme initialization errors during fresh installs (@mistercrunch)
- [#34360](https://github.com/apache/superset/pull/34360) fix: use catalog name on generated queries (@betodealmeida)
- [#34374](https://github.com/apache/superset/pull/34374) fix: subquery alias in RLS (@betodealmeida)
- [#34351](https://github.com/apache/superset/pull/34351) fix(PivotTable): Render html in cells if allowRenderHtml is true (@msyavuz)
- [#34318](https://github.com/apache/superset/pull/34318) fix(NavBar): Add brand text back (@geido)
- [#34315](https://github.com/apache/superset/pull/34315) fix: Charts list is displaying empty dataset names when there's no schema (@michael-s-molina)
- [#34268](https://github.com/apache/superset/pull/34268) fix(cartodiagram): add missing locales for rendering echarts (@jansule)
- [#34305](https://github.com/apache/superset/pull/34305) fix(npm): more reliable execution of `npm run update-maps` (@rusackas)
- [#34300](https://github.com/apache/superset/pull/34300) fix: preserve correct column order when table layout is changed with time comparison enabled (@payose)
- [#33084](https://github.com/apache/superset/pull/33084) fix: enhance disallowed SQL functions list for improved security (@sha174n)
- [#34303](https://github.com/apache/superset/pull/34303) fix: return 422 on invalid SQL (@betodealmeida)
- [#34237](https://github.com/apache/superset/pull/34237) fix(theming): Fix visual regressions from theming P7 (@EnxDev)
- [#34299](https://github.com/apache/superset/pull/34299) fix: address numerous long-standing console errors (python & web) (@mistercrunch)
- [#34293](https://github.com/apache/superset/pull/34293) fix: Hide View in SQL Lab for users without access (@Vitor-Avila)
- [#34233](https://github.com/apache/superset/pull/34233) fix(chart-download): ensure full table or handlebar chart is captured in image export (@fardin-developer)
- [#34213](https://github.com/apache/superset/pull/34213) fix(charting): correctly categorize numeric columns with NULL values (@LisaHusband)
- [#34289](https://github.com/apache/superset/pull/34289) fix: Saved queries list break if one query can't be parsed (@michael-s-molina)
- [#34235](https://github.com/apache/superset/pull/34235) fix(sqllab_export): manually encode CSV output to support utf-8-sig (@Habeeb556)
- [#34275](https://github.com/apache/superset/pull/34275) fix: fix the pre-commit hook for tsc (@mistercrunch)
- [#34244](https://github.com/apache/superset/pull/34244) fix(deckgl): fix deck.gl color breakpoints Control (@DamianPendrak)
- [#34282](https://github.com/apache/superset/pull/34282) fix: Bulk select is not respecting the TAGGING_SYSTEM feature flag (@michael-s-molina)
- [#34279](https://github.com/apache/superset/pull/34279) fix(theming): Visual regressions p2 (@msyavuz)
- [#34253](https://github.com/apache/superset/pull/34253) fix(theming): Theming visual fixes (@msyavuz)
- [#34272](https://github.com/apache/superset/pull/34272) fix: build issues on master with 'npm run dev' (@mistercrunch)
- [#34261](https://github.com/apache/superset/pull/34261) fix: Matching errorType on superset api error with SupersetError (@justinpark)
- [#34259](https://github.com/apache/superset/pull/34259) fix: Missing ownState and isCached props in Chart.jsx (@kgabryje)
- [#34126](https://github.com/apache/superset/pull/34126) fix: database model Collapse state  (@SBIN2010)
- [#34193](https://github.com/apache/superset/pull/34193) fix: bug when updating dashboard (@SBIN2010)
- [#34224](https://github.com/apache/superset/pull/34224) fix(Chart): Calculate chart height correctly (@msyavuz)
- [#34229](https://github.com/apache/superset/pull/34229) fix(theming): World map tooltip color (@msyavuz)
- [#34199](https://github.com/apache/superset/pull/34199) fix: proper handling of boolean filters with snowflake (@mistercrunch)
- [#33933](https://github.com/apache/superset/pull/33933) fix(dashboard): Fix subitem selection on dashboard download menu (@tahvane1)
- [#34218](https://github.com/apache/superset/pull/34218) fix(theming): Superset theme configurations correctly applying to charts (@gabotorresruiz)
- [#34192](https://github.com/apache/superset/pull/34192) fix: dataset endpoint `/rowlevelsecurity/related/tables` doesn't apply filters as expected (@mistercrunch)
- [#33450](https://github.com/apache/superset/pull/33450) fix(chart): update geographical info for latvia (@eriks47)
- [#34129](https://github.com/apache/superset/pull/34129) fix(explore): Display missing dataset for denied access (@justinpark)
- [#34188](https://github.com/apache/superset/pull/34188) fix(theming): Remove leftover antd5 prefix (@msyavuz)
- [#34181](https://github.com/apache/superset/pull/34181) fix(sqllab): database ID (@betodealmeida)
- [#34180](https://github.com/apache/superset/pull/34180) fix(databricks): string escaper (@betodealmeida)
- [#33955](https://github.com/apache/superset/pull/33955) fix(sqllab): pass DB id instead of name (@betodealmeida)
- [#34171](https://github.com/apache/superset/pull/34171) fix(DrillBy): make drill by work with multi metric charts (@msyavuz)
- [#34147](https://github.com/apache/superset/pull/34147) fix: adding and removing tags does not work in control panel properties modal (@SBIN2010)
- [#34118](https://github.com/apache/superset/pull/34118) fix: frontend translation framework crashes on string errors (@mistercrunch)
- [#34153](https://github.com/apache/superset/pull/34153) fix(dataset): trigger `onChange` when switching to physical dataset to clear SQL (@ongdisheng)
- [#34112](https://github.com/apache/superset/pull/34112) fix(DatabaseModal): Resolve Connect button issue for SQLAlchemy URI database connections (@EnxDev)
- [#34127](https://github.com/apache/superset/pull/34127) fix: Apply metric d3format when currency config is {} for table charts (@Vitor-Avila)
- [#33974](https://github.com/apache/superset/pull/33974) fix(i18n): Update Japanese translations (@aikawa-ohno)
- [#34114](https://github.com/apache/superset/pull/34114) fix(screenshots): Change default for `SCREENSHOT_PLAYWRIGHT_WAIT_EVENT` to `domcontentloaded` (@rusackas)
- [#34115](https://github.com/apache/superset/pull/34115) fix: make flask-cors a core dependency (@mistercrunch)
- [#34108](https://github.com/apache/superset/pull/34108) fix: improve login page placement and width (@mistercrunch)
- [#34113](https://github.com/apache/superset/pull/34113) fix(UI): Adjust background color for Dashboard, Tabs, and ListView component (@EnxDev)
- [#32734](https://github.com/apache/superset/pull/32734) fix: upload data model Collapse state (@SBIN2010)
- [#34103](https://github.com/apache/superset/pull/34103) fix(deps): Revert "chore(deps): update @deck.gl/aggregation-layers requirement from ^9.0.38 to ^9.1.12 in /superset-frontend/plugins/legacy-preset-chart-deckgl" (@DamianPendrak)
- [#34098](https://github.com/apache/superset/pull/34098) fix: Apply metric d3format from dataset when currency config is {} (@Vitor-Avila)
- [#34049](https://github.com/apache/superset/pull/34049) fix(translations): Fix language switching behavior when default language is not English (@PolinaFam)
- [#34090](https://github.com/apache/superset/pull/34090) fix(deps) : Revert "chore(deps-dev): bump webpack-dev-server from 4.15.2 to 5.2.1 (@msyavuz)
- [#34080](https://github.com/apache/superset/pull/34080) fix: Support metric currency as dict during import (@Vitor-Avila)
- [#34014](https://github.com/apache/superset/pull/34014) fix(Table): Allow timeshifts to be overriden (@msyavuz)
- [#34066](https://github.com/apache/superset/pull/34066) fix(styles): Remove custom z-indexes (@msyavuz)
- [#34074](https://github.com/apache/superset/pull/34074) fix: Annotation layer errors (@michael-s-molina)
- [#34018](https://github.com/apache/superset/pull/34018) fix: Update spacing on echart legends (@sadpandajoe)
- [#33954](https://github.com/apache/superset/pull/33954) fix(chart controls): remove duplicated descriptions for chart controls (@Quatters)
- [#34031](https://github.com/apache/superset/pull/34031) fix(styling): various minor visual tweaks and adjustments (@mistercrunch)
- [#33971](https://github.com/apache/superset/pull/33971) fix(dashboard): prevent crash on invalid CSS selectors in CSS templates (@HarshithGamini)
- [#33958](https://github.com/apache/superset/pull/33958) fix: Dashboard native filter fixes (@Vitor-Avila)
- [#34016](https://github.com/apache/superset/pull/34016) fix(handlebars): remove serverPaginationControlSetRow from control pa… (@LisaHusband)
- [#33977](https://github.com/apache/superset/pull/33977) fix(explore): Change dataset icon on explore to match datasets view (@xavier-GitHub76)
- [#33949](https://github.com/apache/superset/pull/33949) fix: Theme logo links to external superset site (@martimors)
- [#33939](https://github.com/apache/superset/pull/33939) fix(dremio): apply same fix as for drill to solve alias ambiguity (@mistercrunch)
- [#33942](https://github.com/apache/superset/pull/33942) fix(rls): removing unnecessary wrapper (@lohart13)
- [#32849](https://github.com/apache/superset/pull/32849) fix(plugin-chart-echarts): correct label position for Negative Values bar chart (@SBIN2010)
- [#32857](https://github.com/apache/superset/pull/32857) fix: add suffix to Drill labels to avoid collision (@fhyy)
- [#33916](https://github.com/apache/superset/pull/33916) fix: Consider default catalog when getting tables and view lists (@Vitor-Avila)
- [#33923](https://github.com/apache/superset/pull/33923) fix(fe/user_info): resolve visual oddities in User Info page (@hainenber)
- [#33898](https://github.com/apache/superset/pull/33898) fix(theming): Fix visual regressions from theming P6 (@EnxDev)
- [#33846](https://github.com/apache/superset/pull/33846) fix: Correct state handling in CSS Template modal (@abhinav-1305)
- [#33826](https://github.com/apache/superset/pull/33826) fix(DatabaseModal): Improve database modal validation and fix visual Issues (@EnxDev)
- [#33834](https://github.com/apache/superset/pull/33834) fix(native filters): Make the Apply button available after click on Clear All (@Vitor-Avila)
- [#33833](https://github.com/apache/superset/pull/33833) fix(api): Added uuid as a valid search column (@withnale)
- [#33867](https://github.com/apache/superset/pull/33867) fix(logo): fix logo url typo (@LevisNgigi)
- [#33849](https://github.com/apache/superset/pull/33849) fix: sqlglot linter (@betodealmeida)
- [#33764](https://github.com/apache/superset/pull/33764) fix: use risingwave as the sqlalchemy_uri_placeholder prefix for RisingWave engine (@hzxa21)
- [#33830](https://github.com/apache/superset/pull/33830) fix: Consider last data point for Big Number comparison lag (@Vitor-Avila)
- [#33821](https://github.com/apache/superset/pull/33821) fix: Set time filter's isExtra to false when saving as new chart (@Vitor-Avila)
- [#28737](https://github.com/apache/superset/pull/28737) fix: ensure numeric values for extra metadata_cache_timeout payloads (@kidusmakonnen)
- [#33763](https://github.com/apache/superset/pull/33763) fix: select star (@betodealmeida)
- [#33673](https://github.com/apache/superset/pull/33673) fix: clarify GUEST_TOKEN_JWT_AUDIENCE usage in the SDK (@schollz)
- [#33694](https://github.com/apache/superset/pull/33694) fix(chart): set tab name as chart name (@anthonyhungnguyen)
- [#33727](https://github.com/apache/superset/pull/33727) fix: typo in SQL dialect map (@betodealmeida)
- [#33523](https://github.com/apache/superset/pull/33523) fix(dataset): prevent metric duplication error when editing SQL and adding metric (@jqqin)
- [#33700](https://github.com/apache/superset/pull/33700) fix(compose): environment entries in compose*.yml override values in docker/.env (@denodo-research-labs)
- [#33693](https://github.com/apache/superset/pull/33693) fix: Do not convert dataset changed_on to UTC (@Vitor-Avila)
- [#33679](https://github.com/apache/superset/pull/33679) fix: optimize catalog permission sync when importing dashboards (@arafoperata)
- [#33626](https://github.com/apache/superset/pull/33626) fix: Update dataset's last modified date from column/metric update (@Vitor-Avila)
- [#33195](https://github.com/apache/superset/pull/33195) fix(sqllab): save datasets with template parameters (@ethan-l-geotab)
- [#33577](https://github.com/apache/superset/pull/33577) fix(Security): Apply permissions to the AllEntities list/get_objects API endpoint (@Vitor-Avila)
- [#33519](https://github.com/apache/superset/pull/33519) fix: add query identifier to legend items in mixed time series charts (@fardin-developer)
- [#33407](https://github.com/apache/superset/pull/33407) fix(big number with trendline): add None option to the aggregation method dropdown (@LevisNgigi)
- [#33586](https://github.com/apache/superset/pull/33586) fix: correct typos (@castodius)
- [#33559](https://github.com/apache/superset/pull/33559) fix(Radar): Radar chart normalisation (@amaannawab923)
- [#33516](https://github.com/apache/superset/pull/33516) fix: text => JSON migration util (@betodealmeida)
- [#33543](https://github.com/apache/superset/pull/33543) fix(Select): Add buttonStyle prop for backward compatibility (@geido)
- [#33521](https://github.com/apache/superset/pull/33521) fix(CI): adding explicit allowable licenses for python dependencies  (@rusackas)
- [#33501](https://github.com/apache/superset/pull/33501) fix: optimize Explore popovers rendering (@mistercrunch)
- [#33494](https://github.com/apache/superset/pull/33494) fix(table): table ui fixes (@amaannawab923)
- [#33475](https://github.com/apache/superset/pull/33475) fix(dependabot): adds required schedule to uv updates (@rusackas)
- [#33467](https://github.com/apache/superset/pull/33467) fix(NativeFilters): Apply existing values (@geido)
- [#33412](https://github.com/apache/superset/pull/33412) fix: loading examples in CI returns http error "too many requests" (@mistercrunch)
- [#33356](https://github.com/apache/superset/pull/33356) fix(embedded): handle SUPERSET_APP_ROOT in embedded dashboard URLs (@irodriguez-nebustream)
- [#33384](https://github.com/apache/superset/pull/33384) fix: Persist catalog change during dataset update + validation fixes (@Vitor-Avila)
- [#33271](https://github.com/apache/superset/pull/33271) fix: Exclude Filter Values (@amaannawab923)
- [#33363](https://github.com/apache/superset/pull/33363) fix: bump FAB to 4.6.3 (@dpgaspar)
- [#33338](https://github.com/apache/superset/pull/33338) fix: show only filterable columns on filter dropdown (@betodealmeida)
- [#33254](https://github.com/apache/superset/pull/33254) fix: `Unexpected input(s) 'depth'` CI warnings (@hamirmahal)
- [#33196](https://github.com/apache/superset/pull/33196) fix(chart): Restore subheader used in bignumber with trendline (@LevisNgigi)
- [#33205](https://github.com/apache/superset/pull/33205) fix(Native Filters): Keep default filter values when configuring creatable behavior (@geido)
- [#33205](https://github.com/apache/superset/pull/33205) fix(Native Filters): Keep default filter values when configuring creatable behavior (@geido)
- [#33172](https://github.com/apache/superset/pull/33172) fix: subheader should show as subtitle (@eschutho)
- [#33142](https://github.com/apache/superset/pull/33142) fix: add folders to import schema (@eschutho)
- [#33141](https://github.com/apache/superset/pull/33141) fix: app icon should not use subdirectory (@eschutho)
- [#33126](https://github.com/apache/superset/pull/33126) fix(plugin-chart-table): Don't render redundant items in column config when time comparison is enabled (@kgabryje)
- [#33124](https://github.com/apache/superset/pull/33124) fix: `master` builds are failing while trying to push report to cypress (@mistercrunch)
- [#33100](https://github.com/apache/superset/pull/33100) fix(OAuth2): Update connection should not fail if connection is missing OAuth2 token (@Vitor-Avila)
- [#33114](https://github.com/apache/superset/pull/33114) fix: Broken menu links to datasets and sql lab (@kgabryje)
- [#33092](https://github.com/apache/superset/pull/33092) fix: CI file change detector to handle large PRs (@mistercrunch)
- [#33095](https://github.com/apache/superset/pull/33095) fix: Broken Python tests on master after merging prefix branch (@martyngigg)
- [#33063](https://github.com/apache/superset/pull/33063) fix(docs): Update quickstart.mdx to reflect latest version tag (@clayheaton)
- [#33060](https://github.com/apache/superset/pull/33060) fix(list roles): dont send invalid querystrings (@landryb)
- [#32990](https://github.com/apache/superset/pull/32990) fix(frontend): add missing antd-5 icon to import (@trentlavoie)
- [#32866](https://github.com/apache/superset/pull/32866) fix: make packages PEP 625 compliant (@sadpandajoe)
- [#32848](https://github.com/apache/superset/pull/32848) fix: Bump FAB to 4.6.1 (@michael-s-molina)
- [#32801](https://github.com/apache/superset/pull/32801) fix(docs): scrollable table of content right bar in Superset docs (@hainenber)
- [#32732](https://github.com/apache/superset/pull/32732) fix(asf): Revert "Revert "fix(asf): moving notifications to the top of `.asf.yaml`"" (@rusackas)
- [#32730](https://github.com/apache/superset/pull/32730) fix(asf): Revert "fix(asf): moving notifications to the top of `.asf.yaml`" (@rusackas)
- [#32728](https://github.com/apache/superset/pull/32728) fix(docs): Another CSP hole for run.app to allow Kapa AI (@rusackas)
- [#32727](https://github.com/apache/superset/pull/32727) fix(docs): poking ANOTHER hole in the CSP for the AI bot. (@rusackas)
- [#32726](https://github.com/apache/superset/pull/32726) fix(asf): moving notifications to the top of `.asf.yaml` (@rusackas)
- [#32724](https://github.com/apache/superset/pull/32724) fix(docs): allow recaptcha in CSP (@rusackas)
- [#32713](https://github.com/apache/superset/pull/32713) fix(docs): Fixes scrolling issue with AI widget on docs site (@rusackas)
- [#32702](https://github.com/apache/superset/pull/32702) fix(file uploads): List only allowed schemas in the file uploads dialog (@Vitor-Avila)
- [#32703](https://github.com/apache/superset/pull/32703) fix(repo): re-enable GitHub Discussions (@rusackas)
- [#32704](https://github.com/apache/superset/pull/32704) fix(docs): poking a CSP hole for Kapa AI widget (@rusackas)
- [#32571](https://github.com/apache/superset/pull/32571) fix(no-restricted-imports): Fix overrides and include no-fa-icons-usage (@geido)
- [#32658](https://github.com/apache/superset/pull/32658) fix(sync perms): Avoid UnboundLocalError during perm sync for DBs that don't support catalogs (@Vitor-Avila)
- [#32381](https://github.com/apache/superset/pull/32381) fix(sqllab): Grid header menu (@justinpark)
- [#32553](https://github.com/apache/superset/pull/32553) fix(comp/async-ace-editor): proper import of `ace-builds` (@hainenber)
- [#32525](https://github.com/apache/superset/pull/32525) fix: always extract query source from request (@villebro)
- [#32481](https://github.com/apache/superset/pull/32481) fix(docker compose): replace port 8088 with 9000 (@jpchev)
- [#32401](https://github.com/apache/superset/pull/32401) fix: prevent nested transactions (@betodealmeida)
- [#32377](https://github.com/apache/superset/pull/32377) fix: ephemeral CI fetching task ENI (@dpgaspar)
- [#32333](https://github.com/apache/superset/pull/32333) fix(eslint-hook): ensure eslint hook receives arguments (@alveifbklsiu259)
- [#32274](https://github.com/apache/superset/pull/32274) fix(sec): resolve Dependabot security alerts (@hainenber)
- [#32018](https://github.com/apache/superset/pull/32018) fix: false negative on critical security related to eslint-plugin-translation-vars (@mistercrunch)

**Others**

- [#36171](https://github.com/apache/superset/pull/36171) chore: bump duckdb et al. (@betodealmeida)
- [#36177](https://github.com/apache/superset/pull/36177) chore(docs): config Kapa to use logo from the repo (@rusackas)
- [#35918](https://github.com/apache/superset/pull/35918) test(useThemeMenuItems): fix race conditions by awaiting all userEvent calls (@sadpandajoe)
- [#35895](https://github.com/apache/superset/pull/35895) chore: bump shillelagh to 1.4.3 (@betodealmeida)
- [#35809](https://github.com/apache/superset/pull/35809) docs(db_engine_specs): restructure feature table for GitHub rendering (@sadpandajoe)
- [#35176](https://github.com/apache/superset/pull/35176) chore: bump sqlglot to 27.15.2 (@betodealmeida)
- [#34838](https://github.com/apache/superset/pull/34838) chore: bump FAB to 4.8.1 (@dpgaspar)
- [#34800](https://github.com/apache/superset/pull/34800) chore: Add instruction for LLMs to use antd theme tokens (@kgabryje)
- [#34693](https://github.com/apache/superset/pull/34693) chore(deps): downgrade pyarrow to v16 (@drummerwolli)
- [#34701](https://github.com/apache/superset/pull/34701) docs: CVEs added to 5.0.0 and 4.1.3 documentation (@sha174n)
- [#34606](https://github.com/apache/superset/pull/34606) refactor: Migrate ExploreChartPanel to typescript (@justinpark)
- [#32663](https://github.com/apache/superset/pull/32663) chore: add more csv tests (@eschutho)
- [#34653](https://github.com/apache/superset/pull/34653) chore: Increase memory limit on webpack ts checker plugin (@kgabryje)
- [#34460](https://github.com/apache/superset/pull/34460) chore(deps-dev): bump eslint-import-resolver-typescript from 3.7.0 to 4.4.4 in /superset-frontend (@dependabot[bot])
- [#34581](https://github.com/apache/superset/pull/34581) chore(deps): bump tmp from 0.2.1 to 0.2.4 in /superset-frontend/cypress-base (@dependabot[bot])
- [#34646](https://github.com/apache/superset/pull/34646) chore(deps): bump tmp and inquirer in /superset-frontend (@dependabot[bot])
- [#34536](https://github.com/apache/superset/pull/34536) chore: Refactor Menu.Item and cleanup console errors (@geido)
- [#34481](https://github.com/apache/superset/pull/34481) chore(deps): bump googleapis from 130.0.0 to 154.1.0 in /superset-frontend (@dependabot[bot])
- [#34442](https://github.com/apache/superset/pull/34442) chore: add tests to DatabaseConnectionForm/EncryptedField (@sadpandajoe)
- [#34450](https://github.com/apache/superset/pull/34450) chore(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#34448](https://github.com/apache/superset/pull/34448) chore(deps-dev): bump @types/node from 22.10.3 to 24.1.0 in /superset-websocket (@dependabot[bot])
- [#33889](https://github.com/apache/superset/pull/33889) chore(helm): bump app version to 5.0.0 (@brandon-kaplan)
- [#34452](https://github.com/apache/superset/pull/34452) chore(deps-dev): bump globals from 16.0.0 to 16.3.0 in /superset-websocket (@dependabot[bot])
- [#34453](https://github.com/apache/superset/pull/34453) chore(deps): update re-resizable requirement from ^6.10.1 to ^6.11.2 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#34468](https://github.com/apache/superset/pull/34468) chore(deps): update @deck.gl/aggregation-layers requirement from ^9.1.13 to ^9.1.14 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#34464](https://github.com/apache/superset/pull/34464) chore(deps-dev): bump @babel/runtime-corejs3 from 7.26.7 to 7.28.2 in /superset-frontend (@dependabot[bot])
- [#34462](https://github.com/apache/superset/pull/34462) chore(deps-dev): update jest requirement from ^30.0.4 to ^30.0.5 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#34451](https://github.com/apache/superset/pull/34451) chore(deps-dev): update @types/prop-types requirement from ^15.7.2 to ^15.7.15 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#34457](https://github.com/apache/superset/pull/34457) chore(deps-dev): update jest requirement from ^30.0.4 to ^30.0.5 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#34461](https://github.com/apache/superset/pull/34461) chore(deps): bump @deck.gl/react from 9.1.13 to 9.1.14 in /superset-frontend (@dependabot[bot])
- [#34501](https://github.com/apache/superset/pull/34501) chore(deps-dev): update jest requirement from ^30.0.4 to ^30.0.5 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#34472](https://github.com/apache/superset/pull/34472) chore(deps): bump @babel/runtime from 7.26.10 to 7.28.2 in /superset-frontend (@dependabot[bot])
- [#34454](https://github.com/apache/superset/pull/34454) chore(deps-dev): bump eslint-config-prettier from 10.1.5 to 10.1.8 in /superset-websocket (@dependabot[bot])
- [#34474](https://github.com/apache/superset/pull/34474) chore(deps): bump react-draggable from 4.4.6 to 4.5.0 in /superset-frontend (@dependabot[bot])
- [#34483](https://github.com/apache/superset/pull/34483) chore(deps): bump react-lines-ellipsis from 0.15.4 to 0.16.1 in /superset-frontend (@dependabot[bot])
- [#34492](https://github.com/apache/superset/pull/34492) chore(deps-dev): bump eslint from 9.31.0 to 9.32.0 in /docs (@dependabot[bot])
- [#34493](https://github.com/apache/superset/pull/34493) chore(deps-dev): bump typescript-eslint from 8.37.0 to 8.38.0 in /docs (@dependabot[bot])
- [#34502](https://github.com/apache/superset/pull/34502) chore(deps): update react requirement from ^19.1.0 to ^19.1.1 in /superset-frontend/plugins/legacy-plugin-chart-chord (@dependabot[bot])
- [#34487](https://github.com/apache/superset/pull/34487) chore(deps): bump @rjsf/validator-ajv8 from 5.24.9 to 5.24.12 in /superset-frontend (@dependabot[bot])
- [#34489](https://github.com/apache/superset/pull/34489) chore(deps-dev): bump @babel/preset-react from 7.26.3 to 7.27.1 in /superset-frontend (@dependabot[bot])
- [#34496](https://github.com/apache/superset/pull/34496) chore(deps-dev): bump eslint-plugin-prettier from 5.5.1 to 5.5.3 in /docs (@dependabot[bot])
- [#34544](https://github.com/apache/superset/pull/34544) chore: Rename dataset creation buttons (@Vitor-Avila)
- [#34515](https://github.com/apache/superset/pull/34515) chore(core): Add drawer to core ui components (@justinpark)
- [#34444](https://github.com/apache/superset/pull/34444) chore(deps): update gh-pages requirement from ^6.2.0 to ^6.3.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#34478](https://github.com/apache/superset/pull/34478) chore(deps-dev): bump @types/classnames from 2.3.0 to 2.3.4 in /superset-frontend (@dependabot[bot])
- [#34482](https://github.com/apache/superset/pull/34482) chore(deps): bump dom-to-image-more from 3.5.0 to 3.6.0 in /superset-frontend (@dependabot[bot])
- [#34480](https://github.com/apache/superset/pull/34480) chore(deps): bump @deck.gl/core from 9.1.13 to 9.1.14 in /superset-frontend (@dependabot[bot])
- [#34484](https://github.com/apache/superset/pull/34484) chore(deps-dev): bump tsx from 4.19.4 to 4.20.3 in /superset-frontend (@dependabot[bot])
- [#34485](https://github.com/apache/superset/pull/34485) chore(deps-dev): bump @babel/compat-data from 7.27.2 to 7.28.0 in /superset-frontend (@dependabot[bot])
- [#34494](https://github.com/apache/superset/pull/34494) chore(deps): bump less from 4.3.0 to 4.4.0 in /docs (@dependabot[bot])
- [#34495](https://github.com/apache/superset/pull/34495) chore(deps): bump antd from 5.26.3 to 5.26.7 in /docs (@dependabot[bot])
- [#34497](https://github.com/apache/superset/pull/34497) chore(deps-dev): bump @eslint/js from 9.31.0 to 9.32.0 in /docs (@dependabot[bot])
- [#34498](https://github.com/apache/superset/pull/34498) chore(deps): bump swagger-ui-react from 5.26.0 to 5.27.1 in /docs (@dependabot[bot])
- [#34499](https://github.com/apache/superset/pull/34499) chore(deps-dev): bump eslint-config-prettier from 10.1.5 to 10.1.8 in /docs (@dependabot[bot])
- [#34500](https://github.com/apache/superset/pull/34500) chore(deps-dev): bump webpack from 5.99.9 to 5.101.0 in /docs (@dependabot[bot])
- [#34459](https://github.com/apache/superset/pull/34459) chore(deps): bump actions/first-interaction from 1 to 2 (@dependabot[bot])
- [#34393](https://github.com/apache/superset/pull/34393) chore: update chart list e2e and component tests (@sadpandajoe)
- [#34039](https://github.com/apache/superset/pull/34039) chore(deps-dev): update jest requirement from ^30.0.2 to ^30.0.4 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#34432](https://github.com/apache/superset/pull/34432) chore: Change button labels to sentence case (@kasiazjc)
- [#34429](https://github.com/apache/superset/pull/34429) chore: Add bottom border to top navigation menu (@kasiazjc)
- [#30119](https://github.com/apache/superset/pull/30119) build(deps): bump reselect from 4.1.7 to 5.1.1 in /superset-frontend (@dependabot[bot])
- [#31534](https://github.com/apache/superset/pull/31534) chore(deps): bump d3-scale from 3.3.0 to 4.0.2 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#34391](https://github.com/apache/superset/pull/34391) docs(development): fix comment in the dockerfile (@harikirank)
- [#34387](https://github.com/apache/superset/pull/34387) docs(development): fix typo in the dockerfile (@harikirank)
- [#34335](https://github.com/apache/superset/pull/34335) chore(deps): bump cookie and @types/cookie in /superset-websocket (@dependabot[bot])
- [#34326](https://github.com/apache/superset/pull/34326) build(deps): update `ag-grid` to non-breaking major v34 (@hainenber)
- [#34341](https://github.com/apache/superset/pull/34341) docs(development): fix 2 typos in the dockerfile (@harikirank)
- [#34371](https://github.com/apache/superset/pull/34371) chore: bump BigQuery dialect to 1.15.0 (@betodealmeida)
- [#34317](https://github.com/apache/superset/pull/34317) style(FastVizSwitcher): Adjust padding for FastVizSwitcher selector (@EnxDev)
- [#34311](https://github.com/apache/superset/pull/34311) style(chart): restyle table pagination (@imcewen02)
- [#34302](https://github.com/apache/superset/pull/34302) chore: bump sqlglot to latest version (27.3.0) (@betodealmeida)
- [#34270](https://github.com/apache/superset/pull/34270) chore: improve sqlglot parsing (@betodealmeida)
- [#34288](https://github.com/apache/superset/pull/34288) chore: remove supposedly dev dep `html-webpack-plugin` from lockfile (@hainenber)
- [#33997](https://github.com/apache/superset/pull/33997) chore(deps-dev): bump prettier from 3.5.3 to 3.6.2 in /superset-frontend (@dependabot[bot])
- [#34285](https://github.com/apache/superset/pull/34285) chore(deps): bump axios from 1.10.0 to 1.11.0 in /docs (@dependabot[bot])
- [#34067](https://github.com/apache/superset/pull/34067) style(Button): Vertically align icons across all buttons (@EnxDev)
- [#34146](https://github.com/apache/superset/pull/34146) chore(docker): use editable mode in docker images (@mistercrunch)
- [#34262](https://github.com/apache/superset/pull/34262) chore(deps-dev): bump form-data from 4.0.0 to 4.0.4 in /superset-embedded-sdk (@dependabot[bot])
- [#34263](https://github.com/apache/superset/pull/34263) chore(deps): bump form-data from 4.0.0 to 4.0.4 in /docs (@dependabot[bot])
- [#34265](https://github.com/apache/superset/pull/34265) chore(deps): bump form-data from 4.0.1 to 4.0.4 in /superset-frontend (@dependabot[bot])
- [#34215](https://github.com/apache/superset/pull/34215) chore(deps): bump on-headers and morgan in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#34216](https://github.com/apache/superset/pull/34216) chore(deps): bump on-headers and compression in /superset-frontend (@dependabot[bot])
- [#34217](https://github.com/apache/superset/pull/34217) chore: Updates files related to 4.1.3 release (@sadpandajoe)
- [#33736](https://github.com/apache/superset/pull/33736) style(helm): Minor reformatting of helm chart templates (@dnskr)
- [#34179](https://github.com/apache/superset/pull/34179) chore(Oracle): Update oracle column length to 128 (@msyavuz)
- [#34163](https://github.com/apache/superset/pull/34163) docs(development): Fix typo in the documentation (@harikirank)
- [#34149](https://github.com/apache/superset/pull/34149) chore(Tags): Sort tags by name if possible (@msyavuz)
- [#34145](https://github.com/apache/superset/pull/34145) docs: remove duplicated line in `Running tests with act` section (@ongdisheng)
- [#34125](https://github.com/apache/superset/pull/34125) build(dev-deps): clean up deprecated Babel proposal plugins (@hainenber)
- [#34138](https://github.com/apache/superset/pull/34138) chore(deps): bump flask-cors from 4.0.2 to 6.0.0 (@dependabot[bot])
- [#34139](https://github.com/apache/superset/pull/34139) chore: remove unnecessary disables (@betodealmeida)
- [#33990](https://github.com/apache/superset/pull/33990) chore(deps): bump react-json-tree from 0.17.0 to 0.20.0 in /superset-frontend (@dependabot[bot])
- [#33486](https://github.com/apache/superset/pull/33486) chore(deps): bump react-error-boundary from 5.0.0 to 6.0.0 in /superset-frontend (@dependabot[bot])
- [#34093](https://github.com/apache/superset/pull/34093) chore: clean up more flask/jinja html views (@mistercrunch)
- [#34097](https://github.com/apache/superset/pull/34097) chore: Improve performance to load chart's save modal (@Vitor-Avila)
- [#34079](https://github.com/apache/superset/pull/34079) chore: Improve performance to load the chart properties modal (@Vitor-Avila)
- [#34104](https://github.com/apache/superset/pull/34104) chore(deps-dev): bump webpack-dev-server from 4.15.2 to 5.2.1 in /superset-frontend (@dependabot[bot])
- [#34057](https://github.com/apache/superset/pull/34057) chore: move auth e2e tests to component tests (@sadpandajoe)
- [#34042](https://github.com/apache/superset/pull/34042) chore(deps): bump @fontsource/inter from 5.1.1 to 5.2.6 in /superset-frontend (@dependabot[bot])
- [#34029](https://github.com/apache/superset/pull/34029) chore(deps): bump ioredis from 4.28.5 to 5.6.1 in /superset-websocket (@dependabot[bot])
- [#34075](https://github.com/apache/superset/pull/34075) chore: Use select_columns on chart's dashboard filter (@Vitor-Avila)
- [#34028](https://github.com/apache/superset/pull/34028) chore: refactor react-syntax-highlither to handle dark themes (@mistercrunch)
- [#34056](https://github.com/apache/superset/pull/34056) chore: remove some of the deprecated theme.colors.* (@mistercrunch)
- [#34059](https://github.com/apache/superset/pull/34059) chore(deps): bump tar-fs from 2.1.2 to 3.1.0 in /superset-frontend (@dependabot[bot])
- [#32928](https://github.com/apache/superset/pull/32928) chore(deps): update yeoman-generator requirement from ^7.4.0 to ^7.5.1 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#32949](https://github.com/apache/superset/pull/32949) chore(deps): bump react from 17.0.2 to 19.1.0 in /superset-frontend/plugins/legacy-plugin-chart-chord (@dependabot[bot])
- [#33481](https://github.com/apache/superset/pull/33481) chore(deps-dev): update fork-ts-checker-webpack-plugin requirement from ^9.0.2 to ^9.1.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#33485](https://github.com/apache/superset/pull/33485) chore(deps): update @deck.gl/aggregation-layers requirement from ^9.0.38 to ^9.1.12 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#32946](https://github.com/apache/superset/pull/32946) chore(deps-dev): bump webpack-dev-server from 4.15.2 to 5.2.1 in /superset-frontend (@dependabot[bot])
- [#33986](https://github.com/apache/superset/pull/33986) chore(deps-dev): bump @types/jest from 29.5.14 to 30.0.0 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#33496](https://github.com/apache/superset/pull/33496) chore(deps-dev): bump yeoman-test from 8.3.0 to 10.1.1 in /superset-frontend (@dependabot[bot])
- [#33995](https://github.com/apache/superset/pull/33995) chore(deps): bump @storybook/addon-actions from 8.1.11 to 9.0.8 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#32441](https://github.com/apache/superset/pull/32441) chore(deps): update @types/d3-scale requirement from ^4.0.8 to ^4.0.9 in /superset-frontend/plugins/plugin-chart-word-cloud (@dependabot[bot])
- [#32082](https://github.com/apache/superset/pull/32082) chore(deps): update dompurify requirement from ^3.2.4 to ^3.2.6 in /superset-frontend/plugins/legacy-preset-chart-nvd3 (@dependabot[bot])
- [#32945](https://github.com/apache/superset/pull/32945) chore(deps): bump remark-gfm from 3.0.1 to 4.0.1 in /superset-frontend (@dependabot[bot])
- [#32953](https://github.com/apache/superset/pull/32953) chore(deps): bump @ant-design/icons from 5.6.1 to 6.0.0 in /docs (@dependabot[bot])
- [#32439](https://github.com/apache/superset/pull/32439) chore(deps-dev): bump typescript from 5.6.2 to 5.7.3 in /superset-websocket (@dependabot[bot])
- [#32080](https://github.com/apache/superset/pull/32080) chore(deps-dev): update @types/lodash requirement from ^4.17.16 to ^4.17.20 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#33991](https://github.com/apache/superset/pull/33991) chore(deps-dev): bump cheerio from 1.0.0-rc.10 to 1.1.0 in /superset-frontend (@dependabot[bot])
- [#33989](https://github.com/apache/superset/pull/33989) chore(deps-dev): bump webpack-visualizer-plugin2 from 1.1.0 to 1.2.0 in /superset-frontend (@dependabot[bot])
- [#32093](https://github.com/apache/superset/pull/32093) chore(deps-dev): update fs-extra requirement from ^11.2.0 to ^11.3.0 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#32077](https://github.com/apache/superset/pull/32077) chore(deps): update @types/geojson requirement from ^7946.0.15 to ^7946.0.16 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#31560](https://github.com/apache/superset/pull/31560) chore(deps): bump @emotion/styled from 11.3.0 to 11.14.0 in /superset-frontend (@dependabot[bot])
- [#34034](https://github.com/apache/superset/pull/34034) chore(deps-dev): update jest requirement from ^30.0.2 to ^30.0.4 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#34036](https://github.com/apache/superset/pull/34036) chore(deps-dev): update jest requirement from ^30.0.2 to ^30.0.4 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#34037](https://github.com/apache/superset/pull/34037) chore(deps-dev): update @types/lodash requirement from ^4.17.16 to ^4.17.20 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#34038](https://github.com/apache/superset/pull/34038) chore(deps-dev): update @babel/types requirement from ^7.26.9 to ^7.28.0 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#34043](https://github.com/apache/superset/pull/34043) chore(deps): bump ace-builds from 1.43.0 to 1.43.1 in /superset-frontend (@dependabot[bot])
- [#34008](https://github.com/apache/superset/pull/34008) chore(deps): bump mapbox-gl from 2.15.0 to 3.13.0 in /superset-frontend (@dependabot[bot])
- [#34035](https://github.com/apache/superset/pull/34035) chore(deps-dev): bump @types/lodash from 4.17.13 to 4.17.20 in /superset-websocket (@dependabot[bot])
- [#33992](https://github.com/apache/superset/pull/33992) chore(deps): bump @emotion/styled from 11.14.0 to 11.14.1 in /superset-frontend (@dependabot[bot])
- [#33987](https://github.com/apache/superset/pull/33987) chore(deps-dev): bump @applitools/eyes-storybook from 3.53.4 to 3.55.6 in /superset-frontend (@dependabot[bot])
- [#34033](https://github.com/apache/superset/pull/34033) chore(deps-dev): bump prettier from 3.4.2 to 3.6.2 in /superset-websocket (@dependabot[bot])
- [#34041](https://github.com/apache/superset/pull/34041) chore(deps): bump swagger-ui-react from 5.25.3 to 5.26.0 in /docs (@dependabot[bot])
- [#33979](https://github.com/apache/superset/pull/33979) build(dev-deps): upgrade Jest to major version v30 (@hainenber)
- [#34004](https://github.com/apache/superset/pull/34004) chore(deps): bump hot-shots from 10.2.1 to 11.1.0 in /superset-websocket (@dependabot[bot])
- [#34003](https://github.com/apache/superset/pull/34003) chore(deps-dev): bump @docusaurus/tsconfig from 3.8.0 to 3.8.1 in /docs (@dependabot[bot])
- [#34002](https://github.com/apache/superset/pull/34002) chore(deps): bump ace-builds from 1.41.0 to 1.43.0 in /superset-frontend (@dependabot[bot])
- [#34001](https://github.com/apache/superset/pull/34001) chore(deps): bump swagger-ui-react from 5.25.2 to 5.25.3 in /docs (@dependabot[bot])
- [#34000](https://github.com/apache/superset/pull/34000) chore(deps-dev): bump eslint from 9.27.0 to 9.30.0 in /superset-websocket (@dependabot[bot])
- [#33985](https://github.com/apache/superset/pull/33985) chore(deps-dev): bump @babel/cli from 7.26.4 to 7.27.2 in /superset-frontend (@dependabot[bot])
- [#33999](https://github.com/apache/superset/pull/33999) chore(deps): bump actions/cache from 3 to 4 (@dependabot[bot])
- [#33982](https://github.com/apache/superset/pull/33982) chore(deps): bump antd from 5.25.1 to 5.26.3 in /docs (@dependabot[bot])
- [#33967](https://github.com/apache/superset/pull/33967) chore: replace `querystring` usage with native `URLSearchParams` API (@hainenber)
- [#33972](https://github.com/apache/superset/pull/33972) docs: Fix typo in UPDATING.md regarding translations in version 5.0.0 (@hugo19941994)
- [#33978](https://github.com/apache/superset/pull/33978) chore: pin Marshmallow < 4 (@betodealmeida)
- [#33887](https://github.com/apache/superset/pull/33887) chore(build): refactor plugin build script to remove unused stanzas (@hainenber)
- [#32891](https://github.com/apache/superset/pull/32891) docs: pypi-installation on Ubuntu 24.04 and statsd package for event-logging (@125m125)
- [#33934](https://github.com/apache/superset/pull/33934) chore(translations): Update FR language (@Eric-Brison)
- [#33927](https://github.com/apache/superset/pull/33927) build(be/deps): upgrade `urllib3` to major v2 (@hainenber)
- [#33936](https://github.com/apache/superset/pull/33936) docs(security): add Q&A related to CVE scans to FAQ (@sfirke)
- [#33910](https://github.com/apache/superset/pull/33910) chore(superset-embedded-sdk): bump version for theming (@msyavuz)
- [#33909](https://github.com/apache/superset/pull/33909) style(AsyncAceEditor): make Ace gutter line color theme-aware (@EnxDev)
- [#33872](https://github.com/apache/superset/pull/33872) chore(docs): bump references to docker image versions upon release of 5.0.0 (@sfirke)
- [#33869](https://github.com/apache/superset/pull/33869) chore: Updates files related to 5.0.0 release (@michael-s-molina)
- [#33868](https://github.com/apache/superset/pull/33868) build(be/deps): replace `importlib_metadata` usage with native  Python 3.10+ `importlib.metadata`  (@hainenber)
- [#33854](https://github.com/apache/superset/pull/33854) build(dev-deps): update `fetch-mock` to v11 (@hainenber)
- [#33853](https://github.com/apache/superset/pull/33853) build(deps): remove legacy browser polyfills (@hainenber)
- [#33866](https://github.com/apache/superset/pull/33866) chore(Icons): Add UsergroupAddOutlined icon (@EnxDev)
- [#33850](https://github.com/apache/superset/pull/33850) style(menu): Reduce bottom border width of menu item (@EnxDev)
- [#33848](https://github.com/apache/superset/pull/33848) chore: use mysql dialect for Pinot (@betodealmeida)
- [#33790](https://github.com/apache/superset/pull/33790) refactor: rename docker-compose files and update references (@polRk)
- [#33670](https://github.com/apache/superset/pull/33670) docs: Update STANDARD_ROLES.md, delete 7 permissions "RowLevelSecurityFiltersModelView" (@xavier-GitHub76)
- [#33642](https://github.com/apache/superset/pull/33642) chore(deps-dev): bump @docusaurus/module-type-aliases from 3.7.0 to 3.8.0 in /docs (@dependabot[bot])
- [#33818](https://github.com/apache/superset/pull/33818) chore(docs): resolve 3 vulnerabilities (@hainenber)
- [#33795](https://github.com/apache/superset/pull/33795) chore(🦾): bump python flask-caching subpackage(s) (@github-actions[bot])
- [#33798](https://github.com/apache/superset/pull/33798) chore(🦾): bump python sqlglot 26.17.1 -> 26.28.1 (@github-actions[bot])
- [#33792](https://github.com/apache/superset/pull/33792) chore(🦾): bump python flask-session subpackage(s) (@github-actions[bot])
- [#33793](https://github.com/apache/superset/pull/33793) chore(🦾): bump python shillelagh subpackage(s) (@github-actions[bot])
- [#33799](https://github.com/apache/superset/pull/33799) chore(🦾): bump python flask-wtf subpackage(s) (@github-actions[bot])
- [#33797](https://github.com/apache/superset/pull/33797) chore(🦾): bump python flask subpackage(s) (@github-actions[bot])
- [#33796](https://github.com/apache/superset/pull/33796) chore(🦾): bump python click 8.2.0 -> 8.2.1 (@github-actions[bot])
- [#33800](https://github.com/apache/superset/pull/33800) chore(🦾): bump python flask-compress subpackage(s) (@github-actions[bot])
- [#32587](https://github.com/apache/superset/pull/32587) refactor(Menu): Use items prop instead of deprecated Menu.Item HOC (@msyavuz)
- [#26803](https://github.com/apache/superset/pull/26803) chore: add pylint rule for SQL importing (SIP-117) (@betodealmeida)
- [#33396](https://github.com/apache/superset/pull/33396) chore(Accessibility): Improve keyboard navigation and screen access (@geido)
- [#33767](https://github.com/apache/superset/pull/33767) chore: auto-focus modal input when deleting assets (@betodealmeida)
- [#33696](https://github.com/apache/superset/pull/33696) chore: Convert alert and report cypress tests to component tests (@sadpandajoe)
- [#33643](https://github.com/apache/superset/pull/33643) chore(deps-dev): bump webpack from 5.99.8 to 5.99.9 in /docs (@dependabot[bot])
- [#33645](https://github.com/apache/superset/pull/33645) chore(deps-dev): bump @docusaurus/tsconfig from 3.7.0 to 3.8.0 in /docs (@dependabot[bot])
- [#33650](https://github.com/apache/superset/pull/33650) chore(deps-dev): bump @typescript-eslint/parser from 8.29.0 to 8.33.0 in /superset-websocket (@dependabot[bot])
- [#33341](https://github.com/apache/superset/pull/33341) chore(explore): Add format sql and view in SQL Lab option in View Query (@justinpark)
- [#33721](https://github.com/apache/superset/pull/33721) docs: fix typo and improve alt text in README (@lourduradjou)
- [#33715](https://github.com/apache/superset/pull/33715) chore: delete remaining Enzyme tests (@mistercrunch)
- [#33714](https://github.com/apache/superset/pull/33714) docs: clarify how `requirements/` should be modified (@mistercrunch)
- [#33704](https://github.com/apache/superset/pull/33704) chore: remove unused parameter (@betodealmeida)
- [#33701](https://github.com/apache/superset/pull/33701) chore: update sqlglot dialect map (@betodealmeida)
- [#33661](https://github.com/apache/superset/pull/33661) chore: simplify query cleanup using dict.pop instead of suppressing exception (@dpgaspar)
- [#33568](https://github.com/apache/superset/pull/33568) chore: 100% test coverage for SQL parsing (@betodealmeida)
- [#33665](https://github.com/apache/superset/pull/33665) docs: add HPE to users list (@anmol-hpe)
- [#33662](https://github.com/apache/superset/pull/33662) docs: CVE-2025-48912 added to 4.1.2 (@sha174n)
- [#33619](https://github.com/apache/superset/pull/33619) chore: make DB syntax errors 400 (@betodealmeida)
- [#33622](https://github.com/apache/superset/pull/33622) chore(deps-dev): bump fastify from 4.29.0 to 4.29.1 in /superset-frontend (@dependabot[bot])
- [#33607](https://github.com/apache/superset/pull/33607) chore: bump FAB to 4.7.0 (@dpgaspar)
- [#33474](https://github.com/apache/superset/pull/33474) chore: remove parse_sql (@betodealmeida)
- [#33515](https://github.com/apache/superset/pull/33515) chore: sql/parse cleanup (@betodealmeida)
- [#33567](https://github.com/apache/superset/pull/33567) chore(alerts & reports): increase Playwright timeout from 30 -> 60 seconds (@sfirke)
- [#33566](https://github.com/apache/superset/pull/33566) docs(docker build): add more packages needed for production features (@sfirke)
- [#33478](https://github.com/apache/superset/pull/33478) chore(deps-dev): bump eslint-config-prettier from 9.1.0 to 10.1.5 in /superset-websocket (@dependabot[bot])
- [#33489](https://github.com/apache/superset/pull/33489) chore(deps-dev): bump babel-loader from 9.2.1 to 10.0.0 in /superset-frontend (@dependabot[bot])
- [#33488](https://github.com/apache/superset/pull/33488) chore(deps): bump less-loader from 11.1.4 to 12.3.0 in /docs (@dependabot[bot])
- [#33477](https://github.com/apache/superset/pull/33477) chore(deps-dev): bump eslint from 9.17.0 to 9.27.0 in /superset-websocket (@dependabot[bot])
- [#33457](https://github.com/apache/superset/pull/33457) chore: remove is_select_query (@betodealmeida)
- [#33549](https://github.com/apache/superset/pull/33549) chore: remove useless-suppression (@betodealmeida)
- [#33539](https://github.com/apache/superset/pull/33539) chore(Icons): Additional Ant Design Icons (@geido)
- [#33469](https://github.com/apache/superset/pull/33469) chore(fab): bumped fab from 4.6.3 to 4.6.4 (@alexandrusoare)
- [#33498](https://github.com/apache/superset/pull/33498) chore(deps): bump ace-builds from 1.37.5 to 1.41.0 in /superset-frontend (@dependabot[bot])
- [#33476](https://github.com/apache/superset/pull/33476) chore(deps): bump debug from 4.4.0 to 4.4.1 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#33491](https://github.com/apache/superset/pull/33491) chore(deps-dev): bump eslint-config-prettier from 10.1.2 to 10.1.5 in /docs (@dependabot[bot])
- [#33492](https://github.com/apache/superset/pull/33492) chore(deps-dev): bump webpack from 5.99.7 to 5.99.8 in /docs (@dependabot[bot])
- [#33490](https://github.com/apache/superset/pull/33490) chore(deps): bump antd from 5.24.9 to 5.25.1 in /docs (@dependabot[bot])
- [#33499](https://github.com/apache/superset/pull/33499) chore(deps-dev): bump @babel/preset-env from 7.26.7 to 7.27.2 in /superset-frontend (@dependabot[bot])
- [#33458](https://github.com/apache/superset/pull/33458) docs: added europace to INTHEWILD.md (@Bierbarbar)
- [#33472](https://github.com/apache/superset/pull/33472) docs(installation): show example of extending Docker image (@sfirke)
- [#32948](https://github.com/apache/superset/pull/32948) chore(deps): bump express from 4.21.2 to 5.1.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#33278](https://github.com/apache/superset/pull/33278) chore(🦾): bump python shillelagh subpackage(s) (@github-actions[bot])
- [#33435](https://github.com/apache/superset/pull/33435) docs: CVEs fixed on 4.1.2 (@sha174n)
- [#33397](https://github.com/apache/superset/pull/33397) chore: Add missing ECharts tags (@DamianPendrak)
- [#30878](https://github.com/apache/superset/pull/30878) docs: fix for role sync issues in case of custom OAuth2 configuration (@ved-kashyap-samsung)
- [#33319](https://github.com/apache/superset/pull/33319) chore(deps): bump antd from 5.24.5 to 5.24.9 in /docs (@dependabot[bot])
- [#33378](https://github.com/apache/superset/pull/33378) chore: regenerate `openapi.json` (@betodealmeida)
- [#33279](https://github.com/apache/superset/pull/33279) chore(🦾): bump python markdown 3.7 -> 3.8 (@github-actions[bot])
- [#33370](https://github.com/apache/superset/pull/33370) chore(🦾): bump python sshtunnel subpackage(s) (@github-actions[bot])
- [#33371](https://github.com/apache/superset/pull/33371) chore(🦾): bump python cryptography 44.0.2 -> 44.0.3 (@github-actions[bot])
- [#33369](https://github.com/apache/superset/pull/33369) chore(🦾): bump python humanize 4.12.2 -> 4.12.3 (@github-actions[bot])
- [#33368](https://github.com/apache/superset/pull/33368) chore(🦾): bump python sqlglot 26.16.2 -> 26.16.4 (@github-actions[bot])
- [#33318](https://github.com/apache/superset/pull/33318) chore(deps): bump swagger-ui-react from 5.20.2 to 5.21.0 in /docs (@dependabot[bot])
- [#33323](https://github.com/apache/superset/pull/33323) chore(deps-dev): update ts-loader requirement from ^9.5.1 to ^9.5.2 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#33311](https://github.com/apache/superset/pull/33311) chore(deps): bump uuid from 11.0.2 to 11.1.0 in /superset-websocket (@dependabot[bot])
- [#33312](https://github.com/apache/superset/pull/33312) chore(deps-dev): bump @eslint/js from 9.17.0 to 9.25.1 in /superset-websocket (@dependabot[bot])
- [#33317](https://github.com/apache/superset/pull/33317) chore(deps): bump less from 4.2.2 to 4.3.0 in /docs (@dependabot[bot])
- [#33350](https://github.com/apache/superset/pull/33350) docs(docker-builds.mdx): clarify dockerize images (@jdorel)
- [#33315](https://github.com/apache/superset/pull/33315) chore(deps-dev): bump eslint-config-prettier from 10.1.1 to 10.1.2 in /docs (@dependabot[bot])
- [#33320](https://github.com/apache/superset/pull/33320) chore(deps-dev): bump typescript from 5.8.2 to 5.8.3 in /docs (@dependabot[bot])
- [#33314](https://github.com/apache/superset/pull/33314) chore(deps-dev): bump eslint-plugin-react from 7.37.4 to 7.37.5 in /docs (@dependabot[bot])
- [#33316](https://github.com/apache/superset/pull/33316) chore(deps-dev): bump webpack from 5.98.0 to 5.99.7 in /docs (@dependabot[bot])
- [#33321](https://github.com/apache/superset/pull/33321) chore(deps): bump @rjsf/validator-ajv8 from 5.24.1 to 5.24.9 in /superset-frontend (@dependabot[bot])
- [#33332](https://github.com/apache/superset/pull/33332) chore(deps-dev): bump @babel/plugin-transform-runtime from 7.25.9 to 7.27.1 in /superset-frontend (@dependabot[bot])
- [#33333](https://github.com/apache/superset/pull/33333) chore(deps): bump react-intersection-observer from 9.15.1 to 9.16.0 in /superset-frontend (@dependabot[bot])
- [#31476](https://github.com/apache/superset/pull/31476) chore(deps): Upgrade pyarrow to 18.1.0 (@phillipleblanc)
- [#33277](https://github.com/apache/superset/pull/33277) chore(🦾): bump python importlib-metadata 8.6.1 -> 8.7.0 (@github-actions[bot])
- [#33280](https://github.com/apache/superset/pull/33280) chore(🦾): bump python mako 1.3.9 -> 1.3.10 (@github-actions[bot])
- [#33281](https://github.com/apache/superset/pull/33281) chore(🦾): bump python pyparsing 3.2.2 -> 3.2.3 (@github-actions[bot])
- [#33257](https://github.com/apache/superset/pull/33257) chore(🦾): bump python celery 5.4.0 -> 5.5.2 (@github-actions[bot])
- [#33259](https://github.com/apache/superset/pull/33259) chore(🦾): bump python packaging 24.2 -> 25.0 (@github-actions[bot])
- [#33260](https://github.com/apache/superset/pull/33260) chore(🦾): bump python deprecation subpackage(s) (@github-actions[bot])
- [#33262](https://github.com/apache/superset/pull/33262) chore(🦾): bump python python-dotenv 1.0.1 -> 1.1.0 (@github-actions[bot])
- [#33263](https://github.com/apache/superset/pull/33263) chore(🦾): bump python pandas subpackage(s) (@github-actions[bot])
- [#33266](https://github.com/apache/superset/pull/33266) chore(🦾): bump python sqlglot 26.11.1 -> 26.16.2 (@github-actions[bot])
- [#33265](https://github.com/apache/superset/pull/33265) chore(🦾): bump python gunicorn subpackage(s) (@github-actions[bot])
- [#33258](https://github.com/apache/superset/pull/33258) chore(🦾): bump python croniter subpackage(s) (@github-actions[bot])
- [#33236](https://github.com/apache/superset/pull/33236) chore: add some utils tests (@eschutho)
- [#33137](https://github.com/apache/superset/pull/33137) docs(installation): compare installation methods (@sfirke)
- [#33210](https://github.com/apache/superset/pull/33210) docs: Add note on SQL execution security considerations (@sha174n)
- [#30047](https://github.com/apache/superset/pull/30047) docs: improve documentation(docs): clarify URL encoding requirement for connection strings (@kalai-logicsoft)
- [#33197](https://github.com/apache/superset/pull/33197) chore(deps-dev): bump http-proxy-middleware from 2.0.7 to 2.0.9 in /superset-frontend (@dependabot[bot])
- [#33173](https://github.com/apache/superset/pull/33173) docs: add a high-level architecture diagram to the docs (@mistercrunch)
- [#33102](https://github.com/apache/superset/pull/33102) chore(deps): bump @babel/runtime from 7.17.2 to 7.27.0 in /superset-frontend/cypress-base (@dependabot[bot])
- [#29828](https://github.com/apache/superset/pull/29828) chore(translations): Update PT-BR language (partial) (@felipegranado)
- [#33079](https://github.com/apache/superset/pull/33079) chore: Update INTHEWILD.md (@Pedro-Gato)
- [#33074](https://github.com/apache/superset/pull/33074) chore: Added Formbricks to INTHEWILD.md (@jobenjada)
- [#32941](https://github.com/apache/superset/pull/32941) chore(deps-dev): bump lerna from 8.1.9 to 8.2.1 in /superset-frontend (@dependabot[bot])
- [#33045](https://github.com/apache/superset/pull/33045) docs: clarify docker-compose-image-tag instructions (@mistercrunch)
- [#33061](https://github.com/apache/superset/pull/33061) chore(helm): bump appVersion to 4.1.2 (@villebro)
- [#33028](https://github.com/apache/superset/pull/33028) chore(deps): bump estree-util-value-to-estree from 3.1.1 to 3.3.3 in /docs (@dependabot[bot])
- [#33018](https://github.com/apache/superset/pull/33018) docs: add WinWin Network（马上赢） to users list (@Ookong)
- [#32890](https://github.com/apache/superset/pull/32890) refactor(IconButton): Refactor IconButton to use Ant Design 5 Card (@Sameerali0)
- [#32999](https://github.com/apache/superset/pull/32999) docs: Update documentation about publishing a dashboard (@hverlin)
- [#33001](https://github.com/apache/superset/pull/33001) chore(Databricks): Display older Databricks driver as legacy (@Vitor-Avila)
- [#32922](https://github.com/apache/superset/pull/32922) chore: bump marshmallow-sqlalchemy to 1.4.0 (@mistercrunch)
- [#32952](https://github.com/apache/superset/pull/32952) chore(deps-dev): bump eslint-config-prettier from 10.0.2 to 10.1.1 in /docs (@dependabot[bot])
- [#32951](https://github.com/apache/superset/pull/32951) chore(deps): bump antd from 5.24.2 to 5.24.5 in /docs (@dependabot[bot])
- [#32950](https://github.com/apache/superset/pull/32950) chore(deps): bump swagger-ui-react from 5.20.0 to 5.20.2 in /docs (@dependabot[bot])
- [#32939](https://github.com/apache/superset/pull/32939) chore(deps-dev): bump @babel/compat-data from 7.26.5 to 7.26.8 in /superset-frontend (@dependabot[bot])
- [#32937](https://github.com/apache/superset/pull/32937) chore(deps-dev): bump css-minimizer-webpack-plugin from 7.0.0 to 7.0.2 in /superset-frontend (@dependabot[bot])
- [#32927](https://github.com/apache/superset/pull/32927) chore(deps): update @types/react-redux requirement from ^7.1.10 to ^7.1.34 in /superset-frontend/plugins/plugin-chart-echarts (@dependabot[bot])
- [#32925](https://github.com/apache/superset/pull/32925) chore(deps-dev): bump @typescript-eslint/parser from 8.19.0 to 8.29.0 in /superset-websocket (@dependabot[bot])
- [#32924](https://github.com/apache/superset/pull/32924) chore(deps-dev): bump ts-jest from 29.2.5 to 29.3.1 in /superset-websocket (@dependabot[bot])
- [#32585](https://github.com/apache/superset/pull/32585) chore(reports): add task for slack channels warm-up (@Usiel)
- [#32888](https://github.com/apache/superset/pull/32888) refactor(jinja macro): Update current_user_roles() macro to fetch roles from existing get_user_roles() method (@bmaquet)
- [#32901](https://github.com/apache/superset/pull/32901) chore(🦾): bump python grpcio 1.68.0 -> 1.71.0 (@github-actions[bot])
- [#32880](https://github.com/apache/superset/pull/32880) refactor(Icons): Add typing support and improve structure (@geido)
- [#32860](https://github.com/apache/superset/pull/32860) chore: Removes unused file (@michael-s-molina)
- [#32822](https://github.com/apache/superset/pull/32822) docs: added a link to badge releases (@Radovenchyk)
- [#32831](https://github.com/apache/superset/pull/32831) chore: updating files for release 4.1.2 (@sadpandajoe)
- [#32826](https://github.com/apache/superset/pull/32826) chore(🦾): bump python humanize 4.12.1 -> 4.12.2 (@github-actions[bot])
- [#32827](https://github.com/apache/superset/pull/32827) chore(🦾): bump python pyparsing 3.2.1 -> 3.2.2 (@github-actions[bot])
- [#32828](https://github.com/apache/superset/pull/32828) chore(🦾): bump python shillelagh subpackage(s) (@github-actions[bot])
- [#32825](https://github.com/apache/superset/pull/32825) chore(🦾): bump python click-option-group 0.5.6 -> 0.5.7 (@github-actions[bot])
- [#32744](https://github.com/apache/superset/pull/32744) chore(🦾): bump python flask-appbuilder subpackage(s) (@github-actions[bot])
- [#32749](https://github.com/apache/superset/pull/32749) chore: replaced the workflow badge link (@Radovenchyk)
- [#32742](https://github.com/apache/superset/pull/32742) chore(🦾): bump python slack-sdk 3.34.0 -> 3.35.0 (@github-actions[bot])
- [#31255](https://github.com/apache/superset/pull/31255) chore(🦾): bump python shillelagh subpackage(s) (@github-actions[bot])
- [#32743](https://github.com/apache/superset/pull/32743) chore(🦾): bump python celery subpackage(s) (@github-actions[bot])
- [#32711](https://github.com/apache/superset/pull/32711) chore(lang): update and fix french translations (@CharlesNkdl)
- [#31251](https://github.com/apache/superset/pull/31251) chore(🦾): bump python flask-appbuilder subpackage(s) (@github-actions[bot])
- [#32112](https://github.com/apache/superset/pull/32112) refactor(Icons): Replaces custom icons with Ant Design 5 icons (@EnxDev)
- [#31247](https://github.com/apache/superset/pull/31247) chore(🦾): bump python greenlet (@github-actions[bot])
- [#32686](https://github.com/apache/superset/pull/32686) chore(helm): bump postgresql image tag in helm values (@mPyKen)
- [#32714](https://github.com/apache/superset/pull/32714) chore(asf): Another `.asf.yaml` touch-up. (@rusackas)
- [#32689](https://github.com/apache/superset/pull/32689) chore(docs): touching up AI styling/text (@rusackas)
- [#32712](https://github.com/apache/superset/pull/32712) chore(asf): trying to fix `.asf.yaml` again to re-enable Discussions (@rusackas)
- [#32710](https://github.com/apache/superset/pull/32710) chore(asf): Removing notifications from `.asf.yaml` - they still don't work :( (@rusackas)
- [#32709](https://github.com/apache/superset/pull/32709) chore(asf): fixing(?) `.asf.yaml` (@rusackas)
- [#32690](https://github.com/apache/superset/pull/32690) docs(api): correct attribute `name` instead of `table` for GET table_metadata in openapi.json (@hainenber)
- [#32688](https://github.com/apache/superset/pull/32688) build(dev-deps): bump prettier to v3.5.3 and follow-up refactor (@hainenber)
- [#32697](https://github.com/apache/superset/pull/32697) chore: add Oxylabs to INTHEWILD.md (@rytis-ulys)
- [#32407](https://github.com/apache/superset/pull/32407) chore(docs): remove customized "Edit this page on GitHub" button (@hainenber)
- [#32580](https://github.com/apache/superset/pull/32580) chore(deps): bump jinja2 from 3.1.5 to 3.1.6 in /superset/translations (@dependabot[bot])
- [#32668](https://github.com/apache/superset/pull/32668) docs: add Hometogo to users list (@PedroMartinSteenstrup)
- [#32623](https://github.com/apache/superset/pull/32623) chore(examples): Touching up Vehicle Sales a bit (@rusackas)
- [#32485](https://github.com/apache/superset/pull/32485) chore: simplify user impersonation (@betodealmeida)
- [#32641](https://github.com/apache/superset/pull/32641) chore: add unique option to index migration utils (@villebro)
- [#32575](https://github.com/apache/superset/pull/32575) chore(🦾): bump python paramiko 3.5.0 -> 3.5.1 (@github-actions[bot])
- [#32639](https://github.com/apache/superset/pull/32639) chore(🦾): bump python croniter 5.0.1 -> 6.0.0 (@github-actions[bot])
- [#32637](https://github.com/apache/superset/pull/32637) chore(🦾): bump python flask-session subpackage(s) (@github-actions[bot])
- [#32638](https://github.com/apache/superset/pull/32638) chore(🦾): bump python celery subpackage(s) (@github-actions[bot])
- [#32636](https://github.com/apache/superset/pull/32636) chore(🦾): bump python importlib-metadata 8.5.0 -> 8.6.1 (@github-actions[bot])
- [#32635](https://github.com/apache/superset/pull/32635) chore(🦾): bump python simplejson 3.19.3 -> 3.20.1 (@github-actions[bot])
- [#32634](https://github.com/apache/superset/pull/32634) chore(🦾): bump python flask-caching 2.3.0 -> 2.3.1 (@github-actions[bot])
- [#32629](https://github.com/apache/superset/pull/32629) chore(🦾): bump python sshtunnel subpackage(s) (@github-actions[bot])
- [#32596](https://github.com/apache/superset/pull/32596) chore: fix precommit for eslint (@mistercrunch)
- [#32596](https://github.com/apache/superset/pull/32596) chore: fix precommit for eslint (@mistercrunch)
- [#32631](https://github.com/apache/superset/pull/32631) chore(🦾): bump python sqlparse 0.5.2 -> 0.5.3 (@github-actions[bot])
- [#32628](https://github.com/apache/superset/pull/32628) chore(🦾): bump python greenlet 3.0.3 -> 3.1.1 (@github-actions[bot])
- [#32632](https://github.com/apache/superset/pull/32632) chore(🦾): bump python humanize 4.11.0 -> 4.12.1 (@github-actions[bot])
- [#32630](https://github.com/apache/superset/pull/32630) chore(🦾): bump python nh3 0.2.19 -> 0.2.21 (@github-actions[bot])
- [#32578](https://github.com/apache/superset/pull/32578) chore(🦾): bump python flask-migrate subpackage(s) (@github-actions[bot])
- [#32577](https://github.com/apache/superset/pull/32577) chore(🦾): bump python pyparsing 3.2.0 -> 3.2.1 (@github-actions[bot])
- [#32581](https://github.com/apache/superset/pull/32581) chore(deps-dev): bump axios from 1.7.7 to 1.8.2 in /superset-embedded-sdk (@dependabot[bot])
- [#32582](https://github.com/apache/superset/pull/32582) chore(deps): bump axios from 1.7.8 to 1.8.2 in /docs (@dependabot[bot])
- [#32583](https://github.com/apache/superset/pull/32583) chore(deps-dev): bump axios from 1.7.9 to 1.8.2 in /superset-frontend (@dependabot[bot])
- [#32603](https://github.com/apache/superset/pull/32603) chore(deps): bump @babel/runtime-corejs3 from 7.26.9 to 7.26.10 in /docs (@dependabot[bot])
- [#32598](https://github.com/apache/superset/pull/32598) chore(deps): bump @babel/helpers from 7.24.5 to 7.26.10 in /docs (@dependabot[bot])
- [#32604](https://github.com/apache/superset/pull/32604) chore(deps): bump @babel/runtime from 7.26.9 to 7.26.10 in /docs (@dependabot[bot])
- [#32607](https://github.com/apache/superset/pull/32607) docs(analytics): actually USING Matomo to track page views/changes (@rusackas)
- [#32605](https://github.com/apache/superset/pull/32605) docs: fix typo in ephemeral envs docs (@mistercrunch)
- [#32600](https://github.com/apache/superset/pull/32600) docs: add information about ephemeral environments (@mistercrunch)
- [#32597](https://github.com/apache/superset/pull/32597) chore: bump postgresql from 15 to 16 (@RealGreenDragon)
- [#32602](https://github.com/apache/superset/pull/32602) chore(deps): bump @babel/helpers from 7.17.2 to 7.26.10 in /superset-frontend/cypress-base (@dependabot[bot])
- [#32576](https://github.com/apache/superset/pull/32576) chore(🦾): bump python slack-sdk 3.33.4 -> 3.34.0 (@github-actions[bot])
- [#32579](https://github.com/apache/superset/pull/32579) chore(🦾): bump python pandas subpackage(s) (@github-actions[bot])
- [#32573](https://github.com/apache/superset/pull/32573) chore(🦾): bump python cryptography 43.0.3 -> 44.0.2 (@mistercrunch)
- [#32561](https://github.com/apache/superset/pull/32561) chore(docs): Add Flowbird to users list (@EmmanuelCbd)
- [#32545](https://github.com/apache/superset/pull/32545) refactor(input): Remove leftover direct usage of Ant Design input (@msyavuz)
- [#32550](https://github.com/apache/superset/pull/32550) chore: bump node to v20.18.3 (@villebro)
- [#32547](https://github.com/apache/superset/pull/32547) docs: add Canonical to INTHEWILD.md (@personofnorank)
- [#32544](https://github.com/apache/superset/pull/32544) chore(Ant Design): Remove unnecessary exports from version 4 (@geido)
- [#31770](https://github.com/apache/superset/pull/31770) chore: add logging to index error (@betodealmeida)
- [#32529](https://github.com/apache/superset/pull/32529) chore: Caching the Slack channels list (@Vitor-Avila)
- [#32527](https://github.com/apache/superset/pull/32527) chore(ci): use npm/yarn lock files where possible (@villebro)
- [#32448](https://github.com/apache/superset/pull/32448) chore(deps-dev): bump eslint-config-prettier from 8.10.0 to 10.0.2 in /docs (@dependabot[bot])
- [#32437](https://github.com/apache/superset/pull/32437) chore(deps-dev): bump globals from 15.9.0 to 16.0.0 in /superset-websocket (@dependabot[bot])
- [#32456](https://github.com/apache/superset/pull/32456) chore(deps): bump markdown-to-jsx from 7.7.3 to 7.7.4 in /superset-frontend (@dependabot[bot])
- [#32517](https://github.com/apache/superset/pull/32517) chore(ci): show more failed pre-commit context (@villebro)
- [#32470](https://github.com/apache/superset/pull/32470) chore(deps-dev): update @babel/types requirement from ^7.26.3 to ^7.26.9 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#32503](https://github.com/apache/superset/pull/32503) chore(deps-dev): bump @typescript-eslint/eslint-plugin from 8.19.0 to 8.26.0 in /superset-websocket (@dependabot[bot])
- [#32501](https://github.com/apache/superset/pull/32501) chore: enable dependabot using uv for auto-bumping python packages (@mistercrunch)
- [#30657](https://github.com/apache/superset/pull/30657) chore: various markdown warnings resolved (@CodeWithEmad)
- [#32453](https://github.com/apache/superset/pull/32453) chore(deps): bump @deck.gl/react from 9.1.0 to 9.1.4 in /superset-frontend (@dependabot[bot])
- [#32460](https://github.com/apache/superset/pull/32460) chore(deps-dev): bump @babel/types from 7.26.7 to 7.26.9 in /superset-frontend (@dependabot[bot])
- [#32461](https://github.com/apache/superset/pull/32461) chore(deps): bump @rjsf/utils from 5.24.1 to 5.24.3 in /superset-frontend (@dependabot[bot])
- [#32462](https://github.com/apache/superset/pull/32462) chore(deps): bump chrono-node from 2.7.7 to 2.7.8 in /superset-frontend (@dependabot[bot])
- [#32440](https://github.com/apache/superset/pull/32440) chore(deps-dev): bump @types/jsonwebtoken from 9.0.6 to 9.0.9 in /superset-websocket (@dependabot[bot])
- [#32454](https://github.com/apache/superset/pull/32454) chore(deps): bump swagger-ui-react from 5.19.0 to 5.20.0 in /docs (@dependabot[bot])
- [#32476](https://github.com/apache/superset/pull/32476) chore(deps-dev): bump @types/lodash from 4.17.14 to 4.17.16 in /superset-frontend (@dependabot[bot])
- [#32447](https://github.com/apache/superset/pull/32447) chore(deps): bump antd from 5.24.1 to 5.24.2 in /docs (@dependabot[bot])
- [#32449](https://github.com/apache/superset/pull/32449) chore(deps-dev): bump webpack from 5.97.1 to 5.98.0 in /docs (@dependabot[bot])
- [#32452](https://github.com/apache/superset/pull/32452) chore(deps-dev): bump typescript from 5.1.6 to 5.8.2 in /docs (@dependabot[bot])
- [#32087](https://github.com/apache/superset/pull/32087) chore(deps-dev): bump @docusaurus/tsconfig from 3.6.3 to 3.7.0 in /docs (@dependabot[bot])
- [#32421](https://github.com/apache/superset/pull/32421) docs: add SingleStore to the users list (@tjain-singlestore)
- [#32385](https://github.com/apache/superset/pull/32385) docs(config): fill in commonly connection string for Oracle, Presto and SQL Server databases (@hainenber)
- [#32322](https://github.com/apache/superset/pull/32322) build(deps): bump major versions for `math-expression-evaluator` and `fetch-mock` + clean up obsolete dev/override packages (@hainenber)
- [#32393](https://github.com/apache/superset/pull/32393) chore(docs): fix typos (@omahs)
- [#32396](https://github.com/apache/superset/pull/32396) docs: add shipmnts to users list (@ekansh-shipmnts)
- [#32380](https://github.com/apache/superset/pull/32380) chore(docs): update instructions for pypi distribution (@sadpandajoe)
- [#32379](https://github.com/apache/superset/pull/32379) docs(intro): broaden link to installation options (@sfirke)
- [#32334](https://github.com/apache/superset/pull/32334) chore: Upgrade AG Grid to use tree shaking (@kgabryje)
- [#32365](https://github.com/apache/superset/pull/32365) chore(cleanup): removing accidentally committed package/lock files. (@rusackas)
- [#32313](https://github.com/apache/superset/pull/32313) refactor(DrillDetailTableControls):  Upgrade DrillDetailTableControls component to Ant Design 5  (@EnxDev)
- [#32363](https://github.com/apache/superset/pull/32363) chore(tests): converting enzyme to RTL, part 3 (@rusackas)
- [#32314](https://github.com/apache/superset/pull/32314) refactor(DatabaseSelector): Changes the imported types from antd-4 to antdv-5 (@EnxDev)
- [#32349](https://github.com/apache/superset/pull/32349) chore(docs): Fix typo in security.mdx (@amineBouilzmin)
- [#32323](https://github.com/apache/superset/pull/32323) ci(type-checking): run type-checking-frontend hook sequentially (@alveifbklsiu259)
- [#32341](https://github.com/apache/superset/pull/32341) chore(build): reduce Lodash usage in `superset-frontend` (@hainenber)
- [#32302](https://github.com/apache/superset/pull/32302) chore(duckdb): Bump duckdb-engine, duckdb versions (@guenp)
- [#32330](https://github.com/apache/superset/pull/32330) chore(deps): bump swagger-ui-react from 5.18.2 to 5.19.0 in /docs (@dependabot[bot])
- [#32329](https://github.com/apache/superset/pull/32329) chore(deps): bump antd from 5.22.7 to 5.24.1 in /docs (@dependabot[bot])
- [#32327](https://github.com/apache/superset/pull/32327) chore(deps): bump @docsearch/react from 3.8.2 to 3.9.0 in /docs (@dependabot[bot])
- [#32319](https://github.com/apache/superset/pull/32319) chore(readme): updating video on Readme page. (@rusackas)
- [#32326](https://github.com/apache/superset/pull/32326) chore(docs): Add RIADVICE to companies using Superset (@GhaziTriki)
- [#31921](https://github.com/apache/superset/pull/31921) docs: various enhancements across `/docs` workspace  (@hainenber)
- [#32066](https://github.com/apache/superset/pull/32066) chore(deps): bump core-js from 3.39.0 to 3.40.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#32088](https://github.com/apache/superset/pull/32088) chore(deps-dev): bump @docusaurus/module-type-aliases from 3.6.3 to 3.7.0 in /docs (@dependabot[bot])
- [#32316](https://github.com/apache/superset/pull/32316) chore(code owners): adding @mistercrunch to cypress/e2e code owners (@rusackas)
- [#32226](https://github.com/apache/superset/pull/32226) chore(tests): Trying to kill enzyme, part 2 (more RTL!) (@rusackas)
- [#32090](https://github.com/apache/superset/pull/32090) chore(deps-dev): bump typescript from 5.7.2 to 5.7.3 in /docs (@dependabot[bot])
- [#32103](https://github.com/apache/superset/pull/32103) chore(deps-dev): bump @babel/preset-env from 7.26.0 to 7.26.7 in /superset-frontend (@dependabot[bot])
- [#32259](https://github.com/apache/superset/pull/32259) chore(be/deps): add comments for un-greppable Python dependencies (@hainenber)
- [#32270](https://github.com/apache/superset/pull/32270) chore(deps): bump dompurify from 3.2.3 to 3.2.4 in /superset-frontend (@dependabot[bot])
- [#32243](https://github.com/apache/superset/pull/32243) build(fe/dev-deps): remove unused `esbuild` dev deps (@hainenber)
- [#32236](https://github.com/apache/superset/pull/32236) chore(deps): bump cryptography from 43.0.3 to 44.0.1 (@dependabot[bot])
- [#32142](https://github.com/apache/superset/pull/32142) docs(api): Improve api documentation for dashboard endpoints(filter_state, permalink, embedded) (@msyavuz)
- [#32235](https://github.com/apache/superset/pull/32235) chore(backend): replace insecure `shortid` usage for native filter migration with native `uuid` Python implementation (@hainenber)
- [#32207](https://github.com/apache/superset/pull/32207) chore: Working toward killing enzyme and cleaning up test noise. (@rusackas)
- [#31634](https://github.com/apache/superset/pull/31634) chore(fe): migrate 4 Enzyme-based tests to RTL (@hainenber)
- [#32180](https://github.com/apache/superset/pull/32180) docs: Permissions 'can this form get on UserInfoEditView' and 'can this form get on UserInfoEditView' are not associated with Aplha and Gamma by default (@xavier-GitHub76)
- [#32192](https://github.com/apache/superset/pull/32192) chore(ci): consolidate Node version reference in CI to associated `.nvmrc` (@hainenber)
- [#32010](https://github.com/apache/superset/pull/32010) chore: migrating easy-to-migrate AntD vanilla components (@mistercrunch)
- [#32206](https://github.com/apache/superset/pull/32206) docs(docker-compose): remove extra backticks (@jonathanmv)
- [#31973](https://github.com/apache/superset/pull/31973) refactor(Popover): Upgrade Popover to Antd5 (@alexandrusoare)
- [#31972](https://github.com/apache/superset/pull/31972) refactor(Dropdown): Migrate Dropdown to Ant Design 5 (@msyavuz)
- [#32188](https://github.com/apache/superset/pull/32188) docs(typo): PostgresQL corrected to PostgreSQL (@0xasritha)
- [#32157](https://github.com/apache/superset/pull/32157) chore: add query context data tests (@eschutho)
- [#32085](https://github.com/apache/superset/pull/32085) chore(deps): bump less from 4.2.1 to 4.2.2 in /docs (@dependabot[bot])
- [#32171](https://github.com/apache/superset/pull/32171) docs: fix typo in docker compose (@ChrisChinchilla)
- [#31999](https://github.com/apache/superset/pull/31999) docs: incorrect psycopg2 package in k8s install instructions (@bensku)
