/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.fs.AbstractFileSystem;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class InMemoryFileSystem
extends AbstractFileSystem {
    private final Map<FileRef, ByteArrayOutputStream> files = Maps.newHashMap();
    private final Map<FileRef, Long> timestamps = Maps.newHashMap();
    private long currentTime = 0L;
    private final FileStore store = new FileStore(){

        @Override
        public Charset getDefaultCharset() {
            return InMemoryFileSystem.this.getDefaultCharset();
        }

        @Override
        public URI toUri(FileRef fileRef) {
            return URI.create("inmem://" + fileRef.getName());
        }

        @Override
        public InputStream openInputStream(FileRef fileRef) throws IOException {
            ByteArrayOutputStream file = (ByteArrayOutputStream)InMemoryFileSystem.this.files.get(fileRef);
            if (file == null) {
                throw new FileNotFoundException();
            }
            return new ByteArrayInputStream(file.toByteArray());
        }

        @Override
        public OutputStream openOutputStream(FileRef fileRef) {
            ByteArrayOutputStream file = new ByteArrayOutputStream();
            InMemoryFileSystem.this.files.put(fileRef, file);
            if (InMemoryFileSystem.this.currentTime > 0L) {
                InMemoryFileSystem.this.timestamps.put(fileRef, InMemoryFileSystem.this.getCurrentTime());
            } else {
                InMemoryFileSystem.this.timestamps.remove(fileRef);
            }
            return file;
        }

        @Override
        public String toFilename(FileRef fileRef) {
            return fileRef.getName();
        }

        @Override
        public String toRelativeFilename(FileRef fileRef) {
            return this.toFilename(fileRef);
        }

        @Override
        public long getLastModified(FileRef fileRef) {
            Long result = (Long)InMemoryFileSystem.this.timestamps.get(fileRef);
            return result == null ? 0L : result;
        }

        @Override
        public boolean delete(FileRef fileRef) {
            if (InMemoryFileSystem.this.files.remove(fileRef) != null) {
                InMemoryFileSystem.this.timestamps.remove(fileRef);
                return true;
            }
            return false;
        }

        public String toString() {
            return "InMemoryFileSystem.FileStore@" + System.identityHashCode(this);
        }
    };
    private static Pattern LIST_DELIMITER_PATTERN = Pattern.compile(":");

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long newCurrentTime) {
        this.currentTime = newCurrentTime;
    }

    @Override
    protected FileStore getFileStore() {
        return this.store;
    }

    @Override
    public FileRef parseFilename(String filename) {
        return new FileRef(this.store, filename);
    }

    @Override
    protected Pattern getFilenameListDelimiter() {
        return LIST_DELIMITER_PATTERN;
    }

    public Set<FileRef> getManifest() {
        return Collections.unmodifiableSet(this.files.keySet());
    }

    @Override
    public Charset getDefaultCharset() {
        return Charsets.US_ASCII;
    }
}

